/* xdaliclock - a melting digital clock
 * Copyright (c) 1991-2010 Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#ifdef USE_IPHONE

# import <Foundation/Foundation.h>
# import <UIKit/UIKit.h>
# import <OpenGLES/EAGL.h>
# import <OpenGLES/ES1/gl.h>
# import <OpenGLES/ES1/glext.h>
# import <QuartzCore/QuartzCore.h>

# define NSView  UIView
# define NSRect  CGRect
# define NSSize  CGSize
# define NSColor UIColor
# define NSImage UIImage
# define colorWithCalibratedHue colorWithHue
# define NSUserDefaultsController NSUserDefaults
# define NSArchiver NSKeyedArchiver
# define NSOpenGLContext EAGLContext
# define glOrtho glOrthof

#else  /* !USE_IPHONE */

# import <Cocoa/Cocoa.h>
# import <AppKit/NSOpenGL.h>
# import <OpenGL/OpenGL.h>
# import <OpenGL/gl.h>

#endif /* !USE_IPHONE */

#import "xdaliclock.h"

typedef struct touch_data touch_data;

@interface DaliClockView : NSView
{
  dali_config config;

  unsigned char *pixmap;

#ifdef USE_IPHONE

  EAGLContext *eagl_ctx;
  /* The OpenGL names for the framebuffer and renderbuffer used to
     render to this view. */
  GLuint gl_framebuffer, gl_renderbuffer;
  UITextView *aboutBox;
  UIViewController *viewController;
  touch_data *touchData;

# else /* !USE_IPHONE */

  NSOpenGLContext *ogl_ctx;      // OpenGL rendering context

# endif /* !USE_IPHONE */

  NSTimer *clockTimer;
  NSTimer *colorTimer;
  NSTimer *dateTimer;
  float autoDateInterval;

  BOOL ownWindow;
  BOOL constrainSizes;
  BOOL usesCountdownTimer;
  NSDate *countdownDate;

  NSColor *fg;
  NSColor *bg;
  NSColor *initialForegroundColor;
  NSColor *initialBackgroundColor;
}

+ (void)initializeDefaults:(NSUserDefaultsController *)controller;
+ (NSUserDefaultsController *)userDefaultsController;

- (void)setInitialForegroundColor:(NSColor *)c;
- (void)setInitialBackgroundColor:(NSColor *)c;

- (void)setOwnWindow:(BOOL)own_p;
- (void)setConstrainSizes:(BOOL)constrain_p;
- (void)setAutoDate:(float)interval;
- (IBAction) aboutClick: (id)sender;

#ifdef USE_IPHONE
- (void)setViewController:(UIViewController*)ctl;
- (void)setFrameSize:(NSSize)newSize;
- (void)showBlurb:(NSString *)text;
#endif /* !USE_IPHONE */


// Start timers
- (void)clockTick;
- (void)colorTick;
- (void)dateTick;


/* Bindable Properties:
     hourStyle
     timeStyle
     dateStyle
     cycleSpeed
     usesCountdownTimer
     countdownDate
     initialForegroundColor
     initialBackgroundColor
*/


#ifdef USE_IPHONE
@property (nonatomic) int hourStyle;
@property (nonatomic) int timeStyle;
@property (nonatomic) int dateStyle;
@property (nonatomic) float cycleSpeed;
@property (nonatomic) int usesCountdownTimer;
@property (nonatomic, retain) NSDate *countdownDate;
#endif /* USE_IPHONE */

@end
