/* -*-Mode: C;-*-
 *
 * Copyright (C) 1999, 2000, Joshua P. MacDonald <jmacd@CS.Berkeley.EDU>
 * and The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: edsio.el,v 1.10 2001/05/15 23:34:05 jmacd Exp $
 */

#include "xdelta.h"

#include <errno.h>

/* Declarations. */

static const char* Xd_String_event_field_to_string (GenericEvent* ev, gint field);
static const char* Xd_HandleIntInt_event_field_to_string (GenericEvent* ev, gint field);
static const char* Xd_HandleStringString_event_field_to_string (GenericEvent* ev, gint field);
static const char* Xd_Int_event_field_to_string (GenericEvent* ev, gint field);
static void print_spaces (guint n) { int i; for (i = 0; i < n; i += 1) g_print (" "); }


/* initialize this library. */

gboolean
xd_edsio_init (void)
{
  static gboolean once = FALSE;
  static gboolean result = FALSE;
  if (once) return result;
  once = TRUE;
  eventdelivery_initialize_event_def (EC_XdBackwardCompatibilityModeValue, EL_Information, EF_None, "BackwardCompatibilityMode", "Reading a version ${0} delta control", & Xd_String_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdStreamLengthFailedValue, EL_Error, EF_None, "StreamLengthFailed", "${0}: Length validation failed, expected: ${1}, received: ${2}", & Xd_HandleIntInt_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdStreamChecksumFailedValue, EL_Error, EF_None, "StreamChecksumFailed", "${0}: Checksum validation failed, expected: ${1}, received: ${2}", & Xd_HandleStringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdIncompatibleDeltaValue, EL_Error, EF_None, "IncompatibleDelta", "The delta was not produced according by the `xdelta delta' command", NULL);
  eventdelivery_initialize_event_def (EC_XdInvalidRsyncCacheValue, EL_Error, EF_None, "InvalidRsyncCache", "The rsync checksum cache is corrupt", NULL);
  eventdelivery_initialize_event_def (EC_XdInvalidControlValue, EL_Error, EF_None, "InvalidControl", "Delta control is corrupt", NULL);
  eventdelivery_initialize_event_def (EC_XdOutOfRangeSourceIndexValue, EL_Error, EF_None, "OutOfRangeSourceIndex", "Instruction references out-of-range source index: ${0}", & Xd_Int_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdTooManySourcesValue, EL_Error, EF_None, "TooManySources", "Too many input sources", NULL);
  eventdelivery_initialize_event_def (EC_XdTooFewSourcesValue, EL_Error, EF_None, "TooFewSources", "Too few input sources", NULL);
  serializeio_initialize_type ("ST_XdeltaInstruction", ST_XdeltaInstruction, &unserialize_xdeltainstruction_internal, &serialize_xdeltainstruction_obj_internal, &serializeio_count_xdeltainstruction_obj, &serializeio_print_xdeltainstruction_obj);
  serializeio_initialize_type ("ST_XdeltaControl", ST_XdeltaControl, &unserialize_xdeltacontrol_internal, &serialize_xdeltacontrol_obj_internal, &serializeio_count_xdeltacontrol_obj, &serializeio_print_xdeltacontrol_obj);
  serializeio_initialize_type ("ST_XdeltaChecksum", ST_XdeltaChecksum, &unserialize_xdeltachecksum_internal, &serialize_xdeltachecksum_obj_internal, &serializeio_count_xdeltachecksum_obj, &serializeio_print_xdeltachecksum_obj);
  edsio_library_register (3, "xd");
  result = TRUE;
  return TRUE;
};

/* XdeltaChecksum Count
 */

guint
serializeio_count_xdeltachecksum (guint16 high, guint16 low) {
  guint size = sizeof (SerialXdeltaChecksum);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdeltachecksum_obj (SerialXdeltaChecksum const* obj) {
  return serializeio_count_xdeltachecksum (obj->high, obj->low);
}

/* XdeltaChecksum Print
 */

void
serializeio_print_xdeltachecksum_obj (SerialXdeltaChecksum* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("high:uint16 = ");
  g_print ("%d\n", obj->high);
  print_spaces (indent_spaces);
  g_print ("low:uint16 = ");
  g_print ("%d\n", obj->low);
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* XdeltaChecksum Serialize
 */

gboolean
serialize_xdeltachecksum_internal (SerialSink *sink, guint16 high, guint16 low)
{
  if (! (* sink->next_uint16) (sink, high)) goto bail;
  if (! (* sink->next_uint16) (sink, low)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltachecksum_obj_internal (SerialSink *sink, SerialXdeltaChecksum* obj)
{
  return serialize_xdeltachecksum_internal (sink, obj->high, obj->low);
}

gboolean
serialize_xdeltachecksum (SerialSink *sink, guint16 high, guint16 low)
{
  if (! (* sink->sink_type) (sink, ST_XdeltaChecksum, serializeio_count_xdeltachecksum (high, low), TRUE)) goto bail;
  if (! serialize_xdeltachecksum_internal (sink, high, low)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltachecksum_obj (SerialSink *sink, const SerialXdeltaChecksum* obj) {

  return serialize_xdeltachecksum (sink, obj->high, obj->low);
}

/* XdeltaChecksum Unserialize
 */

gboolean
unserialize_xdeltachecksum_internal_noalloc (SerialSource *source, SerialXdeltaChecksum* result)
{
  if (! (* source->next_uint16) (source, &result->high)) goto bail;
  if (! (* source->next_uint16) (source, &result->low)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltachecksum_internal (SerialSource *source, SerialXdeltaChecksum** result)
{
  SerialXdeltaChecksum* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialXdeltaChecksum));
  if (! unser) goto bail;
  if (! unserialize_xdeltachecksum_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltachecksum (SerialSource *source, SerialXdeltaChecksum** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_XdeltaChecksum) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_xdeltachecksum_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* XdeltaControl Count
 */

guint
serializeio_count_xdeltacontrol (guint32 length, guint32 src_types_len, guint32 const* src_types, guint32 inst_len, SerialXdeltaInstruction const* inst) {
  guint size = sizeof (SerialXdeltaControl);
  ALIGN_8 (size);
  ALIGN_8 (size);
  {
    gint i;
    size += 8; /* alignment */
    for (i = 0; i < src_types_len; i += 1)
      {
        size += sizeof (guint32);
      }
  }
  ALIGN_8 (size);
  {
    gint i;
    size += 8; /* alignment */
    for (i = 0; i < inst_len; i += 1)
      {
        size += serializeio_count_xdeltainstruction_obj (& (inst[i]));
      }
  }
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdeltacontrol_obj (SerialXdeltaControl const* obj) {
  return serializeio_count_xdeltacontrol (obj->length, obj->src_types_len, obj->src_types, obj->inst_len, obj->inst);
}

/* XdeltaControl Print
 */

void
serializeio_print_xdeltacontrol_obj (SerialXdeltaControl* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("length:uint = ");
  g_print ("%d\n", obj->length);
  print_spaces (indent_spaces);
  g_print ("src_types:(array uint) = ");
  g_print ("{\n");
  {
    gint i;
    indent_spaces += 2;
    for (i = 0; i < obj->src_types_len; i += 1)
      {
        print_spaces (indent_spaces);
        g_print ("%d: ", i);
          g_print ("%d\n", (obj->src_types[i]));
    }
  }
  print_spaces (indent_spaces);
  indent_spaces -= 2;
  g_print ("}\n");
  print_spaces (indent_spaces);
  g_print ("inst:(array XdeltaInstruction) = ");
  g_print ("{\n");
  {
    gint i;
    indent_spaces += 2;
    for (i = 0; i < obj->inst_len; i += 1)
      {
        print_spaces (indent_spaces);
        g_print ("%d: ", i);
          serializeio_print_xdeltainstruction_obj (& (obj->inst[i]), indent_spaces + 2);
    }
  }
  print_spaces (indent_spaces);
  indent_spaces -= 2;
  g_print ("}\n");
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* XdeltaControl Serialize
 */

gboolean
serialize_xdeltacontrol_internal (SerialSink *sink, guint32 length, guint32 src_types_len, guint32 const* src_types, guint32 inst_len, SerialXdeltaInstruction const* inst)
{
  if (! (* sink->next_uint) (sink, length)) goto bail;
  {
    gint i;
    if (! (* sink->next_uint) (sink, src_types_len)) goto bail;
    for (i = 0; i < src_types_len; i += 1)
      {
        if (! (* sink->next_uint) (sink, (src_types[i]))) goto bail;
      }
  }
  {
    gint i;
    if (! (* sink->next_uint) (sink, inst_len)) goto bail;
    for (i = 0; i < inst_len; i += 1)
      {
        if (! serialize_xdeltainstruction_internal (sink, (inst[i]).index, (inst[i]).offset, (inst[i]).length)) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltacontrol_obj_internal (SerialSink *sink, SerialXdeltaControl* obj)
{
  return serialize_xdeltacontrol_internal (sink, obj->length, obj->src_types_len, obj->src_types, obj->inst_len, obj->inst);
}

gboolean
serialize_xdeltacontrol (SerialSink *sink, guint32 length, guint32 src_types_len, guint32 const* src_types, guint32 inst_len, SerialXdeltaInstruction const* inst)
{
  if (! (* sink->sink_type) (sink, ST_XdeltaControl, serializeio_count_xdeltacontrol (length, src_types_len, src_types, inst_len, inst), TRUE)) goto bail;
  if (! serialize_xdeltacontrol_internal (sink, length, src_types_len, src_types, inst_len, inst)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltacontrol_obj (SerialSink *sink, const SerialXdeltaControl* obj) {

  return serialize_xdeltacontrol (sink, obj->length, obj->src_types_len, obj->src_types, obj->inst_len, obj->inst);
}

/* XdeltaControl Unserialize
 */

gboolean
unserialize_xdeltacontrol_internal_noalloc (SerialSource *source, SerialXdeltaControl* result)
{
  if (! (* source->next_uint) (source, &result->length)) goto bail;
  {
    gint i;
    if (! (* source->next_uint) (source, &result->src_types_len)) goto bail;
    if (! (result->src_types = serializeio_source_alloc (source, sizeof (guint32) * result->src_types_len))) goto bail;
    for (i = 0; i < result->src_types_len; i += 1)
      {
        if (! (* source->next_uint) (source, &(result->src_types[i]))) goto bail;
      }
  }
  {
    gint i;
    if (! (* source->next_uint) (source, &result->inst_len)) goto bail;
    if (! (result->inst = serializeio_source_alloc (source, sizeof (SerialXdeltaInstruction) * result->inst_len))) goto bail;
    for (i = 0; i < result->inst_len; i += 1)
      {
        if (! unserialize_xdeltainstruction_internal_noalloc (source, &(result->inst[i]))) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltacontrol_internal (SerialSource *source, SerialXdeltaControl** result)
{
  SerialXdeltaControl* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialXdeltaControl));
  if (! unser) goto bail;
  if (! unserialize_xdeltacontrol_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltacontrol (SerialSource *source, SerialXdeltaControl** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_XdeltaControl) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_xdeltacontrol_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* XdeltaInstruction Count
 */

guint
serializeio_count_xdeltainstruction (guint32 index, guint32 offset, guint32 length) {
  guint size = sizeof (SerialXdeltaInstruction);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdeltainstruction_obj (SerialXdeltaInstruction const* obj) {
  return serializeio_count_xdeltainstruction (obj->index, obj->offset, obj->length);
}

/* XdeltaInstruction Print
 */

void
serializeio_print_xdeltainstruction_obj (SerialXdeltaInstruction* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("index:uint = ");
  g_print ("%d\n", obj->index);
  print_spaces (indent_spaces);
  g_print ("offset:uint = ");
  g_print ("%d\n", obj->offset);
  print_spaces (indent_spaces);
  g_print ("length:uint = ");
  g_print ("%d\n", obj->length);
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* XdeltaInstruction Serialize
 */

gboolean
serialize_xdeltainstruction_internal (SerialSink *sink, guint32 index, guint32 offset, guint32 length)
{
  if (! (* sink->next_uint) (sink, index)) goto bail;
  if (! (* sink->next_uint) (sink, offset)) goto bail;
  if (! (* sink->next_uint) (sink, length)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltainstruction_obj_internal (SerialSink *sink, SerialXdeltaInstruction* obj)
{
  return serialize_xdeltainstruction_internal (sink, obj->index, obj->offset, obj->length);
}

gboolean
serialize_xdeltainstruction (SerialSink *sink, guint32 index, guint32 offset, guint32 length)
{
  if (! (* sink->sink_type) (sink, ST_XdeltaInstruction, serializeio_count_xdeltainstruction (index, offset, length), TRUE)) goto bail;
  if (! serialize_xdeltainstruction_internal (sink, index, offset, length)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltainstruction_obj (SerialSink *sink, const SerialXdeltaInstruction* obj) {

  return serialize_xdeltainstruction (sink, obj->index, obj->offset, obj->length);
}

/* XdeltaInstruction Unserialize
 */

gboolean
unserialize_xdeltainstruction_internal_noalloc (SerialSource *source, SerialXdeltaInstruction* result)
{
  if (! (* source->next_uint) (source, &result->index)) goto bail;
  if (! (* source->next_uint) (source, &result->offset)) goto bail;
  if (! (* source->next_uint) (source, &result->length)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltainstruction_internal (SerialSource *source, SerialXdeltaInstruction** result)
{
  SerialXdeltaInstruction* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialXdeltaInstruction));
  if (! unser) goto bail;
  if (! unserialize_xdeltainstruction_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltainstruction (SerialSource *source, SerialXdeltaInstruction** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_XdeltaInstruction) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_xdeltainstruction_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

void
xd_generate_void_event_internal (XdVoidEventCode _code, const char* _srcfile, gint _srcline)
{
  XdVoidEvent *_e = g_new0 (XdVoidEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const XdVoidEventCode EC_XdTooFewSources = { EC_XdTooFewSourcesValue };

const XdVoidEventCode EC_XdTooManySources = { EC_XdTooManySourcesValue };

void
xd_generate_int_event_internal (XdIntEventCode _code, const char* _srcfile, gint _srcline, int index)
{
  XdIntEvent *_e = g_new0 (XdIntEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->index = index;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Xd_Int_event_field_to_string (GenericEvent* ev, gint field)
{
  XdIntEvent* it = (XdIntEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_int_to_string (it->index);
    default: abort ();
    }
}

const XdIntEventCode EC_XdOutOfRangeSourceIndex = { EC_XdOutOfRangeSourceIndexValue };

const XdVoidEventCode EC_XdInvalidControl = { EC_XdInvalidControlValue };

const XdVoidEventCode EC_XdInvalidRsyncCache = { EC_XdInvalidRsyncCacheValue };

const XdVoidEventCode EC_XdIncompatibleDelta = { EC_XdIncompatibleDeltaValue };

void
xd_generate_handlestringstring_event_internal (XdHandleStringStringEventCode _code, const char* _srcfile, gint _srcline, FileHandle* stream, const char* expected, const char* received)
{
  XdHandleStringStringEvent *_e = g_new0 (XdHandleStringStringEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->stream = stream;
  _e->expected = expected;
  _e->received = received;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Xd_HandleStringString_event_field_to_string (GenericEvent* ev, gint field)
{
  XdHandleStringStringEvent* it = (XdHandleStringStringEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_handle_to_string (it->stream);
    case 1: return eventdelivery_string_to_string (it->expected);
    case 2: return eventdelivery_string_to_string (it->received);
    default: abort ();
    }
}

const XdHandleStringStringEventCode EC_XdStreamChecksumFailed = { EC_XdStreamChecksumFailedValue };

void
xd_generate_handleintint_event_internal (XdHandleIntIntEventCode _code, const char* _srcfile, gint _srcline, FileHandle* stream, int expected, int received)
{
  XdHandleIntIntEvent *_e = g_new0 (XdHandleIntIntEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->stream = stream;
  _e->expected = expected;
  _e->received = received;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Xd_HandleIntInt_event_field_to_string (GenericEvent* ev, gint field)
{
  XdHandleIntIntEvent* it = (XdHandleIntIntEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_handle_to_string (it->stream);
    case 1: return eventdelivery_int_to_string (it->expected);
    case 2: return eventdelivery_int_to_string (it->received);
    default: abort ();
    }
}

const XdHandleIntIntEventCode EC_XdStreamLengthFailed = { EC_XdStreamLengthFailedValue };

void
xd_generate_string_event_internal (XdStringEventCode _code, const char* _srcfile, gint _srcline, const char* version)
{
  XdStringEvent *_e = g_new0 (XdStringEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->version = version;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Xd_String_event_field_to_string (GenericEvent* ev, gint field)
{
  XdStringEvent* it = (XdStringEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_string_to_string (it->version);
    default: abort ();
    }
}

const XdStringEventCode EC_XdBackwardCompatibilityMode = { EC_XdBackwardCompatibilityModeValue };

