/* -*-Mode: C++;-*-
 * $Id: xdfs_list.h 1.1 Tue, 24 Apr 2001 21:44:53 -0700 jmacd $
 *
 * Copyright (C) 1998, 1999, 2000, Joshua P. MacDonald
 * <jmacd@CS.Berkeley.EDU> and The Regents of the University of
 * California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _XDFS_LIST_H_
#define _XDFS_LIST_H_

class CIRCULAR_LINKS;

class CIRCULAR_LINK
{
    friend class CIRCULAR_LINKS;

    CIRCULAR_LINK (CIRCULAR_LINKS &clnks,
		   const MKEY     &mkey);

    void reset    ();
    int  get      (MAJORC &node);
    int  link     (const MAJORC &node, int flags);
    int  init_lnk ();

    CIRCULAR_LINKS &_clnks;
    const MKEY     &_mkey;
    NODEC           _lnk;
    MAJORC          _lnknode;
};

class CIRCULAR_LINKS
{
    friend class CIRCULAR_LIST;
    friend class CIRCULAR_LINK;

    CIRCULAR_LINKS (CIRCULAR_LIST &cll,
		    const MAJORC  &node);

    CIRCULAR_LIST &_cll;
    MAJORC         _node;
    CIRCULAR_LINK  _next;
    CIRCULAR_LINK  _prev;

    int  link_next (const MAJORC &nextnode,
		    int           flags) { return _next.link (nextnode, flags); }
    int  link_prev (const MAJORC &prevnode,
		    int           flags) { return _prev.link (prevnode, flags); }

    int  get_prev  (MAJORC       &node) { return _prev.get (node); }
    int  get_next  (MAJORC       &node) { return _next.get (node); }

    int  move_next (MAJORC       &node);
    int  reset     (const MAJORC &node);
};

class CIRCULAR_LIST
{
    enum CIRCULAR_POS
    {
	POS_HEADNODE = 1,
	POS_PREVNODE = 2,
	POS_NEXTNODE = 3,
    };

    friend class CIRCULAR_LINKS;

    MAJORC          _head;
    MKEY            _nextmk;
    MKEY            _prevmk;

    int insert  (CIRCULAR_POS pos, const MAJORC &item);
    int erase   (CIRCULAR_POS pos, MAJORC &item);
    int peek    (CIRCULAR_POS pos, MAJORC &item);
    int get_pos (CIRCULAR_POS pos, MAJORC &node);

public:

    CIRCULAR_LIST ();

    int  create     (const MAJORC &head);
    int  open       (const MAJORC &head);
    int  find_nth   (int           N,
		     MAJORC       &node);

    int  push_back  (const MAJORC &item) { return insert (POS_HEADNODE, item); }
    int  push_front (const MAJORC &item) { return insert (POS_NEXTNODE, item); }

    int  pop_back   (MAJORC       &item) { return erase  (POS_PREVNODE, item); }
    int  pop_front  (MAJORC       &item) { return erase  (POS_NEXTNODE, item); }

    int  peek_back  (MAJORC       &item) { return peek   (POS_PREVNODE, item); }
    int  peek_front (MAJORC       &item) { return peek   (POS_NEXTNODE, item); }

    MAJORC _iter;

    bool next       (MAJORC       &node);
};

#endif
