#include <db_cxx.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include "xdfs_cpp.h"

class ENDDBT
    : public COMDBT
{
public:

    ENDDBT (guint32 ival)
	: COMDBT (& _val, sizeof (_val))
    {
	_val = g_htonl (ival);
    }

    ENDDBT ()
	: COMDBT (& _val, sizeof (_val))
    {
    }

    guint32 val () { return g_ntohl (_val); }

    void reset () const { }

private:

    guint32 _val;
};

int
curs_db_set (DbTxn *txn, Db *dbp, guint32 key1, guint32 key2)
{
    int ret;
    Dbc *dbc;
    ENDDBT keydbt1 (key1);
    ENDDBT keydbt2 (key2);
    ENDDBT datadbt;

    if ((ret = dbp->cursor (txn, & dbc, 0))) {
	return ret;
    }

    if ((ret = dbc->get (keydbt1 (), datadbt (), DB_SET))) {
	return ret;
    }

    g_assert (datadbt.val () == key1);

    if ((ret = dbc->get (keydbt2 (), datadbt (), DB_SET))) {
	return ret;
    }

    g_assert (datadbt.val () == key2);

    dbc->close ();

    return 0;
}

int
curs_db_move (DbTxn *txn, Db *dbp, guint32 key1, guint32 key2)
{
    int ret;
    Dbc *dbc;
    ENDDBT keydbt1 (key1);
    ENDDBT datadbt;
    NULLDBT null;

    if ((ret = dbp->cursor (txn, & dbc, 0))) {
	return ret;
    }

    if ((ret = dbc->get (keydbt1 (), datadbt (), DB_SET))) {
	return ret;
    }

    g_assert (datadbt.val () == key1);

    while (keydbt1.val () < key2) {
	if ((ret = dbc->get (keydbt1 (), null (), DB_NEXT))) {
	    return ret;
	}
    }

    if ((ret = dbc->get (keydbt1 (), datadbt (), DB_CURRENT))) {
	return ret;
    }

    g_assert (datadbt.val () == key2);

    dbc->close ();

    return 0;
}

class XTimer
{
public:

    XTimer ()
	: _timer (g_timer_new ())
    {
	g_timer_start (_timer);
    }

    ~XTimer ()
    {
	g_timer_destroy (_timer);
    }

    double elapsed ()
    {
	g_timer_stop (_timer);

	return g_timer_elapsed (_timer, NULL);
    }

private:

    GTimer *_timer;
};

int
doit (guint32 NRECS, guint32 NREPS, guint32 RANGE)
{
    int    ret;
    DbEnv *env;
    Db    *db;
    DbTxn *txn;

    env = new DbEnv (DB_CXX_NO_EXCEPTIONS);

    system ("rm -rf cursorspeed.home");

    mkdir ("cursorspeed.home", 0777);

    // 64M cache
    if ((ret = env->set_cachesize (0, 64*1024*1024, 1))) {
	return ret;
    }

    if ((ret = env->set_lk_max (10000))) {
	return ret;
    }

    if ((ret = env->open ("cursorspeed.home", DB_INIT_LOG | DB_INIT_MPOOL | DB_INIT_TXN | DB_INIT_LOCK | DB_CREATE, 0666))) {
	return ret;
    }

    db = new Db (env, 0);

    if ((ret = db->open ("db.btree", NULL, DB_BTREE, DB_CREATE, 0666))) {
	return ret;
    }

    if ((ret = env->txn_begin (NULL, & txn, 0))) {
	return ret;
    }

    for (guint32 i = 0; i < NRECS; i += 1) {

	ENDDBT key  (i);
	ENDDBT data (i);

	if ((ret = db->put (txn, key (), data (), 0))) {
	    return ret;
	}
    }

    for (guint j = 0; j < RANGE; j += 1) {

	guint32 x = 2*RANGE + (random () % (NRECS - 4*RANGE));

	XTimer time1;

	for (guint32 i = 0; i < NREPS; i += 1) {

	    if ((ret = curs_db_set (txn, db, x, x + j))) {
		return ret;
	    }
	}

	printf ("curs set  range %d: %f\n", j, (time1.elapsed () / (double) NREPS));

	XTimer time2;

	for (guint32 i = 0; i < NREPS; i += 1) {

	    if ((ret = curs_db_move (txn, db, x, x + j))) {
		return ret;
	    }
	}

	printf ("curs move range %d: %f\n", j, (time2.elapsed () / (double) NREPS));
    }

    if ((ret = txn->commit (0))) {
	return ret;
    }

    db->close (0);
    env->close (0);

    return 0;
}

int
main ()
{
    int ret = doit (1 << 20, 16*1024, 128);

    if (ret) {
	printf ("failed %s\n", db_strerror (ret));
    } else {
	return 0;
    }
}
