#ifndef DEFS_H
#define DEFS_H

#include <qstring.h>

// Ring directory
extern QString RingDir;

// version string (makes updates easier :)
#ifdef UNIX
#define XDC_VERSION "XDrawChem 1.0"
#else
#define XDC_VERSION "WinDrawChem 1.0"
#endif

// define XDC_VERSION for Windows
#ifndef UNIX
#define XDC_SERVER "herger.ibb.gatech.edu"
#endif

// math constant
#define MOL_ARAD 57.29578
#ifndef UNIX  // M_PI is usually defined on Unix, but not Windows
#define M_PI 3.14159246
#endif

// modes (int Render2D::mode)
#define MODE_SELECT 90
#define MODE_SELECT_MOVE_POINT 110
#define MODE_SELECT_MOVE_OBJECT 111

#define MODE_SELECT_MULTIPLE 120
#define MODE_SELECT_MULTIPLE_SELECTED 91
#define MODE_SELECT_MOVE_MULTIPLE 122
#define MODE_SELECT_MULTIPLE_RESIZE 123
#define MODE_SELECT_RESIZE_MULTIPLE 124
#define MODE_SELECT_MULTIPLE_ROTATE 125
#define MODE_SELECT_ROTATE_MULTIPLE 126

#define MODE_DRAWLINE 200
#define MODE_DRAWLINE_DRAWING 201

#define MODE_DRAWLINE_DASH 210
#define MODE_DRAWLINE_DASH_DRAWING 211

#define MODE_DRAWLINE_UP  220
#define MODE_DRAWLINE_UP_DRAWING 221

#define MODE_DRAWLINE_DOWN  240
#define MODE_DRAWLINE_DOWN_DRAWING 241

#define MODE_DRAWARROW  260
#define MODE_DRAWARROW_DRAWING 261

#define MODE_DRAWCURVEARROW 270
#define MODE_DRAWCURVEARROW_DRAWING 271

#define MODE_DRAWBRACKET  280
#define MODE_DRAWBRACKET_DRAWING 281

#define MODE_ERASE 300
#define MODE_ERASING 301

#define MODE_TEXT 400

#define MODE_SYMBOL 500

#define MODE_TOOL 600
#define MODE_TOOL_CALCMW 601
#define MODE_TOOL_CALCEF 602
#define MODE_TOOL_13CNMR 603
#define MODE_TOOL_CALCEA 604
#define MODE_TOOL_1HNMR  605
#define MODE_TOOL_IR     606
#define MODE_TOOL_NAME   607
#define MODE_TOOL_TOSMILES 608
#define MODE_TOOL_FROMSMILES 609
#define MODE_TOOL_CLEANUPMOL 610

// types (Drawable::Type() and subclasses)
#define TYPE_DRAWABLE 0
#define TYPE_MOLECULE 1
#define TYPE_BOND 10
#define TYPE_TEXT 11
#define TYPE_ARROW 12
#define TYPE_BRACKET 13
#define TYPE_SYMBOL 14
#define TYPE_CURVEARROW 15

// bracket types (Bracket::style)
#define BRACKET_SQUARE 1
#define BRACKET_CURVE  2
#define BRACKET_BRACE  3

// arrow styles (Arrow::style)
#define ARROW_REGULAR 1
#define ARROW_DASH 2
#define ARROW_BI1 3
#define ARROW_BI2 4
#define ARROW_RETRO 5

// curve arrow styles
#define CA_CW90 1
#define CA_CW180 2
#define CA_CW270 3
#define CA_CCW90 4
#define CA_CCW180 5
#define CA_CCW270 6

// symbol styles
#define SYM_PLUS 1
#define SYM_MINUS 2
#define SYM_DELTA_PLUS 3
#define SYM_DELTA_MINUS 4
#define SYM_2E 5
#define SYM_1E 6

// justification flags (Text::justify)
#define JUSTIFY_CENTER 1
#define JUSTIFY_TOPLEFT 2

// Sides (Text::NearestCenter)
#define TEXT_LEFT 1
#define TEXT_RIGHT 2
#define TEXT_TOP 3
#define TEXT_BOTTOM 4

// data held in text (Text::DataType)
#define TEXT_DATA_NORMAL 1
#define TEXT_DATA_MW 2
#define TEXT_DATA_FORMULA 3

// Horizontal or vertical arrow (Arrow::Orientation)
#define ARROW_HORIZONTAL 1
#define ARROW_VERTICAL 2

// Flip direction
#define FLIP_H 1
#define FLIP_V 2

// output devices
#define OUTPUT_SCREEN  1
#define OUTPUT_IMAGE   2
#define OUTPUT_PRINTER 3
#define OUTPUT_EPS     4
#define OUTPUT_SVG     5

// Paintable::op Operation types
#define OP_LINE 1
#define OP_DASH_LINE 2
#define OP_TEXT 3
#define OP_CURVE_CW90 4
#define OP_CURVE_CCW90 5
#define OP_CURVE_CW180 6
#define OP_CURVE_CCW180 7
#define OP_CURVE_CW270 8
#define OP_CURVE_CCW270 9
#define OP_PIXMAP 10
#define OP_FILLBOX 11

// page setup
#define PAGE_LETTER 1
#define PAGE_LEGAL  2
#define PAGE_A4     3
#define PAGE_640    4
#define PAGE_800    5
#define PAGE_1024   6
#define PAGE_PORTRAIT  100
#define PAGE_LANDSCAPE 200

// CML stuff
// track what tag(s) we're in
#define CML_MOLECULE 10
#define CML_ATOM   2
#define CML_BOND   3
#define CML_ATOMARRAY 4
#define CML_BONDARRAY 5
#define CDXML_COLORTABLE  100
#define CDXML_FONTTABLE   101
#define CDXML_PAGE        102
#define CDXML_FRAGMENT    103
#define CDXML_NODE        104
#define CDXML_BOND        105
#define CDXML_GRAPHIC     106
#define CDXML_TEXT        107

#endif // ifndef DEFS_H
