/*
 * Page mark ring for xdvi
 *
 * Copyright (c) 1993, 1995
 *      ONO Kouichi             onono@fuka.info.waseda.ac.jp
 * All rights reserved.
 */

#include "xdvi-config.h"	/* added by Masahito Yamaga */
#include <stdio.h>
#include "markpage.h"

static  MARKRING        *PageMarkRing;

void
  CreateNewPageMarkRing()
{
  PageMarkRing = CreateNewRing();
}

void
  MakePageMarkRingNull()
{
  MakeRingNull(PageMarkRing);
}

BOOL
  ThisPageIsMarked(page)
PAGE page;
{
  return MemberOfRing(page, PageMarkRing);
}

void
  MarkPage(page)
PAGE page;
{
  if(ThisPageIsMarked(page)) {
    PurgeTheValueAllFromRing(page, PageMarkRing);
  }
  /* Like LRU-stack */
  AddElementToRing(page, PageMarkRing);
}

void
  UnmarkPage(page)
PAGE page;
{
  if(ThisPageIsMarked(page)) {
    PurgeTheValueAllFromRing(page, PageMarkRing);
  }
}

void
  ReverseTheMarkOfPage(page)
PAGE page;
{
  if(ThisPageIsMarked(page)) {
    UnmarkPage(page);
  } else {
    MarkPage(page);
  }
}

BOOL
  EmptyPageMarkRing()
{
  return EmptyRing(PageMarkRing);
}

PAGE
  LastMarkPage()
{
  return RingLastElement(PageMarkRing);
}

void
  SetPageMarkAtLast(page)
PAGE page;
{
  if(! ThisPageIsMarked(page)) {
    PurgeLastElementFromRing(PageMarkRing);
  }
  MarkPage(page);
}

void
  RotatePageMarkRing()
{
  RotateRing(PageMarkRing);
}

#ifndef DVISEL

LIST_LOCATION
  MakeMarkedPageList(PageList)
PAGE PageList[LISTSIZE];
{
  return MakeListFromRing(PageMarkRing, PageList);
}

LIST_LOCATION
  MakeSortedMarkedPageList(PageList)
PAGE PageList[LISTSIZE];
{
  return MakeListFromRing(MakeRingSort(PageMarkRing), PageList);
}

void
  GetMarkedPageListAsString(ResultString, prevchar, postchar, delimiter)
char ResultString[STRLENGTH], prevchar, postchar, delimiter;
{
  PAGE          PageList[LISTSIZE];
  LIST_LOCATION EndLocation, loc;
  char          buff[STRLENGTH];
  
  ResultString[0] = (char)NULL;
  EndLocation = MakeMarkedPageList(PageList);
  if(EndLocation>=INITIAL_LIST) {
    if(prevchar!=(char)NULL) {
      /* Put a character on the previous position of the first page number */
      sprintf(buff, "%c", prevchar);
      strcat(ResultString, buff);
    }
    /* Put the first page number */
    sprintf(buff, "%d", PageList[INITIAL_LIST]+1);
    strcat(ResultString, buff);
    if(postchar!=(char)NULL) {
      /* Put a character on the post position of the first page number */
      sprintf(buff, "%c", postchar);
      strcat(ResultString, buff);
    }
    for(loc = INITIAL_LIST+1; loc<=EndLocation; loc++) {
      /* Put the delimiter character */
      sprintf(buff, "%c", delimiter);
      strcat(ResultString, buff);
      if(prevchar!=(char)NULL) {
	/* Put a character on the previous position of the first page number */
	sprintf(buff, "%c", prevchar);
	strcat(ResultString, buff);
      }
      /* Put the page number */
      sprintf(buff, "%d", PageList[loc]+1);
      strcat(ResultString, buff);
      if(postchar!=(char)NULL) {
	/* Put a character on the post position of the first page number */
	sprintf(buff, "%c", postchar);
	strcat(ResultString, buff);
      }
    }
  }
}

void
  GetSortedMarkedPageListAsString(ResultString, prevchar, postchar, delimiter)
char ResultString[STRLENGTH], prevchar, postchar, delimiter;
{
  PAGE          PageList[LISTSIZE];
  LIST_LOCATION EndLocation, loc;
  char          buff[STRLENGTH];
  
  ResultString[0] = (char)NULL;
  EndLocation = MakeSortedMarkedPageList(PageList);
  if(EndLocation>=INITIAL_LIST) {
    if(prevchar!=(char)NULL) {
      /* Put a character on the previous position of the first page number */
      sprintf(buff, "%c", prevchar);
      strcat(ResultString, buff);
    }
    /* Put the first page number */
    sprintf(buff, "%d", PageList[INITIAL_LIST]+1);
    strcat(ResultString, buff);
    if(postchar!=(char)NULL) {
      /* Put a character on the post position of the first page number */
      sprintf(buff, "%c", postchar);
      strcat(ResultString, buff);
    }
    for(loc = INITIAL_LIST+1; loc<=EndLocation; loc++) {
      /* Put the delimiter character */
      sprintf(buff, "%c", delimiter);
      strcat(ResultString, buff);
      if(prevchar!=(char)NULL) {
	/* Put a character on the previous position of the first page number */
	sprintf(buff, "%c", prevchar);
	strcat(ResultString, buff);
      }
      /* Put the page number */
      sprintf(buff, "%d", PageList[loc]+1);
      strcat(ResultString, buff);
      if(postchar!=(char)NULL) {
	/* Put a character on the post position of the first page number */
	sprintf(buff, "%c", postchar);
	strcat(ResultString, buff);
      }
    }
  }
}

void
  GetSortedMarkedPPListAsString(ResultString, prevchar, postchar, tochar, delimiter)
char ResultString[STRLENGTH], prevchar, postchar, tochar, delimiter;
{
  PAGE          PageList[LISTSIZE], ppstart, ppend;
  LIST_LOCATION EndLocation, loc;
  char          buff[STRLENGTH];
  
  if(tochar==(char)NULL)
    tochar = DEFAULTTOCHAR;
  
  ResultString[0] = (char)NULL;
  EndLocation = MakeSortedMarkedPageList(PageList);
  if(EndLocation>=INITIAL_LIST) {
    if(prevchar!=(char)NULL) {
      /* Put a character on the previous position of the first page number */
      sprintf(buff, "%c", prevchar);
      strcat(ResultString, buff);
    }
    /* Record this page as the start page of page-to-page */
    ppstart = PageList[INITIAL_LIST]+1;
    ppend = ppstart;
    /* Put the first page number */
    sprintf(buff, "%d", ppstart);
    strcat(ResultString, buff);
    if(postchar!=(char)NULL) {
      /* Put a character on the post position of the first page number */
      sprintf(buff, "%c", postchar);
      strcat(ResultString, buff);
    }
    for(loc = INITIAL_LIST+1; loc<=EndLocation; loc++) {
      if(PageList[loc]==ppend) { /* Is this page the successor ? */
	/* Yes, this page is the successor of the previous page */
	/* Renew the record of the end page of page-to-page */
	ppend = PageList[loc]+1;
	/* Normally, the successive page is no t printed */
	/* However, it is printed only if the page is the end of list */
	if(loc==EndLocation) {
	  sprintf(buff, "%c", tochar);
	  strcat(ResultString, buff);
	  sprintf(buff, "%d", ppend);
	  strcat(ResultString, buff);
	}
      } else {
	/* No, this page is not the successor of the previous page */
	/* Print page-to-page (the start page is already printed) */
	if(ppend!=ppstart) { /* page-to-page form ? */
	  /* Yes */
	  sprintf(buff, "%c", tochar);
	  strcat(ResultString, buff);
	  sprintf(buff, "%d", ppend);
	  strcat(ResultString, buff);
	}
	/* Put the delimiter character */
	sprintf(buff, "%c", delimiter);
	strcat(ResultString, buff);
	if(prevchar!=(char)NULL) {
	  /* Put a character on the previous position of the first page number */
	  sprintf(buff, "%c", prevchar);
	  strcat(ResultString, buff);
	}
	/* Renew the record of the start page of page-to-page */
	ppstart = PageList[loc]+1;
	ppend = ppstart;
	/* Put the page number */
	sprintf(buff, "%d", ppstart);
	strcat(ResultString, buff);
	if(postchar!=(char)NULL) {
	  /* Put a character on the post position of the first page number */
	  sprintf(buff, "%c", postchar);
	  strcat(ResultString, buff);
	}
      }
    }
  }
}

#endif /* DVISEL */
