/*
 * Page mark ring for xdvi
 *
 * Copyright (c) 1993, 1995
 *      ONO Kouichi             onono@fuka.info.waseda.ac.jp
 * All rights reserved.
 */

#ifndef _MARKPAGE_H_
#define _MARKPAGE_H_

#include "chardef.h"
#include "markring.h"

#define STRLENGTH       (1024)

typedef int     PAGE;

extern  void    CreateNewPageMarkRing();
extern  void    MakePageMarkRingNull();
extern  BOOL    ThisPageIsMarked();
extern  void    MarkPage();
extern  void    UnmarkPage();
extern  void    ReverseTheMarkOfPage();
extern  BOOL    EmptyPageMarkRing();
extern  PAGE    LastMarkPage();
extern  void    SetPageMarkAtLast();
extern  void    RotatePageMarkRing();
#ifndef DVISEL
extern  LIST_LOCATION   MakeMarkedPageList();
extern  LIST_LOCATION   MakeSortedMarkedPageList();
extern  void    GetMarkedPageListAsString();
extern  void    GetSortedMarkedPageListAsString();
extern  void    GetSortedMarkedPPListAsString();
#endif /* DVISEL */

#define DEFAULTTOCHAR   CHAR_COLON

#endif  /* _MARKPAGE_H_ */
