/* xdvi-config.h: master configuration file, included first by all
   compilable source files (not headers).  */

#ifndef CONFIG_H
#define CONFIG_H

#define KPATHSEA 1

/* The stuff from the path searching library.  */
#include <kpathsea/c-auto.h>
#include <kpathsea/config.h>

#include <setjmp.h>

#ifndef HAVE_VPRINTF
#ifdef HAVE_DOPRNT
#define	vfprintf(stream, message, args)	_doprnt(message, args, stream)
/* If we have neither, should fall back to fprintf with fixed args.  */
#endif
#endif

/* Some xdvi options we want by default.  */
#define USE_PK
#define USE_GF
#define MAKEPK

#ifndef NOSELFILE
#define SELFILE
#endif
#ifndef NOGRID
#define GRID
#endif
#ifndef NOTEXXET
#define TEXXET
#endif
#if defined (HAVE_LIBWWW) && defined (HAVE_WWWLIB_H)
#define HTEX
#endif

/* On the other hand, NOTOOL means we lose practically everything.  */
#ifdef NOTOOL
#undef SELFILE
#undef BUTTONS
#undef GRID
#undef HTEX
#endif /* NOTOOL */

/* support Japanese environment */
#ifndef NOKANJI
#define KANJI
#endif /* NOKANJI */
#ifndef NOPTEX
#define PTEX
#endif /* NOPTEX */

#ifdef  NOZEIT
#define ASCIIDNP
#else /* !NOZEIT */
#define USE_ZEIT
#define DEFAULT_FONTCONF ""
#ifndef NOVFONTMAP
#define USE_VFONTMAP
#ifndef DEFAULT_FONTMAP
#define DEFAULT_FONTMAP "/usr/local/share/texmf/xdvi/vfontmap"
#endif /* DEFAULT_FONTMAP */
#endif /* NOVFONTMAP */
#ifndef NONTTZEIT
#define NTTZEIT
#endif /* NONTTZEIT */
#endif /* NOZEIT */

#ifndef NOCOLOR
#define COLOR
#undef GREY
#define GREY 1
#endif /* NOCOLOR */
#ifndef NOTOC
#define TOC
#define MAX_PAGE 1024
#endif /* NOTOC */
#ifndef NOPAGENUM
#define PAGENUM
#endif /* NOPAGENUM */
#ifndef NOMARKPAGE
#define MARKPAGE
#define RINGSIZE 1024
#endif /* NOMARKPAGE */
#ifndef NODVISEL
#define PRINTDVI
#define DVISEL
#ifndef XDVIPRINTCMD
#define XDVIPRINTCMD "/usr/local/bin/xdviprint"
#endif /* XDVIPRINTCMD */
#endif /* NODVISEL */
#if !defined(NOPRINTDVI) && !defined(DVISEL)
#define PRINTDVI
/* Print-out command templates */
/* all pages of DVI file */
#define PRCMDALL "cd %d; %R %F > %D/%F:All@%r.ps; %P -J'%F' %D/%F:All@%r.ps"
/* the current page */
#define PRCMDCUR "cd %d; dviselect =%c %F %D/%F:%c@%r.dvi; %R %D/%F:%c@%r.dvi > %D/%F:%c@%r.ps; /bin/rm %D/%F:%c@%r.dvi; %P -J'%F (Page %c)' %D/%F:%c@%r.ps"
/* the lastly marked page */
#define PRCMDMRK "cd %d; dviselect =%m %F %D/%F:%m@%r.dvi; %R %D/%F:%m@%r.dvi > %D/%F:%m@%r.ps; /bin/rm %D/%F:%m@%r.dvi; %P -J'%F (Page %m)' %D/%F:%m@%r.ps"
/* pages in the region, between the current page and the lastly marked page */
#define PRCMDRGN "cd %d; dviselect =%s:%e %F %D/%F:%s-%e@%r.dvi; %R %D/%F:%s-%e@%r.dvi > %D/%F:%s-%e@%r.ps; /bin/rm %D/%F:%s-%e@%r.dvi; %P -J'%F (Page %s-%e)' %D/%F:%s-%e@%r.ps"
/* all marked pages */
#define PRCMDLST "cd %d; dviselect %G %F %D/%F:%o@%r.dvi; %R %D/%F:%o@%r.dvi > %D/%F:%o@%r.ps; /bin/rm %D/%F:%o@%r.dvi; %P -J'%F (Page %o)' %D/%F:%o@%r.ps"
/* the default printer to print-out DVI file */
/* #define DVIPRINTER "lp" */
/* work directory for temporal files */
#define TEMPDIR "/tmp"
/* DVI filter command string */
/* translation file from xdvi paper type into dvi filter paper size option */
#ifdef DVI2PS
#define DVIFILTERCMD "dvi2ps -o %Z"
#define FILTOPTTBLFILE  "/usr/local/share/texmf/xdvi/xdvipaper.dvi2ps-j"
#else /* ! DVI2PS */
#ifdef JDVI2KPS
#define DVIFILTERCMD "jdvi2kps -pa %Z"
#define FILTOPTTBLFILE  "/usr/local/share/texmf/xdvi/xdvipaper.jdvi2kps"
#else /* ! JDVI2KPS */
#define DVIFILTERCMD "dvips -f -t %Z"
#define FILTOPTTBLFILE  "/usr/local/share/texmf/xdvi/xdvipaper.dvips"
#endif /* JDVI2KPS */
#endif /* DVI2PS */
/* print command string */
#define PRINTCMD "lpr -s -r -P%p"
#endif /* !NOPRINTDVI && !DVISEL */
#ifdef PRINTDVI
/* the default printer to print-out DVI file */
#define DVIPRINTER "lp"
#endif /* PRINTDVI */
#ifndef NOPAPERMENU
#define PAPERMENU
#endif /* NOPAPERMENU */

/* xdvi's definitions.  */
#include "xdvi.h"

#endif /* not CONFIG_H */
