;;; vc-xemacs-el --- XEmacs compatiblity library for vc

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Code:

(unless (boundp 'temporary-file-directory)
  (defvar temporary-file-directory (temp-directory)))

(unless (boundp 'default-file-name-coding-system)
  (defvar default-file-name-coding-system
    (or (default-value 'file-name-coding-system) 'binary)))

;; Adapted from GNU Emacs' version in subr.el
(unless (fboundp 'make-temp-file)
  (defun make-temp-file (prefix &optional dir-flag)
    (let (file)
      (while (condition-case ()
                 (progn
                   (setq file
                         (make-temp-name
                          (expand-file-name prefix (temp-directory))))
                   (if dir-flag
                       (make-directory file)
                     (and (not (file-exists-p file))
                          (write-region "" nil file nil 'silent)))
                   nil)
               (file-already-exists t))
        ;; the file was somehow created by someone else between
        ;; `make-temp-name' and `write-region', let's try again
        nil)
      file)))

;; These three are present in XEmacs >= 21.5
(unless (fboundp 'line-end-position)
  (defalias 'line-end-position 'point-at-eol))
(unless (fboundp 'line-beginning-position)
  (defalias 'line-beginning-position 'point-at-bol))
(unless (fboundp 'line-number-at-pos)
  (defun line-number-at-pos (&optional pos)
    (line-number pos t)))

(unless (fboundp 'subst-char-in-string)
  (defun subst-char-in-string (fromchar tochar string &optional inplace)
    "Replace FROMCHAR with TOCHAR in STRING each time it occurs.
Unless optional argument INPLACE is non-nil, return a new string."
    (let ((i (length string))
          (newstr (if inplace string (copy-sequence string))))
      (while (> i 0)
        (setq i (1- i))
        (if (eq (aref newstr i) fromchar)
            (aset newstr i tochar)))
      newstr)))

(unless (fboundp 'replace-regexp-in-string)
  ;; Note: fixedcase, subexp, start ignored for now
  (defun replace-regexp-in-string (regexp rep string &optional
                                          fixedcase literal subexp start)
    (replace-in-string string regexp rep literal)))

;; From GNU Emacs' byte-run.el
(unless (fboundp 'with-no-warnings)
  (defun with-no-warnings (&rest body)
    (car (last body))))

(unless (fboundp 'match-string-no-properties)
  (defalias 'match-string-no-properties 'match-string))

(unless (boundp 'find-file-hook)
  (defvaralias 'find-file-hook 'find-file-hooks))

(provide 'vc-xemacs)
