/*
 *  Xeukleides  version 0.9.0
 *  Copyright (c) Christian Obrecht 2000-2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include "types.h"
#include "parser.tab.h"

#define GDK_Escape 0xFF1B
#define GDK_Left 0xFF51
#define GDK_Up 0xFF52
#define GDK_Right 0xFF53
#define GDK_Down 0xFF54
#define GDK_F1 0xFFBE

extern int yyparse(void);

extern char * yytext;

extern void clear(void);

extern void stripes(void);

int errorcount, lineno, file_length, undefined, cursor, viewing, untitled, changed, action, assign_ind, bracepos, loopcount, inputmode, offset, drawing_style, pageno;

int Width, Height, current, starting, boxed ;

char *buffer, *file_name, *title, *start;

FILE *file;

GtkWidget *window, *table, *text, *drawing_area, *areyousure, *yes, *about, *source, *figure;
GtkFileSelection *opensel, *savesel;
GdkPixmap *pixmap;
GdkGC *solid_gc, *dotted_gc, *dashed_gc;
GdkFont *font;
GdkColor black_col, darkgray_col, gray_col, lightgray_col, red_col, green_col, blue_col, cyan_col, magenta_col, yellow_col, white_col;

interrec inter_table[26][2];

extern assignrec assign_table[52];

void usage(int code)
{
  printf("Usage is:\n\txeukleides [ -v | -h ]\n"
                    "\txeukleides [ <filename> ]\n"
		    "\txeukleides -V <filename>\n"
         "Options:\n\t-v\tPrint version number.\n"
	           "\t-h\tPrint this help.\n"
	           "\t-V\tStart xeukleides in viewing mode.\n"
         "See man page for more informations.\n");
  exit(code);
}

void version(void)
{
  printf("This is xeukleides version 0.9.0\nCopyright (c) Christian Obrecht 2000-2002\n");
  exit(0);
}

void clearinter(void)
{
  int i;
  for (i=0;i<26;i++) { inter_table[i][0].free = 1; inter_table[i][1].free = 1; }
}

void hide(GtkWidget * widget, gpointer handle)
{
  gtk_widget_hide (GTK_WIDGET (handle));
}

void redraw(GtkWidget * widget)
{
  gdk_gc_set_foreground(solid_gc,&black_col);
  gdk_gc_set_foreground(dotted_gc,&black_col);
  gdk_gc_set_foreground(dashed_gc,&black_col);
  drawing_style = FULL; 
  gdk_draw_rectangle (pixmap, widget->style->white_gc, TRUE, 0, 0, Width, Height);
  clear();
  cursor = 0;
  inputmode = 0;
  offset = 0;
  undefined = 1;
  lineno = 1;
  errorcount = 0;
  file_length = gtk_text_get_length(GTK_TEXT(text));
  buffer = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);
  yyrestart();
  start = yytext;
  yyparse();
  g_free(buffer);
  if (boxed && !errorcount) stripes();
  gdk_draw_pixmap (widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)], pixmap, 0, 0, 0, 0, Width, Height);
}

void zap(void)
{
  if (viewing) {
    gtk_widget_hide(drawing_area);
    gtk_widget_show(table);
    gtk_text_set_editable (GTK_TEXT (text), TRUE);
    gtk_widget_grab_focus(text);
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (source), TRUE);
    viewing = 0;
  }
  else {
    if (pixmap) gdk_pixmap_unref (pixmap);
    pixmap = gdk_pixmap_new (drawing_area->window, Width, Height, -1);
    clearinter();
    current=0;
    starting=1; 
    assign_ind = -1;
    redraw(drawing_area);
    starting=0;
    gtk_widget_hide(table);
    gtk_text_set_editable (GTK_TEXT (text), FALSE);
    gtk_widget_show(drawing_area);
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (figure), TRUE);
    viewing = 1;
  }
}

void snapshot(void)
{
  int i, j, len=0;
  char tmp[9];

  for (i = 0; i <= assign_ind; i++) 
    if (assign_table[i].pos > 65535) {
      gdk_draw_rectangle (pixmap, window->style->white_gc, TRUE, 0, 0, Width, Height);
      gdk_gc_set_foreground(solid_gc,&red_col);
      gdk_draw_string(pixmap, font, solid_gc, 10, 20, "Error: Editor overflow.");
      return;
    }
  gtk_text_freeze(GTK_TEXT(text));
  j = 0;
  for (i = 0; i <= assign_ind; i++) {
    gtk_text_set_point(GTK_TEXT(text), assign_table[i].pos+j);
    gtk_text_forward_delete(GTK_TEXT(text), assign_table[i].len);
    snprintf(tmp,9,"%-.4f",inter_table[assign_table[i].i][assign_table[i].j].value);
    len = strlen(tmp);
    while (len > 0 && tmp[len-1] == '0') len--;
    if (len > 0 && tmp[len-1] == '.') len--;
    gtk_text_insert(GTK_TEXT(text), font, &black_col, &white_col, tmp, len);
    j = j + len - assign_table[i].len;
  }
  gtk_text_thaw(GTK_TEXT(text));
  if (assign_ind) changed=1;
  zap();
}

void setview(GtkWidget * widget, guint action)
{
  if ((action == 0) && (viewing == 1) || (action == 1) && (viewing == 0)) zap();
}

void changed_event(GtkEditable* editable, gpointer data)
{
  changed=1;
}

gint configure_event (GtkWidget * widget, GdkEventConfigure * event)
{
  if (viewing) {
    if (pixmap) gdk_pixmap_unref (pixmap);
    Width = widget->allocation.width; Height = widget->allocation.height;
    pixmap = gdk_pixmap_new (widget->window, Width, Height, -1);
    redraw(widget);
  }
  return TRUE;
}

gint expose_event (GtkWidget * widget, GdkEventExpose * event)
{
  gdk_draw_pixmap (widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)], pixmap, 
                   event->area.x, event->area.y, event->area.x, event->area.y, event->area.width, event->area.height);
  return FALSE;
}

gint key_press_event (GtkWidget * widget, GdkEventKey * event)
{
  int i,j,augment;
  
  if (event->keyval == GDK_Escape) {
    zap();
    return FALSE;
  }  
  if (!viewing) return FALSE;
  if (event->keyval == GDK_F1) {
    snapshot();
    return FALSE;
  }
  if (event->length > 0) {
    i = (int)(event->string[0]-'a');
    if (i>=0 && i<=25) current = i;
    return FALSE;
  }
  switch (event->keyval) {
    case GDK_Left : j = 1; augment = 0; break;
    case GDK_Right : j = 1; augment = 1; break;
    case GDK_Down : j = 0; augment = 0; break;
    case GDK_Up : j = 0; augment = 1; break;
    default : return FALSE;
  }
  if (inter_table[current][j].free) return FALSE;
  if (augment) {
    if (inter_table[current][j].value+inter_table[current][j].step<inter_table[current][j].high+1e-8)
      inter_table[current][j].value += inter_table[current][j].step;
  }
  else {
    if (inter_table[current][j].value-inter_table[current][j].step>inter_table[current][j].low-1e-8)
      inter_table[current][j].value -= inter_table[current][j].step;
  }
  if (gtk_events_pending()) gtk_main_iteration();
  else redraw(drawing_area);
  return FALSE;
}

void settitle(void)
{
  title = (char *)malloc(14+strlen(file_name));
  sprintf(title, "Xeukleides - %s", file_name);
  gtk_window_set_title (GTK_WINDOW (window), title);
  free(title);
}

void readfile(void)
{
  int size, number;
  settitle();

  file = fopen(file_name, "r");
  if (!file) return;
  file_length = 0; size = 1024; number = 1024;
  buffer = (char *)malloc(size);
  while (number == 1024) {
    number = fread(buffer + file_length, 1, 1024, file);
    file_length += number;
    if (size == file_length) {
      size *= 2;
      buffer = (char *)realloc(buffer, size);
    }
  }
  fclose(file);
  gtk_text_freeze (GTK_TEXT (text));
  gtk_text_insert (GTK_TEXT (text), font, NULL, NULL, buffer, file_length);
  gtk_text_thaw (GTK_TEXT (text));
  g_free(buffer);
}

void newfile(void)
{
  gtk_text_freeze (GTK_TEXT (text));
  gtk_editable_delete_text (GTK_EDITABLE (text), 0, -1);
  gtk_text_thaw (GTK_TEXT (text));
  changed = 0;
}

void openfile(void)
{
  newfile();
  file_name = gtk_file_selection_get_filename(opensel);
  untitled = 0;
  changed = 0;
  readfile();
  gtk_widget_hide(GTK_WIDGET(opensel));
  if (viewing) zap();
}

void newfunc(void)
{
  newfile();
  file_name = "(Untitled)";
  settitle();
  untitled = 1;
  if (viewing) zap();
}

void openfunc(void)
{
  gtk_file_selection_set_filename(opensel, "");
  gtk_widget_show(GTK_WIDGET(opensel));
}

void actionfunc(void)
{
  switch (action) {
    case 0 : newfunc(); break;
    case 1 : openfunc(); break;
    case 2 : gtk_main_quit();
  }
  action = -1;
}

void savefile(void)
{
  file = fopen(file_name, "w");
  if (!file) {
    fprintf(stderr, "Could not open file %s\n", file_name);
    untitled = 1;
    file_name = "(Untitled)";
    settitle();
    return;
  }
  changed = 0;
  file_length = gtk_text_get_length(GTK_TEXT(text));
  buffer = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);
  fwrite(buffer, 1, file_length, file);
  g_free(buffer);
  fclose(file);
  actionfunc();
}

void savefileas(void)
{
  file_name = gtk_file_selection_get_filename(savesel);
  settitle();
  savefile();
  gtk_widget_hide(GTK_WIDGET(savesel));
}

void saveasfunc(void)
{
  gtk_file_selection_set_filename(savesel, "");
  gtk_widget_show(GTK_WIDGET(savesel));
}

void savefunc(void)
{
  if (untitled) {
    saveasfunc();
    untitled = 0;
  } else savefile();
}

void sure_yes(void)
{
  gtk_widget_hide(areyousure);
  savefunc();
}

void sure_no(void)
{
  gtk_widget_hide(areyousure);
  actionfunc();
}

void sure_cancel(void)
{
  action = -1;
  gtk_widget_hide(areyousure);
}

void areyousurefunc(GtkWidget * widget, guint act)
{
  action = act;
  if (changed) {
    gtk_widget_grab_focus(yes);
    gtk_widget_show(areyousure);
  }
  else actionfunc();
}

void aboutfunc(void)
{
  gtk_widget_show (about);
}

static GtkItemFactoryEntry Entry[] =
{
  {"/Fil_e", NULL, NULL, 0, "<Branch>"},
  {"/File/_New", NULL, areyousurefunc, 0, "<Item>"},
  {"/File/_Open", "<control>O", areyousurefunc, 1, "<Item>"},
  {"/File/_Save", "<control>S", savefunc, 0, "<Item>"},
  {"/File/Save _As", NULL, saveasfunc, 0, "<Item>"},
  {"/File/sep", NULL, NULL, 0, "<Separator>"},
  {"/File/_Quit", "<control>Q", areyousurefunc, 2, NULL},
  {"/_View", NULL, NULL, 0, "<Branch>"},
  {"/View/So_urce", NULL, setview, 0, "<RadioItem>"},
  {"/View/_Figure", NULL, setview, 1, "/View/Source"},
  {"/View/sep", NULL, NULL, 0, "<Separator>"},
  {"/View/Sna_pshot", NULL, snapshot, 0, NULL},
  {"/Hel_p", NULL, NULL, 0, "<LastBranch>"},
  {"/Help/A_bout", NULL, aboutfunc, 0, NULL}
};

int main(int argc, char **argv)
{
  GtkWidget *box, *menubar, *vscrollbar, *msg, *button;
  GtkAccelGroup *accel;
  GtkItemFactory *items;
  GdkColormap *colormap;

  gtk_init (&argc, &argv);

  Width = 600; Height = 480;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW(window), TRUE, TRUE, FALSE);  
  gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
  gtk_container_set_border_width (GTK_CONTAINER (window), 0);

  box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box);
  gtk_widget_show (box);
  
  accel = gtk_accel_group_new ();
  items = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<Main>", accel);
  gtk_item_factory_create_items (items, 14, Entry, NULL);
  gtk_accel_group_attach (accel, GTK_OBJECT (window));
  source = gtk_item_factory_get_widget (items, "/View/Source");
  figure = gtk_item_factory_get_widget (items, "/View/Figure");
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (source), TRUE);
  
  menubar = gtk_item_factory_get_widget (items, "<Main>");
  gtk_box_pack_start (GTK_BOX (box), menubar, FALSE, FALSE, 0);
  gtk_widget_show (menubar);
  
  table = gtk_table_new (2, 2, FALSE);
  gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
  gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);
  gtk_widget_set_usize (table, Width, Height);
  gtk_widget_show (table);
  
  text = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (text), TRUE);
  gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show (text);
  viewing = 0;

  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
		    GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show (vscrollbar);

  font = gdk_font_load ("-*-courier-medium-r-*-*-*-160-*-*-*-*-iso8859-1");
  if (font == NULL) {
    fprintf(stderr,"Unable to load font.\n");
    exit(1);
  }  
  gtk_widget_realize (text);
  gtk_text_insert (GTK_TEXT (text), font, NULL, NULL, " ", 1);
  gtk_text_backward_delete(GTK_TEXT (text), 1);
  changed = 0;
  gtk_signal_connect (GTK_OBJECT (text), "changed", (GtkSignalFunc) changed_event, NULL);

  drawing_area = gtk_drawing_area_new ();
  gtk_drawing_area_size (GTK_DRAWING_AREA (drawing_area), Width, Height);
  gtk_widget_set_events (drawing_area, GDK_EXPOSURE_MASK || GDK_KEY_PRESS_MASK);
  gtk_signal_connect (GTK_OBJECT (drawing_area), "expose_event", (GtkSignalFunc) expose_event, NULL);
  gtk_signal_connect (GTK_OBJECT (drawing_area), "configure_event", (GtkSignalFunc) configure_event, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "key_press_event", (GtkSignalFunc) key_press_event, NULL);
  gtk_box_pack_start (GTK_BOX (box), drawing_area, TRUE, TRUE, 0);
  gtk_widget_realize (drawing_area);
  solid_gc = gdk_gc_new(drawing_area->window);
  dotted_gc = gdk_gc_new(drawing_area->window);
  gdk_gc_set_line_attributes(dotted_gc, 0, GDK_LINE_ON_OFF_DASH, GDK_CAP_BUTT, GDK_JOIN_MITER);
  gdk_gc_set_dashes(dotted_gc, 0, "\001\003",2);
  dashed_gc = gdk_gc_new(drawing_area->window);
  gdk_gc_set_line_attributes(dashed_gc, 0, GDK_LINE_ON_OFF_DASH, GDK_CAP_BUTT, GDK_JOIN_MITER);
  gdk_gc_set_dashes(dashed_gc, 0, "\003\002",2);

  colormap = gdk_window_get_colormap(drawing_area->window);
  black_col.red = 0; black_col.green = 0; black_col.blue = 0;
  gdk_colormap_alloc_color(colormap, &black_col, FALSE, TRUE);
  darkgray_col.red = 0x3fff; darkgray_col.green = 0x3fff; darkgray_col.blue = 0x3fff;
  gdk_colormap_alloc_color(colormap, &darkgray_col, FALSE, TRUE);
  gray_col.red = 0x7fff; gray_col.green = 0x7fff; gray_col.blue = 0x7fff;
  gdk_colormap_alloc_color(colormap, &gray_col, FALSE, TRUE);
  lightgray_col.red = 0xcfff; lightgray_col.green = 0xcfff; lightgray_col.blue = 0xcfff;
  gdk_colormap_alloc_color(colormap, &lightgray_col, FALSE, TRUE);
  red_col.red = 0xffff; red_col.green = 0; red_col.blue = 0;
  gdk_colormap_alloc_color(colormap, &red_col, FALSE, TRUE);
  green_col.red = 0; green_col.green = 0xffff; green_col.blue = 0;
  gdk_colormap_alloc_color(colormap, &green_col, FALSE, TRUE);
  blue_col.red = 0; blue_col.green = 0; blue_col.blue = 0xffff;
  gdk_colormap_alloc_color(colormap, &blue_col, FALSE, TRUE);
  cyan_col.red = 0; cyan_col.green = 0xffff; cyan_col.blue = 0xffff;
  gdk_colormap_alloc_color(colormap, &cyan_col, FALSE, TRUE);
  magenta_col.red = 0xffff; magenta_col.green = 0; magenta_col.blue = 0xffff;
  gdk_colormap_alloc_color(colormap, &magenta_col, FALSE, TRUE);
  yellow_col.red = 0xffff; yellow_col.green = 0xffff; yellow_col.blue = 0;
  gdk_colormap_alloc_color(colormap, &yellow_col, FALSE, TRUE);
  white_col.red = 0xffff; white_col.green = 0xffff; white_col.blue = 0xffff;
  gdk_colormap_alloc_color(colormap, &white_col, FALSE, TRUE);

  areyousure = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (areyousure), "Are you sure?");
  gtk_signal_connect (GTK_OBJECT (areyousure), "delete_event", (GtkSignalFunc) sure_cancel, NULL);
  gtk_signal_connect (GTK_OBJECT (areyousure), "destroy", (GtkSignalFunc) sure_cancel, NULL);
  gtk_window_set_policy (GTK_WINDOW (areyousure), FALSE, FALSE, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (areyousure)->vbox), 10);
  gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (areyousure)->vbox), 10);
  msg = gtk_label_new ("Current file has been modified.\nDo you want to save it?");
  gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (areyousure)->vbox), msg);
  gtk_widget_show (msg);
  yes = gtk_button_new_with_label ("Yes");
  gtk_signal_connect (GTK_OBJECT (yes), "clicked", (GtkSignalFunc) sure_yes, areyousure);
  gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (areyousure)->action_area), yes);
  GTK_WIDGET_SET_FLAGS (yes, GTK_CAN_DEFAULT);
  gtk_widget_show (yes);
  button = gtk_button_new_with_label ("No");
  gtk_signal_connect (GTK_OBJECT (button), "clicked", (GtkSignalFunc) sure_no, areyousure);
  gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (areyousure)->action_area), button);
  gtk_widget_show (button);
  button = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect (GTK_OBJECT (button), "clicked", (GtkSignalFunc) sure_cancel, NULL);
  gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (areyousure)->action_area), button);
  gtk_widget_show (button);
  gtk_window_set_modal(GTK_WINDOW(areyousure),TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(areyousure), GTK_WINDOW(window));
  action = -1;

  about = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (about), "About Xeukleides");
  gtk_signal_connect (GTK_OBJECT (about), "delete_event", (GtkSignalFunc) gtk_widget_hide, NULL);
  gtk_signal_connect (GTK_OBJECT (about), "destroy", (GtkSignalFunc) gtk_widget_hide, NULL);
  gtk_window_set_policy (GTK_WINDOW (about), FALSE, FALSE, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (about)->vbox), 10);
  gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (about)->vbox), 10);
  msg = gtk_label_new ("XEUKLEIDES 0.9.0\n\nCopyright (c) C.OBRECHT 2000-2002\n\n<christian.obrecht@wanadoo.fr>\n\n"
                       "See `eukleides\' entry in your local\ninfo tree for comprehensive documentation.");
  gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (about)->vbox), msg);
  gtk_widget_show (msg);
  button = gtk_button_new_with_label ("OK");
  gtk_signal_connect (GTK_OBJECT (button), "clicked", (GtkSignalFunc) hide, about);
  gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (about)->action_area), button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  opensel = (GtkFileSelection *)gtk_file_selection_new("Open File");
  gtk_signal_connect (GTK_OBJECT (opensel), "delete_event", (GtkSignalFunc) gtk_widget_hide, NULL);
  gtk_signal_connect (GTK_OBJECT (opensel), "destroy", (GtkSignalFunc) gtk_widget_hide, NULL);
  gtk_signal_connect (GTK_OBJECT (opensel->ok_button), "clicked", (GtkSignalFunc) openfile, NULL);
  gtk_signal_connect (GTK_OBJECT (opensel->cancel_button), "clicked", (GtkSignalFunc) hide, opensel);
  
  savesel = (GtkFileSelection *)gtk_file_selection_new("Save File As");
  gtk_signal_connect (GTK_OBJECT (savesel), "delete_event", (GtkSignalFunc) gtk_widget_hide, NULL);
  gtk_signal_connect (GTK_OBJECT (savesel), "destroy", (GtkSignalFunc) gtk_widget_hide, NULL);
  gtk_signal_connect (GTK_OBJECT (savesel->ok_button), "clicked", (GtkSignalFunc) savefileas, NULL);
  gtk_signal_connect (GTK_OBJECT (savesel->cancel_button), "clicked", (GtkSignalFunc) hide, savesel);
  
  switch(argc) {
    case 1 : newfunc();
             break;
    case 2 : if (argv[1][0] == '-') {
               if (argv[1][1] == 'v') version();
	       else if (argv[1][1] == 'h') usage(0);
	       else usage(1);
	     } 
	     else { 
	       file_name = argv[1];
	       readfile();
	     }
	     break;
    case 3 : if (argv[1][0] == '-' && argv[1][1] == 'V') {
		 file_name = argv[2];
  	         readfile();
		 setview(window, 1);
	      } else usage(1);
	      break;
    default : usage(1);
  }
  
  gtk_widget_show (window);
  if (!viewing) gtk_widget_grab_focus(text);
  gtk_main ();
  return 0;
}

int warning(char *msg)
{
  fprintf(stderr, "Warning at line %i: %s\n", lineno, msg);
  return 0;
}

int yyerror(char *msg)
{
  char tmp[80];
  int i = 0, l = 1;
  
  errorcount++;
  fprintf(stderr, "Error at line %i: %s\n", lineno, msg);
  snprintf(tmp, 80, "Error at line %i.\n", lineno);
  gdk_draw_rectangle (pixmap, window->style->white_gc, TRUE, 0, 0, Width, Height);
  gdk_gc_set_foreground(solid_gc,&red_col);
  gdk_draw_string(pixmap, font, solid_gc, 10, 20, tmp);
  gdk_gc_set_foreground(solid_gc,&white_col);
  while (i < file_length && l < lineno) {
    if (buffer[i] == '\n') l++;
    i++;
  }
  gtk_editable_set_position(GTK_EDITABLE(text),i);
  return 0;
}

