/*
 *  Euklides  version 0.3.4
 *  Copyright (c) Christian Obrecht 2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

#define MAX_ERRORS 10

extern FILE *yyin;

extern int yyparse(void);

int errorcount = 0, filter = 0, lineno = 1;

void usage(int code)
{
  printf("Usage is:\n\teuklides [ -v | -h ]\n\teuklides [ -f ] <filename>\n"
         "Options:\n\t-v\tPrint version number.\n\t-h\tPrint this help.\n"
         "\t-f\tRun as a filter\nSee man page for more informations.\n");
  exit(code);
}

void version(void)
{
  printf("This is euklides version 0.3.4\nCopyright (c) Christian Obrecht 2000-2001\n");
  exit(0);
}

void parser(char * arg)
{
  FILE *file;
  file = fopen(arg, "r");
  if (!file) {
    fprintf(stderr, "Could not open %s\n", arg);
    exit(1);
  }
  yyin = file;
  yyparse();
  if (!filter) printf("\\endpspicture\n");
  exit(0);
}
  
int main(int argc, char **argv)
{
  switch(argc) {
    case 1 : usage(0); 

    case 2 : if (argv[1][0] == '-') {
               if (argv[1][1] == 'v') version();
	       else if (argv[1][1] == 'h') usage(0);
	       else usage(1);
	     } 
	     else parser(argv[1]);

    case 3 : if ((argv[1][0] == '-') && (argv[1][1] == 'f')) {
               filter=1;
               parser(argv[2]);
  	     }
	     else usage(1);
    default : usage(1);
  }
  return 0;
}

void warning(char *msg)
{
  fprintf(stderr, "Warning at line %i: %s\n", lineno, msg);
}

void yyerror(char *msg)
{
  fprintf(stderr, "Error at line %i: %s\n", lineno, msg);
  errorcount++;
  if (errorcount > MAX_ERRORS) exit(1);
}