#ifndef FILE_H
#define FILE_H

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fox-1.6/fx.h>

#include "DialogBox.h"


FXbool isUtf8(const FXchar* string, FXuint length);
int statrep(const char *filename, struct stat *buf);
int lstatrep(const char *filename, struct stat *buf);
#ifdef linux
int lstatmt(const char *filename, struct stat *buf);
#endif
void runcmd(FXString cmd);
size_t strlcpy(char *dst, const char *src, size_t sz);
size_t strlcat(char *dst, const char *src, size_t sz);
void strlow(char *str);
int streq(const FXchar *a, const FXchar *b);
unsigned long long dirsize(const char *path);
unsigned long long pathsize(const char *path);
FXString hSize(FXchar* size);
FXString cleanPath(const FXString path);
FXString filePath(const FXString path);
FXString filePath(const FXString path, const FXString dir);
FXString stampname(const FXString filename);
FXint isEmptyDir(const FXString directory);
FXbool exists(const FXString& file);
FXbool isDirectory(const FXString& file);
FXbool isFile(const FXString& file);
FXbool isGroupMember(gid_t gid);
FXbool isWritable(const FXString& file);
//FXbool isLinkWritable(const FXString& file);
FXbool isReadable(const FXString& file);
FXbool isReadExecutable(const FXString& file);
FXbool isLink(const FXString& file);
FXbool info(const FXString& file,struct stat& inf);
FXString permissions(FXuint mode);
FXString readlink(const FXString& file);
FXbool identical(const FXString& file1,const FXString& file2);

// File operations
enum
{	
	COPY,
	RENAME,
	MOVE,
	SYMLINK,
	DELETE,
	CHMOD,
	CHOWN,
	EXTRACT,
	ARCHIVE,
#if defined(linux)
	PKG_INSTALL,
	PKG_UNINSTALL,
	MOUNT,
	UNMOUNT
#endif
};

// To search visited inodes
struct inodelist
{
    ino_t st_ino;
    inodelist *next;
};

class File : public DialogBox
{
    FXDECLARE(File)
protected:
	int checkTimeout(void);
    long fullread(int fd, unsigned char *ptr, long len);
    long fullwrite(int fd, const unsigned char *ptr, long len);
    FXbool copyfile(const FXString& source, const FXString& target, const FXbool preserve_date);
	FXbool copyrec(const FXString& source,const FXString& target,inodelist* inodes, const FXbool preserve_date);
    FXbool copydir(const FXString& source,const FXString& target,struct stat& parentstatus,inodelist* inodes, const FXbool preserve_date);
    int rchmod(char *path, char *file, mode_t mode, const FXbool dironly, const FXbool fileonly);
    int rchown(char *path, char *file, uid_t uid, gid_t gid, const FXbool dironly, const FXbool fileonly);
    FXLabel *uplabel;
    FXLabel *downlabel;
    FXProgressBar *progressbar;
	FXButton *cancelButton;
	FXbool overwrite;
	FXbool overwrite_all;
	FXbool skip_all;

public:
    File()
    {}
	~File();
    void create();
    File(FXWindow *owner, FXString title, const unsigned int operation);

	enum 
	{
		ID_CANCEL_BUTTON=DialogBox::ID_LAST,
		ID_TIMEOUT,
		ID_LAST
	};

	FXbool allowProgressDialog;
	FXbool isCancelled;
    FXbool copy(const FXString& source, const FXString& target, const FXbool confirm_dialog=TRUE, const FXbool preserve_date=TRUE);
    FXbool rename(const FXString& source, const FXString& target);
    FXbool move(const FXString& source, const FXString& target);
    FXbool symlink(const FXString& source, const FXString& target);
    FXbool remove(const FXString& file);

    int chmod(char *path, char *file, mode_t mode, const FXbool rec, const FXbool dironly=FALSE, const FXbool fileonly=FALSE);
    int chown(char *path, char *file, uid_t uid, gid_t gid, const FXbool rec, const FXbool dironly=FALSE, const FXbool fileonly=FALSE);
	int extract(const FXString name, const FXString dir,const FXString cmd);
	int archive(const FXString name, const FXString cmd);

#if defined(linux)
	int mount(const FXString dir, const FXString msg, const FXString cmd,const  unsigned int op);
	int pkgInstall(const FXString name, const FXString cmd);
	int pkgUninstall(const FXString name, const FXString cmd);
#endif
	long onCmdCancel(FXObject*, FXSelector,void*);
    long onTimeout(FXObject*,FXSelector,void*);
};
#endif


