/*  xffm4
 *
 *  Copyright (C) 2003 olivier fourdan <xfce@users.sourceforge.net>
 *  Copyright (C) 2003 edscott wilson garcia <edscott@users.sourceforge.net>
 *  Copyright (C) 2002 Jasper Huijsmans <huysmans@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif



#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <libxfcegui4/dialogs.h>
#include <libxfcegui4/xfce_framebox.h>
#include <libxfce4mcs/mcs-common.h>
#include <libxfce4mcs/mcs-manager.h>
#include <xfce-mcs-manager/manager-plugin.h>
#include <libxfce4util/i18n.h>
#include <libxfce4util/util.h>

#include "constants.h"
#include "types.h"

#ifndef XFFM_MCS_PLUGIN
#define XFFM_MCS_PLUGIN
#endif

#define CHANNEL  "xffm"
#define RCDIR    "settings"
#define RCFILE   "xffm.xml"

#ifndef PACKAGE_DATADIR
#define PACKAGE_DATADIR "/usr/local/share/xffm4"
#endif

#define BORDER 6
#define SKIP BORDER

static McsManager *mcs_manager;

#if 0
static GtkWidget **preference_w;
static GtkWidget **view_w;
#endif

typedef struct
{
  gchar   *variable;
  gchar   *value;
  gboolean editable;
}
Item;

enum
{
  COLUMN_VARIABLE,
  COLUMN_VALUE,
  COLUMN_EDITABLE,
  NUM_COLUMNS
};

/*static GtkWidget *layer_menu;*/

/*static gboolean is_running = FALSE;*/
static GtkWidget *dialog = NULL;
#include "pixmaps/xffm_icon.xpm"

/********************************************************/
static McsManager *mcs_manager = NULL;

enum {
    TERM,
    XFFM_HOME,
    XFFM_STATUS_LINE_LENGTH,
    XFFM_MAX_PREVIEW_SIZE,
    SMB_USER,
    SMB_CODESET,
    XFFM_HOLD_XTERM,
    XFFM_APPEND_FILES,
    XFFM_HIDE_BOOK,
    XFFM_HIDE_LOCAL,
    XFFM_HIDE_NETWORK,
    XFFM_HIDE_APPS,
    XFFM_HIDE_FIND,
    XFFM_HIDE_TRASH,
    XFFM_HIDE_FSTAB,
    XFFM_DEFAULT_UNLINK,
    XFFM_USE_SUDO,
    XFFM_OPTIONS
};

typedef struct
{
  gchar   *name;
  gchar   *value;
}
Options;

static Options xffm_options[XFFM_OPTIONS]={
	{ "TERM",                    NULL },
	{ "XFFM_HOME",               NULL },
	{ "XFFM_STATUS_LINE_LENGTH", NULL },
	{ "XFFM_MAX_PREVIEW_SIZE",   NULL },
	{ "SMB_USER",                NULL },
	{ "SMB_CODESET",             NULL },
	{ "XFFM_HOLD_XTERM",         NULL },
	{ "XFFM_APPEND_FILES",       NULL },
	{ "XFFM_HIDE_BOOK",          NULL },
	{ "XFFM_HIDE_LOCAL",         NULL },
	{ "XFFM_HIDE_NETWORK",       NULL },
	{ "XFFM_HIDE_APPS",          NULL },
	{ "XFFM_HIDE_FIND",          NULL },
	{ "XFFM_HIDE_TRASH",         NULL },
	{ "XFFM_HIDE_FSTAB",         NULL },
	{ "XFFM_USE_SUDO",         NULL },
	{ "XFFM_DEFAULT_UNLINK",     NULL }
};

/* Fwd. decl. */
static void run_xffm_settings_dialog(McsPlugin *);
static void create_channel(void);
static gboolean write_options(void);

McsPluginInitResult mcs_plugin_init(McsPlugin *mp)
{
#if 0
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
    textdomain (GETTEXT_PACKAGE);
#endif
#else
    xfce_textdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");
#endif

    mcs_manager = mp->manager;
    create_channel();
    mp->plugin_name = g_strdup(CHANNEL);
    mp->caption = g_strdup(_("File manager"));
    mp->run_dialog = run_xffm_settings_dialog;
    mp->icon = gdk_pixbuf_new_from_xpm_data((const char **)xffm_icon_xpm);
    mcs_manager_notify(mp->manager, CHANNEL);

    return MCS_PLUGIN_INIT_OK;
}

static void create_channel(void)
{
    McsSetting *setting;

    /*const gchar *home = g_get_home_dir();*/
    gchar *rcfile;
    gint i;

    /*rcfile = g_strconcat(home, G_DIR_SEPARATOR_S, ".xfce4", G_DIR_SEPARATOR_S, RCDIR, G_DIR_SEPARATOR_S, RCFILE, NULL);*/
    rcfile = xfce_get_userfile(RCDIR, RCFILE, NULL);
    mcs_manager_add_channel_from_file(mcs_manager, CHANNEL, rcfile);
    g_free(rcfile);rcfile=NULL;

    for (i = 0; i < XFFM_OPTIONS; i++)
    {
        setting = mcs_manager_setting_lookup(mcs_manager, xffm_options[i].name, CHANNEL);
        if(setting)
        {
            if(xffm_options[i].value)
            {
                g_free(xffm_options[i].value);
		xffm_options[i].value=NULL;
            }
            xffm_options[i].value = g_strdup(setting->data.v_string);
        }
        else
        {
            xffm_options[i].value = g_strdup("");
            mcs_manager_set_string(mcs_manager, xffm_options[i].name, CHANNEL, xffm_options[i].value);
        }
    }
}

static gboolean write_options(void)
{
    /*const gchar *home = g_get_home_dir();*/
    gchar *rcfile;
    gboolean result;

    rcfile = xfce_get_userfile(RCDIR, RCFILE, NULL);
/*    rcfile = g_strconcat(home, G_DIR_SEPARATOR_S, ".xfce4", G_DIR_SEPARATOR_S, RCDIR, G_DIR_SEPARATOR_S, RCFILE, NULL);*/
    result = mcs_manager_save_channel_to_file(mcs_manager, CHANNEL, rcfile);
    g_free(rcfile);
    rcfile=NULL;
    return result;
}


/* macro defined in manager-plugin.h */
MCS_PLUGIN_CHECK_INIT
/********************************************************/

/* the dialog ******************************************/
static void add_spacer(GtkBox * box)
{
    GtkWidget *eventbox = gtk_alignment_new(0,0,0,0);

    gtk_widget_set_size_request(eventbox, SKIP, SKIP);
    gtk_widget_show(eventbox);
    gtk_box_pack_start(box, eventbox, FALSE, TRUE, 0);
}

static gboolean environment_changed(GtkCellRendererText *cell,
	     const gchar         *path_string,
	     const gchar         *new_text,
	     gpointer             data)
{             
    GtkTreeModel *model = (GtkTreeModel *)data;
    GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
    GtkTreeIter iter;

    gint *column;

    column = g_object_get_data (G_OBJECT (cell), "column");

    gtk_tree_model_get_iter (model, &iter, path);

    if (GPOINTER_TO_INT (column) == COLUMN_VALUE) {
    
	gint i;
	gchar *old_text;

        gtk_tree_model_get (model, &iter, column, &old_text, -1);
	g_free (old_text);
	old_text=NULL;
	i = gtk_tree_path_get_indices (path)[0] + TERM;
        if (xffm_options[i].value)
        {
            g_free(xffm_options[i].value);
            xffm_options[i].value = NULL;
        }
	if (new_text && strlen(new_text)) {
		xffm_options[i].value = g_strdup (new_text);
	} else {
		xffm_options[i].value = g_strdup("");
	}
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, column,
                            xffm_options[i].value, -1);
        mcs_manager_set_string(mcs_manager, xffm_options[i].name, CHANNEL, xffm_options[i].value);
        mcs_manager_notify(mcs_manager, CHANNEL);
        write_options();
    }
    gtk_tree_path_free (path);
    
    return FALSE;
}

/* the dialog */
static void dialog_delete(GtkWidget *dialog)
{
    gtk_widget_destroy(dialog);
    dialog = NULL;
}

static void run_xffm_settings_dialog(McsPlugin *mp)
{
    GtkWidget *header, *vbox,*frame, *sw;
    int i;
    GtkListStore *model;
    GtkTreeIter iter;
    GtkCellRenderer *renderer;
    GtkWidget *treeview;

    dialog = gtk_dialog_new_with_buttons(_("File manager"),
                                    	 NULL, GTK_DIALOG_NO_SEPARATOR, 
					 GTK_STOCK_CLOSE, GTK_RESPONSE_OK,
					 NULL);

    g_signal_connect(dialog, "response", G_CALLBACK(dialog_delete), NULL);
    g_signal_connect(dialog, "delete_event", G_CALLBACK(dialog_delete), NULL);
    g_signal_connect(dialog, "destroy", G_CALLBACK(dialog_delete), NULL);
    
    /* pretty header */
    vbox = GTK_DIALOG(dialog)->vbox;
    header = create_header(mp->icon, _("Xffm Settings"));
    gtk_box_pack_start(GTK_BOX(vbox), header, FALSE, TRUE, 0);
    
    add_spacer(GTK_BOX(vbox));
 
    frame = xfce_framebox_new (_("Global Configuration"), FALSE);
    gtk_widget_show(frame);
    gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);

    sw = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
					 GTK_SHADOW_ETCHED_IN);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
    gtk_container_set_border_width(GTK_CONTAINER(sw), BORDER);
    gtk_widget_show(sw);
    xfce_framebox_add (XFCE_FRAMEBOX (frame), sw);

    model = gtk_list_store_new (NUM_COLUMNS, G_TYPE_STRING, G_TYPE_STRING,
			      G_TYPE_BOOLEAN);
    for (i=0; i < XFFM_OPTIONS; i++) {
        gtk_list_store_append (model, &iter);

        gtk_list_store_set (model, &iter,
			  COLUMN_VARIABLE,
			  g_strdup (xffm_options[i].name),
			  COLUMN_VALUE,
			  g_strdup (xffm_options[i].value),
			  COLUMN_EDITABLE,
			  TRUE,
			  -1);
    }
    treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL(model));
    g_object_unref (G_OBJECT (model));
    gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
    gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)),
				 GTK_SELECTION_SINGLE);
    /* variable column */
    renderer = gtk_cell_renderer_text_new ();
    g_signal_connect (G_OBJECT (renderer), "edited",
		      G_CALLBACK (environment_changed), model);
    g_object_set_data (G_OBJECT (renderer), "column", (gint *)COLUMN_VARIABLE);

    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
					         -1, _("Variable"), renderer,
					         "text", COLUMN_VARIABLE,
					         NULL);
    /* value column */
    renderer = gtk_cell_renderer_text_new ();
    g_signal_connect (G_OBJECT (renderer), "edited",
		      G_CALLBACK (environment_changed), model);
    g_object_set_data (G_OBJECT (renderer), "column", (gint *)COLUMN_VALUE);

    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
					         -1, _("Value"), renderer,
					         "text", COLUMN_VALUE,
					         "editable", COLUMN_EDITABLE,
					         NULL);

    gtk_widget_set_size_request(treeview, 320, 200);
    gtk_widget_show(treeview);
    gtk_container_add (GTK_CONTAINER (sw), treeview);

    gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
    gtk_widget_show(dialog);
}

