#!/bin/sh

# Prepare a distribution registered with iso8859-5. # rawin-r.

# Directory to prepare files in.
targetdir="./xcyr-2.3-1251"

# Prepare that directory.

./mktargetdir.sh "$targetdir"

# Transform all fonts.

echo Recoding fonts:
for font in misc/*.bdf 100dpi/*.bdf 75dpi/*.bdf
do
	name=`expr $font : 'misc/koi\(.*bdf\)'`
    perl bdfrecode.pl -table=xcyr2cp1251.txt -registry=RAWIN-R < "$font" > "$targetdir"/$font
	[ x"$name" != "x" ] && mv "$targetdir/$font" "$targetdir/misc/win$name"
    echo "$font"
done

# Transform "fonts.alias" in the "misc" directory
perl -e 'while(<>){s/koi8-c/RAWIN-R/g;s/^koi/win/g;print if (/^win/);}' < misc/fonts.alias > "$targetdir"/misc/fonts.alias

# Transform the special font "koinil2.bdf"

perl bdfrecode.pl -table=full.table -registry=RAWIN-R < misc/koinil2.bdf > $targetdir/misc/koinil2.bdf

# Transform "Makefile" in the "misc" directory

perl -e 'while(<>){s/koi/win/g;print;}' < misc/Makefile > "$targetdir"/misc/Makefile

# Transform "install.sh" to install into "cyrillic-1251" by default

perl -e 'while(<>){s/(targetdir=.*cyrillic)/\1-1251/;print;}' < install.sh > "$targetdir"/install.sh

echo Done.




