/* $Id: xkbsel-aw.c,v 1.7 1999/08/03 16:13:10 stano Exp $

   Simple Athena widgets selector/indicator

   (C) 1999 Stanislav Meduna <stano@eunet.sk>
*/

#include <config.h>
#include <xkbsel-aw.h>
#include <xkbselx.h>

#include <stdio.h>
#include <stdlib.h>
#include <libintl.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

#include <X11/Xaw/Label.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

#define _(s) gettext(s)


static Display*   disp;      /* X display */

static sel_info_t cur_sel;   /* Current selection */

static Widget     root_w;    /* Shell widget */

static Widget     form_w;     /* Container widget */

static Widget     ind_w;     /* Indicator widget */
static Widget     comm_w;    /* Communication widget */
static Widget     menu_w;    /* Menu widget */

static Widget     *sme_w;    /* Menu entries */

static Atom       wmDeleteWindow;

static int        term_flag = 0;

static char *fb_res[] = {
	"*international: True",
	"*fontSet: " FONTSET_NAME,
	NULL
	};


/* === Forward declarations === */

static void click_cb(Widget w, XtPointer client_data, XtPointer call_data);
static void unnotify_cb(Widget w, XtPointer client_data, XtPointer call_data);
static void menu_cb(Widget w, XtPointer client_data, XtPointer call_data);
static void wm_delete_filter(Widget w, XtPointer closure, XEvent *ev, Boolean *cont);

/* === Implementation === */

int main(int argc, char **argv)
{
	XtAppContext app_ctx;
	XEvent event;
	int i;
	int r;
	int first_one;
	Cursor menu_c;

	/* Initialize */
	XtSetLanguageProc(NULL, NULL, NULL);

	root_w = XtVaAppInitialize(
		&app_ctx,
		APPL_CLASS,
		NULL, 0,
		&argc, argv,
		fb_res,
		NULL
		);

	/* XtAppSetFallbackResources(app_ctx, fb_res1);*/

	disp = XtDisplay(root_w);

	/* Read the config */
	r = read_config();
	if (r < 0)
		exit(1);

	textdomain(PACKAGE);

	/* Box for all of this */
	form_w = XtVaCreateManagedWidget(
		"form", 
		formWidgetClass,
		root_w,
		XtNdefaultDistance, 0,
		XtNborderWidth, 0,
		NULL);

	/* Set the maximal width of indicated string */
	for (i=0; i < MAX_SHORTCUT_LEN; i++)
		cur_sel.shortcut[i] = 'M';
	cur_sel.shortcut[i] = 0;

	/* The indicator is simply a text window */
	ind_w = XtVaCreateManagedWidget(
		"indicator", 
		menuButtonWidgetClass,
		form_w,
		XtNlabel, cur_sel.shortcut,
		XtNborderWidth, 0,
		XtNinternalHeight, 0,
		XtNinternalWidth, 0,
		XtNjustify, XtJustifyCenter,
		XtNresize, True,
		XtNmenuName, "menu",
		XtNhighlightThickness, 0,
		NULL);

	strcpy(cur_sel.shortcut, "not set");

	/* Communication window is a mini-button */
	comm_w = XtVaCreateManagedWidget(
		"communicator", 
		commandWidgetClass,
		form_w,
		XtNlabel, "",
		XtNborderWidth, 0,
		XtNhighlightThickness, 0,
		XtNheight, 1,
		XtNwidth, 1,
		XtNresize, False,
		NULL);

	XtAddCallback(comm_w, XtNcallback, click_cb, NULL);
	XtAddCallback(comm_w, XtNdestroyCallback, unnotify_cb, NULL);

	/* Menu */
	menu_c = XCreateFontCursor(disp, XC_left_ptr);

	menu_w = XtVaCreatePopupShell(
		"menu",
		simpleMenuWidgetClass,
		root_w,
		XtNlabel, _("Select a keyboard"),
		XtNcursor, menu_c,
		NULL);

	/* Menu entries */
	r = open_db();
	if (r < 0)
		exit(1);

	sme_w = (Widget *) malloc((n_locale_maps) * sizeof(Widget));
	if (sme_w == NULL)
	{
		fprintf(stderr, _("Out of memory\n"));
		exit(1);

	}

	first_one = -1;
	for (i=0; i < n_locale_maps; i++)
	{
		char buf1[8];
		char buf2[MAX_SHORTCUT_LEN+MAX_DESCRIPTION_LEN+16];
		db_record_t rec;
		int found;

		r = read_db_name(locale_maps[i].map_name, &rec, &found);
		if (r < 0)
			exit(1);

		if (! found)
		{
			fprintf(stderr, _("Map name %s not found - ignored\n"), locale_maps[i].map_name);
			continue;
		}

		sprintf(buf1, "me%d", i);

		sprintf(buf2, "%-8s %s",
			locale_maps[i].shortcut,
			*rec.descr ? rec.descr : locale_maps[i].map_name);

		sme_w[i] = XtVaCreateManagedWidget(
			buf1,
			smeBSBObjectClass,
			menu_w,
			XtNlabel, buf2,
			NULL);

		XtAddCallback(sme_w[i], XtNcallback, menu_cb, (XtPointer) &locale_maps[i]);
		if (first_one == -1)
			first_one = i;
	}

	r = close_db();

	if (first_one == -1)
	{
		fprintf(stderr, _("No configured maps\n"));
		exit(1);
	}

	XtRealizeWidget(root_w);

	/* Window protocols */
	wmDeleteWindow = XInternAtom (disp, "WM_DELETE_WINDOW", False);
	XSetWMProtocols (disp, XtWindow(root_w), &wmDeleteWindow, 1);
	XtInsertEventTypeHandler(
		root_w,
		ClientMessage, 
		NULL,
		wm_delete_filter,
		NULL,
		XtListTail);

	/* Announce that we are here */
	notify_me(disp, XtWindow(comm_w), 1);

	/* Select first configured map */
	menu_cb(sme_w[0], &locale_maps[first_one], NULL);

	/* Query the current selection */
	click_cb(comm_w, NULL, NULL);

	while(! term_flag)
	{
		XtAppNextEvent(app_ctx, &event);
		XtDispatchEvent(&event);
	}

	exit(0);

}

static void click_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
	int r;
	int found;

	sel_info_t sel;

	r = get_current_sel(disp, &sel, &found);

	if (!r && found)
		XtVaSetValues(ind_w,
			XtNlabel, sel.shortcut,
			NULL);
	else
		XtVaSetValues(ind_w,
			XtNlabel, _("none"),
			NULL);
}

static void unnotify_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
	if (XtIsRealized(comm_w))
		notify_me(disp, XtWindow(comm_w), 0);
}

static void menu_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
	int r;
	sel_info_t *sel = (sel_info_t *) client_data;

	if (flag_debug)
		fprintf(stderr, _("Selected %s\n"), sel->shortcut);

	r = open_db();
	if (r < 0)
		return;

	r = install_map(sel->map_name);

	if (! r)
		publish_current_sel(disp, sel);

	close_db();
	
	return;
}

static void wm_delete_filter(Widget w, XtPointer closure, XEvent *ev, Boolean *cont)
{
	/* check for delete window requests */
	if ((ev->xclient.format == 32) &&
            (ev->xclient.data.l[0] == wmDeleteWindow))
	{
		/* We need to talk with the server a bit - don't exit too soon */
		XSynchronize(disp, True);

		XtDestroyWidget(root_w);
		term_flag = 1;
	}

	*cont = True;
}

