#include <stdio.h>

#include "args.h"
#include "startup.h"
#include "../config.h"

char * startup_copy_right = "xlc[m] Copyright 2001 by S. Fuchs <sfuchs@gmx.net>\n\
Licensed under the GPL, see file LICENSE of the distribution package.\n";
char * startup_version = "version: "VERSION"\n";

char * startup_help_args[] = {
	"about",
	"help",
	"version",
	"v",
	"h",
	NULL
};

void startup_check(int argnum, char ** args)
{
	char do_exit = 0;
	int i;
	printf("\n");
	printf(startup_copy_right);
	printf(startup_version);
	// check whether we have to print the
	// help message and exit
	args_set_data(argnum, args);
	for ( i=1; startup_help_args[i]; i++ )
		do_exit |= args_hasopt(startup_help_args[i]);
	
	//----
	
	if ( do_exit )
	{
		printf("\nSupported options:\n");
		printf("  --line=#       set default line ('-l #')\n");
		printf("xlc[m] is part of the LineControl project.\n\
For further explanation please refer to http://linecontrol.sourceforge.net/\n");
		printf("\n");
		exit(0);
	}
}
