#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>

char *user_get_homedir(int uid)
// returns for example "/home/sci"
// max str len: 256
// you have to free the buffer afterwards yourself!
{
    static char line[1024];
    char *dum, *ptr;
    char *pwdfile = "/etc/passwd";
    char *retstr;
    int curuid = 0;
    int lines = 0;
    FILE *fpwd = fopen(pwdfile, "r");
    if ( !fpwd ) return(NULL);
    if ( !(retstr = g_malloc(256)) ) return(NULL);
    if ( !uid )
    {
		printf("warning: taking /root as the homedir of user 0 without lookup!\n");
		fclose(fpwd);
		strcpy(retstr, "/root");
		return(retstr);
    }
    while ( fgets(line, sizeof(line), fpwd) != NULL )
    {
		lines++;
		dum = ptr = line;
		// skip name
		while ( *ptr && *ptr != ':' ) ptr++; if ( *ptr ) ptr++;
		// skip passwd
		while ( *ptr && *ptr != ':' ) ptr++; if ( *ptr ) ptr++;
		sscanf(ptr, "%d", &curuid);
		if ( curuid != uid ) continue;
		// skip uid
		while ( *ptr && *ptr != ':' ) ptr++; if ( *ptr ) ptr++;
		// skip gid:
		while ( *ptr && *ptr != ':' ) ptr++; if ( *ptr ) ptr++;
		// skip description:
		while ( *ptr && *ptr != ':' ) ptr++; if ( *ptr ) ptr++;
		dum = ptr;
		// skip homedir:
		while ( *ptr && *ptr != ':' && *ptr != '\n' ) ptr++;
		*ptr = 0; // terminate homedir (in dum) with 0 byte
	/*
		dum = strtok(line, ":"); // name
		dum = strtok(NULL, ":"); // passwd
		dum = strtok(NULL, ":"); // uid
		sscanf(dum, "%d", &curuid);
		dum = strtok(NULL, ":"); // gid
		dum = strtok(NULL, ":"); // description
		dum = strtok(NULL, ":"); // homedir
	*/
	    fclose(fpwd);
	    if ( strlen(dum) > 255 )
	    {
			printf("name of homedir to long (max 255 characters)!\n");
			return(NULL);
	    }
	    strcpy(retstr, dum);
	    return(retstr);
	}
    fclose(fpwd);
    return(NULL);
}
