#include "widgets_xlcm.h"
#include "support.h"

GtkWidget *wnd_activity = NULL;
GtkWidget *wnd_messages = NULL;
GtkMenu * mn_popup = NULL;

struct twdg_activity * wdg_activity;
struct twdg_messages * wdg_messages;
struct twdg_popup * wdg_popup;

const char * wdg_names_activity[] = {
	"prg_up",
	"prg_down",
	NULL
};

const char * wdg_names_messages[] = {
	"cl_msg_messages",
	"bt_msg_clear",
	"bt_msg_close",
	NULL
};

const char * wdg_names_popup[] = {
	NULL
};

void widgets_init()
{
	wdg_activity = g_malloc(sizeof(struct twdg_activity));
	wdg_activity->realized = FALSE;
	wdg_messages = g_malloc(sizeof(struct twdg_messages));
	wdg_messages->realized = FALSE;
	wdg_popup = g_malloc(sizeof(struct twdg_popup));
	wdg_popup->realized = FALSE;
}

inline void widgets_load(GtkWidget *parent, const char * names[], gpointer * ptrs[])
{
	while ( *names )
	{
		*ptrs = (gpointer*)lookup_widget(parent, *names);
		if ( !*ptrs )
			g_print("can't find widget '%s'.\n", *names);
		ptrs++;
		names++;
	}
}

void widgets_load_wdg_activity() { widgets_load(wnd_activity, wdg_names_activity, (void *)wdg_activity); wdg_activity->realized = TRUE; }
void widgets_load_wdg_messages() { widgets_load(wnd_messages, wdg_names_messages, (void*)wdg_messages); wdg_messages->realized = TRUE; }
void widgets_load_wdg_popup() { widgets_load(GTK_WIDGET(mn_popup), wdg_names_popup, (void*)wdg_popup); wdg_popup->realized = TRUE; }
