package xm::cdefs;
use xm::o;

sub DESC
{"
  will look for a CBLKs and their preceding names and comments.
  Just mark these as CDEFs for later parsing...
"}

sub ARGS { return xm::o::args_stdin(@_,DESC); }

sub DO
{
    my $in = shift;
    
    $in =~ s{ ((?: <CDOC\b[^<>]*> (?:(?:.(?!</?CDOC\b))*.?) </CDOC\b[^<>]*> \ *\s?\ * )*)
              (\w[\s\w\[\*\]\(\,\)\:\=\.]*)                    # the header
              ((?: <CDOC\b[^<>]*> (?:(?:.(?!</?CDOC\b))*.?) </CDOC\b[^<>]*> \ *\s?\ * )*)
              (<CBLK\b[^<>]*> (?:(?:.(?!</?CBLK\b))*.?) </CBLK\b[^<>]*>) 
            }
            { "<ITEMCDEF>"
	      .$1                             # change: no extra markup anymore
              .(length $2 ? "<CDCL>".$2."</CDCL>" : "")
              .$3                             # change: no extra markup anymore
              .$4                             # stick to <CBLK>
              ."</ITEMCDEF>" 
            }gsex;
    $in =~ s{ (</ITEMCDEF>) (\s*\; | \s*\**\s*[\w\[\]]+ \s*\**\s*\;) }{$2.$1}gsex; # expand tail
    $in =~ s{ (\s*) ([\w\[\*\]\s]*) (<ITEMCDEF>)}{$1.$3.$2}gsex; # expand head (quick version)
    
    return $in;
} 

1;

