package xm::pfe::grab4compiles;
use strict;
use xm::o;

sub DESC
{"
  will look for all PFE COMPILES-declaration which is a macro to
  define a global static structure outside any ITEMCDEF.
  Mark these as ITEMCDEF on the outer closure and some inner portions
  with XXXXCOMPILES.
"}

sub ARGS { return xm::o::args_stdin(@_,DESC); }

sub DO
{
    my $in = shift;

    # use-CDEFS style    
    $in =~ s{  (^|</ITEMCDEF\b[^<>]*>)  ((?:.(?!</?(?:CDOC|ITEMCDEF)\b))*.?)
        	((?: \ *<CDOC\b[^<>]*(?=>)  (?:.(?!</?CDOC\b))*.  </CDOC\b[^<>]*> \ *\s? )*)
        	(\b(?:P4)?COMPILES\d*) (\s*\(\s*) (\w+) ((?:\s*,\s*\w+)+) (\s*\)\s*\;\ *\s?)
            } 
            { 
                print STDERR ":"; 
                $1.$2
                ."<ITEMCDEF>".$3
                ."<TYPECOMPILES>".$4."</TYPECOMPILES>".$5
                ."<NAMECOMPILES>".$6."</NAMECOMPILES>"
                ."<INFOCOMPILES>".$7."</INFOCOMPILES>".$8
                ."</ITEMCDEF>" 
            }gsex;
   
    return $in;
} 

1;

