use strict;
use xm::o;

xm::o::argv_stdin("converting a xm-hashtable to a html-table");

sub detect_fields
{
    my $text = shift;
    my $field = shift;
    
    $text =~ s{ <([A-Z]+)\b[^<>]*> (?:.(?!</?\1\b))*. </\1\b[^<>]*> }
             { push @{$field}, $1; "" }gsex;
}

if (length $o{" "})
{
    local $_ = $o{" "};
    my $itemsep;
    my @fields;
    /^[^<>]*<([A-Z]+)\b/sx && do { $itemsep = $1; };
    
    /^<$itemsep\b[^<>]*> ((?:.(?!<\/?$itemsep\b))*.) <\/$itemsep\b[^<>]*>/sx
    &&  detect_fields($1, \@fields);
    
    if(1) # if ($#fields > 0)
    {
        print "<html>";
        print "<title>",$itemsep;
        print ": ",$o{title} if exists $o{title};
        print "</title>\n";
        print "<body bgcolor=\"#D0D0D0\">";
        print "<h2 align=center>",$itemsep;
        print ": ",$o{title} if exists $o{title};
        print "</h2>\n";
        print "<table width=100\%>\n";
        print "<tr>\n";
        s{<$itemsep\b([^<>]*)>} {"<tr$1 valign=top>"}gsex;
        s{</$itemsep\b([^<>]*)>} {"</tr>"}gsex;
        
        my $f;
        for $f (@fields)
        {
            print "<th bgcolor=\"#F0F0F0\">",$f,"</th>\n";
            s{<$f\b([^<>]*)>} {"<td$1 bgcolor=white><pre>"}gsex;
            s{</$f\b([^<>]*)>} {"</pre></td>"}gsex;
        }
        print "</tr>\n";
    
        print $_;
        print "</table>\n";
        print "<p>",`date`,", ",`id -un`,"</p>";
        print "\n</body></html>";
    }
}

