/* 

    TiMidity -- Experimental MIDI to WAVE converter
    Copyright (C) 1995 Tuukka Toivonen <toivonen@clinet.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    linux_audio.c

    Functions to play sound on the VoxWare audio driver (Linux or FreeBSD)

*/

#define _GNU_SOURCE
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#ifdef linux
#include <sys/ioctl.h> /* new with 1.2.0? Didn't need this under 1.1.64 */
#include <linux/soundcard.h>
#endif

#include <stdio.h>

#ifdef __FreeBSD__
#include <machine/soundcard.h>
#endif

#include "mid.h"
#include "config.h"
#include "output.h"
#include "controls.h"

static int open_output(void); /* 0=success, 1=warning, -1=fatal error */
static void close_output(void);
static void output_data(int32 *buf, int32 count);
static void flush_output(void);
static void purge_output(void);

/* export the playback mode */

#define dpm xmms_play_mode

PlayMode dpm = {
  DEFAULT_RATE, PE_16BIT|PE_SIGNED,
  -1,
  {0}, /* default: get all the buffer fragments you can */
  "Linux dsp device", 'd',
  "/dev/dsp",
  open_output,
  close_output,
  output_data,
  flush_output,
  purge_output  
};


/*************************************************************************/
/* We currently only honor the PE_MONO bit, the sample rate, and the
   number of buffer fragments. We try 16-bit signed data first, and
   then 8-bit unsigned if it fails. If you have a sound device that
   can't handle either, let me know. */

static int open_output(void)
{
  if(mid_ip.output->open_audio(FMT_S16_LE,44100,2)==0)
    {
      fprintf(stderr,"Couldn't open audio!\n");
      return -1;
    }
  return 0;
}

static void output_data(int32 *buf, int32 count)
{
  if (!(dpm.encoding & PE_MONO)) count*=2; /* Stereo samples */
  while(mid_ip.output->buffer_free()< count*2 ) usleep(10000);
  if (dpm.encoding & PE_16BIT)
    {
      /* Convert data to signed 16-bit PCM */
      s32tos16(buf, count);
      
      /* Write the data out. Linux likes to give an EINTR if you suspend
	 a program while waiting on a write, so we may need to retry. */
      mid_ip.add_vis_pcm(mid_ip.output->written_time(),FMT_S16_LE,
                                      2,count*2,buf);
      mid_ip.output->write_audio(buf, count*2);
      
    }
  else
    {
      printf("Warning, unsupported code here");
      /* Convert to 8-bit unsigned and write out. */
      s32tou8(buf, count);
      
      while ((-1==write(dpm.fd, buf, count)) && errno==EINTR)
	;
    }
}

static void close_output(void)
{

}

static void flush_output(void)
{

}

static void purge_output(void)
{

}
