/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __EDITOR_PLAIN_TEXT_H__
#define __EDITOR_PLAIN_TEXT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_EDITOR_PLAIN_TEXT            (editor_plain_text_get_type ())
#define EDITOR_PLAIN_TEXT(obj)            (GTK_CHECK_CAST ((obj), TYPE_EDITOR_PLAIN_TEXT, EditorPlainText))
#define EDITOR_PLAIN_TEXT_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_EDITOR_PLAIN_TEXT, EditorPlainTextClass))
#define IS_EDITOR_PLAIN_TEXT(obj)         (GTK_CHECK_TYPE ((obj), TYPE_EDITOR_PLAIN_TEXT))
#define IS_EDITOR_PLAIN_TEXT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_EDITOR_PLAIN_TEXT))

typedef struct _EditorPlainText       EditorPlainText;
typedef struct _EditorPlainTextClass  EditorPlainTextClass;

struct _EditorPlainText
{
	GtkBin         bin;

	guint          cursor_text_offset;

	GtkWidget     *text;
};

struct _EditorPlainTextClass
{
	GtkBinClass parent_class;
};

GtkType    editor_plain_text_get_type  (void);
GtkWidget *editor_plain_text_new       ();

// if start < 0 => get selected text
gchar *editor_plain_text_get_text  (EditorPlainText *ept, gint *char_offset, gint start, gint end);
void editor_plain_text_set_text    (EditorPlainText *ept, gchar *text, gint char_offset);

// Manipulating selections
gboolean editor_plain_text_is_selected (EditorPlainText *ept);
void editor_plain_text_xchg_selection  (EditorPlainText *ept, gchar *text);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // __EDITOR_PLAIN_TEXT_H__
