/* SingIt Lyrics Displayer
 * Copyright (C) 2000, 2001 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_MAIN_H__
#define __SINGIT_MAIN_H__

#ifndef USE_GLIB_IDLE
#include <pthread.h>
#endif

typedef struct {

        gchar *fileName;
        GList *next_lyric_line;

	pthread_t display_thread;
	pthread_t check_thread;

	pthread_mutex_t config_rw_mutex;
	pthread_mutex_t lyrics_rw_mutex;
	pthread_mutex_t time_update_mutex;

	gboolean kill_display_thread;
	gboolean kill_check_thread;
	gboolean initialize_plugins;

	gboolean config_update;

	gint attachments;

} SingitStatus;

void singit_main_init(gboolean initialize_plugins);
void singit_main_finish(gboolean finish_plugins);

#endif  // __SINGIT_MAIN_H__
