/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Based on xmms visualization plugin mechanism */


#ifndef __SINGIT_PLUGIN_SCANNER_H__
#define __SINGIT_PLUGIN_SCANNER_H__

#include <glib.h>
#include <singit_displayer_plugin.h>

/*
  creates the plugin list and enables the selected displayer plugins
  and increases the attachments
*/
void plugins_init(void);
gboolean plugins_initialize(void);

/* frees all used memory and data if nobody elses uses the list  */
void plugins_finish(void);
gboolean plugins_finalize(void);

GList *get_dis_plugin_list(void);
GList *get_dis_plugin_enabled_list(gboolean initialized);

void set_dis_plugin_status_by_pointer(DisplayerPlugin *dp, gboolean enable);
void set_dis_plugin_status_by_number(gint plugin, gboolean enable);
gboolean is_dis_plugin_enabled(gint plugin);

gchar *dis_plugin_stringify_enabled_list(void);
void dis_plugin_enable_from_stringified_list(gchar *list);

/* calls the plugin funtion from the enabled list */
void dis_plugin_show(gint plugin);
void dis_plugin_hide(gint plugin);
void dis_plugin_toggle(gint plugin);
void dis_plugin_update(gint plugin);
void dis_plugin_playback_start(gint plugin);
void dis_plugin_playback_stop(gint plugin);
void dis_plugin_about(gint plugin);
void dis_plugin_configure(gint plugin);

void dis_plugin_render_freq(gint16 freq_data[2][256]);
void dis_plugin_render_pcm(gint16 pcm_data[2][512]);

/* tell all enabled plugins the actual status */
void plugins_set_time(gint time, LSong *cur_song, GList *real_next);

#endif // __SINGIT_PLUGIN_SCANNER_H__
