/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DLG_INPUT_TIME_H__
#define __DLG_INPUT_TIME_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_INPUT_TIME_DIALOG            (input_time_dialog_get_type ())
#define INPUT_TIME_DIALOG(obj)            (GTK_CHECK_CAST ((obj), TYPE_INPUT_TIME_DIALOG, InputTimeDialog))
#define INPUT_TIME_DIALOG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_INPUT_TIME_DIALOG, InputTimeDialog))
#define IS_INPUT_TIME_DIALOG(obj)         (GTK_CHECK_TYPE ((obj), TYPE_INPUT_TIME_DIALOG))
#define IS_INPUT_TIME_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_TIME_DIALOG))

typedef struct _InputTimeDialog       InputTimeDialog;
typedef struct _InputTimeDialogClass  InputTimeDialogClass;

struct _InputTimeDialog {

	GtkWindow  window;

	gint     max_time;
	gint     min_time;

	gint     time_offset;

	GtkSpinButton *time_spinbutton;

	GtkWidget     *input_timeline_zero_pushbutton;
	GtkWidget     *input_time_timestamp_label;
	GtkWidget     *time_offset_label;
};

struct _InputTimeDialogClass {

	GtkWindowClass parent_class;

	void (* new_time) (InputTimeDialog *itd, gint number);
};

GtkType    input_time_dialog_get_type   (void);
GtkWidget* input_time_dialog_new        (gchar *caption, gint width, gint height);
void       input_time_dialog_show       (InputTimeDialog *itd, GtkWindow *parent, 
					gboolean at_cursor, gboolean modal);
void       input_time_dialog_hide       (InputTimeDialog *itd);

void input_time_dialog_set_time (InputTimeDialog *itd, gint time);
gint input_time_dialog_get_time (InputTimeDialog *itd);

void input_time_dialog_set_max_time(InputTimeDialog *dialog, gint max);
void input_time_dialog_set_min_time(InputTimeDialog *dialog, gint min);

void input_time_dialog_set_time_offset (InputTimeDialog *itd, gint offset);
gint input_time_dialog_get_time_offset (InputTimeDialog *itd);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  // __DLG_INPUT_TIME_H__
