#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

void make_sensitive(GtkToggleButton *togglebutton, char *widgetname)
{
	GtkWidget *item;
	gboolean value;

	value = gtk_toggle_button_get_active(togglebutton);

	item = lookup_widget(GTK_WIDGET(togglebutton), widgetname);
	gtk_widget_set_sensitive(item, value);
	return;
}

void
on_config_useproxy_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	make_sensitive(togglebutton, "config_proxypanel");
	make_sensitive(togglebutton, "config_proxyauth");

}


void
on_config_proxyauth_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	make_sensitive(togglebutton, "config_authpanel");
}


void
on_config_savestream_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	make_sensitive(togglebutton, "config_savepanel");
}
	

void
on_config_usetitle_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	make_sensitive(togglebutton, "config_titlepanel");
}

