#! /bin/csh -f
#  $COPYRIGHT$
#

set distdir="$1"

set VERSIONFILE=

set start=`date`
cat <<EOF
 
Creating XMPI distribution
In directory: `pwd`
Started: $start
 
EOF

umask 022
set p="`pwd`"

#########################################################
# VERY IMPORTANT: Now go into the new distribution tree #
#########################################################

cd $distdir

set ver="`cat VERSION`"

#
# Put in those headers
#
 
echo "*** Inserting license headers..."

set filelist=/tmp/xmpi-license-filelist.$$
rm -f $filelist
cat > $filelist <<EOF
INSTALL
LICENSE
NEWS
README
EOF
find config -type f -print >> $filelist
find src -type f -print >> $filelist

chmod +x ./config/insertlic.csh 
./config/insertlic.csh $filelist
rm -rf $filelist

#
# Put the release version number in the README & INSTALL.  NEWS is
# already checked to match with latest version number by Automake #
#

echo "*** Updating version number in README & INSTALL..."
foreach file (README INSTALL)
    echo " - Setting $file"
    if (-f $file) then
	sed -e "s/INILIBRV/$ver/" $file > bar
	mv -f bar $file
    endif
end

#
# Set social Unix perms
#
 
echo "*** Setting social Unix permissions..."
chmod +x 	config/config.guess config/config.sub \
	config/install-sh \
	config/missing config/mkinstalldirs

cat <<EOF
*** XMPI version $ver distribution created
 
Started: $start
Ended:   `date`
 
EOF

