/*
 * $COPYRIGHT$
 *
 *	$Id: app_schema.h,v 1.3 2000/02/07 23:05:58 bbarrett Exp $
 * 
 *	Function:	- application schema templates and constants
 */

#ifndef _APP_SCHEMA_H
#define _APP_SCHEMA_H

#include "all_list.h"
#include "app_mgmt.h"
#include "lam.h"

/*
 * GER (Guaranteed Envelope Resources)
 */
#ifndef MPI_GER
#define MPI_GER			8
#endif

/*
 * structures 
 */
struct apparg {
	int4		apa_refcount;		/* reference count */
	int4		apa_argc;		/* # cmd line args */
	char		**apa_argv;		/* cmd line args */
};

struct appenv {
	int4		ape_refcount;		/* reference count */
	char		**ape_envv;		/* cmd line args */
	char		*ape_wrkdir;		/* working dir */
};

struct aschema {
	int4		asc_srcnode;		/* binary source node */
	int4		asc_node;		/* single target node */
	int4		asc_proc_cnt;		/* # processes this entry */
	int4		asc_errno;		/* error code */
	LIST *		asc_nodelist;		/* nodes this entry */
	struct apparg *	asc_args;		/* cmd line args */
	struct appenv *	asc_env;		/* environment */
};

/*
 * prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

extern LIST *	asc_bufparse(char*, int, int*, char**);
extern LIST *	asc_parse(const char *, int*, char**);
extern LIST *	asc_schedule(LIST *ap);
extern void	asc_free(LIST *ap);
extern int	asc_compat(int *, char ***);
extern int	asc_run(LIST*, int, int4, int,
			int , struct _gps*);
extern int	asc_ger(LIST*, int);
extern int	asc_environment(int, char*, char***);
extern int	asc_workdir(LIST*, char*);

#ifdef __cplusplus
}
#endif

#endif	/* _APP_SCHEMA_H */
