/*
 *	$COPYRIGHT$
 *
 *	$Id: lamtrace.h,v 1.4 2000/11/01 06:17:33 bbarrett Exp $
 *
 *	Function:	- macros for reading LAM traces and
 *			  extracting components
 */

#ifndef _LAMTRACE_H
#define _LAMTRACE_H

#include <stdio.h>

#include "app_mgmt.h"
#include "lam.h"

#define lamtr_raw_cid_m(c)	lamtr_read(&(c), sizeof(struct trcid), 1)
#define lamtr_raw_src_m(s)	lamtr_read(&(s), sizeof(struct trsrc), 1)
#define lamtr_raw_rthdr_m(r)	lamtr_read(&(r), sizeof(struct trrthdr), 1)
#define lamtr_raw_init_m(i)	lamtr_read(&(i), sizeof(struct trinit), 1)
#define lamtr_raw_onoff_m(o)	lamtr_read(&(o), sizeof(struct tronoff), 1)
#define lamtr_raw_xchg_m(x)	lamtr_read(&(x), sizeof(struct trxchg), 1)
#define lamtr_raw_msg_m(m)	lamtr_read(&(m), sizeof(struct trmsg), 1)
#define lamtr_raw_dtype_m(d)	lamtr_read(&(d), sizeof(struct trdtype), 1)

#define lamtr_raw_buoy_m(b)     lamtr_read(&(b), sizeof(struct trbuoy), 1)
#define lamtr_raw_commname_m(b) lamtr_read(&(b), sizeof(struct trcommname), 1)
#define lamtr_raw_color_m(b)    lamtr_read(&(b), sizeof(struct trcolor), 1)
#define lamtr_xt_magic_m(t, m)		ttoli4((int4 *) (t), (int4 *) (m))
#define lamtr_xt_nprocs_m(t, n)		ttoli4((int4 *) (t), (int4 *) (n))

#define lamtr_xt_world_m(t, n, w) \
	{ \
		memcpy((char *) (w), (char *) (t), (n) * sizeof(struct _gps)); \
		mttoli4((int4 *) (w), (n) * sizeof(struct _gps)/sizeof(int4)); \
	}

#define lamtr_xt_src_m(t, n, p, l) \
	{ \
		ttoli4(&(t)->trs_node, (int4 *) (n)); \
		ttoli4(&(t)->trs_pid, (int4 *) (p)); \
		ttoli4(&(t)->trs_listno, (int4 *) (l)); \
	}

#define lamtr_xt_cid_m(t, c, l, r) \
	{ \
		ttoli4(&(t)->trc_cid, (int4 *) (c)); \
		ttoli4(&(t)->trc_nlg, (int4 *) (l)); \
		ttoli4(&(t)->trc_nrg, (int4 *) (r)); \
	}

#define lamtr_xt_dtype_m(t, d, l) \
	{ \
		ttoli4(&(t)->trd_dtype, (int4 *) (d)); \
		ttoli4(&(t)->trd_length, (int4 *) (l)); \
	}

#define lamtr_xt_rt_time_m(t, time)	ttolf8(&(t)->trr_time, time)
#define lamtr_xt_rt_type_m(t, type)	ttoli4(&(t)->trr_type, type)

#define lamtr_xt_init_skew_m(t, skew)	ttolf8(&(t)->tri_skew, skew)
#define lamtr_xt_init_prog_m(t, prog)	(prog = &(t)->tri_name[0])

#define lamtr_xt_onoff_num_m(t, n)	ttoli4(&(t)->tro_trnum, n)

#define lamtr_xt_xchg_m(t, f, s) \
	{ \
		ttoli4(&(t)->trx_topfunc, f); \
		ttoli4(&(t)->trx_sub, s); \
	}

#define lamtr_xt_msg_cid_m(t, c)	ttoli4(&(t)->trm_cid, c)
#define lamtr_xt_msg_peer_m(t, p)	ttoli4(&(t)->trm_peer, m)
#define lamtr_xt_msg_msrc_m(t, msrc)	ttoli4(&(t)->trm_mrank, msrc)
#define lamtr_xt_msg_tag_m(t, tag)	ttoli4(&(t)->trm_tag, tag)
#define lamtr_xt_msg_mtag_m(t, tag)	ttoli4(&(t)->trm_mtag, tag)
#define lamtr_xt_msg_dtype_m(t, d)	ttoli4(&(t)->trm_dtype, d)
#define lamtr_xt_msg_top_m(t, f)	ttoli4(&(t)->trm_topfunc, f)
#define lamtr_xt_msg_wrap_m(t, w)	ttoli4(&(t)->trm_wrapfunc, w)
#define lamtr_xt_msg_seq_m(t, s)	ttoli4(&(t)->trm_seqnum, s)

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern void	lamtr_set_stream __ARGS((FILE *));
extern int	lamtr_open_file __ARGS((char *));
extern int	lamtr_read __ARGS((void *, size_t, size_t));
extern int	lamtr_parse_world __ARGS((int4 *, struct _gps **));
extern int 	lamtr_raw_world __ARGS((int4 *, char **));
extern int	lamtr_parse_comm __ARGS((int4 *, int4*, int4*, struct _gps **));
extern int	lamtr_raw_comm __ARGS((char *, struct _gps **));
extern int	lamtr_raw_dtype __ARGS((char **));
extern int	lamtr_parse_dtype __ARGS((int4 *, char **));
extern int	lamtr_find_rank __ARGS((int, struct _gps *, int, int));
	
#ifdef __cplusplus
}
#endif

#endif /* _LAMTRACE_H */
