# $Id$
if {$::argc > 0} {
  set DESTINATION [lindex $argv 0]
} else {
  # if now argument is given -> set to default
  set DESTINATION "/Progra~1/Tcl"
}

puts "Installing to Directory: $DESTINATION"

rename file tcl_file
proc file args {
  puts stderr "...$args"
  eval ::tcl_file $args
}

set bin "xotclsh.exe xowish.exe xotcl.dll"
foreach b $bin {
  if {[file exists src/Release/$b]} {
    file copy -force src/Release/$b $DESTINATION/bin
  } elseif {[file exists  src/$b]} {
    file copy -force src/$b $DESTINATION/bin
  }
}
file copy -force src/xotcl.h $DESTINATION/include
file mkdir $DESTINATION/lib/xotcl


proc copyDir {dir dest} {
  set files [glob -nocomplain $dir/*]
  foreach f $files {
    doDir $f $dest
  }
}

proc doDir {f dest} {
  if {[file isdirectory $f]} {
    file mkdir $dest/$f
    copyDir $f $dest
  } else {
    file copy -force $f $dest/$f
 }
}

cd lib

catch {exec $DESTINATION/bin/xotclsh.exe ./system/make.xotcl -target $DESTINATION/lib/xotcl -all}

set command "$DESTINATION/bin/xotclsh.exe ./system/make.xotcl -target $DESTINATION/lib/xotcl -all"
if {[catch {puts stderr [exec $DESTINATION/bin/xotclsh.exe ./system/make.xotcl -target $DESTINATION/lib/xotcl -all]\n} errMsg]} {
  puts "Package Creation FAILED\n$errMsg\n"
} else {
  puts "Package Creation SUCCEEDED\n"
}

foreach f [glob -nocomplain *] {
  doDir $f $DESTINATION/lib/xotcl
}


puts stderr "***************************************************"
puts stderr "INSTALLATION COMPLETE."
puts stderr "\nIn order to use XOTcl set PATH to "
puts stderr "  '$DESTINATION/bin' and"
puts stderr "set TCLLIBPATH to "
puts stderr "  '$DESTINATION/lib/xotcl'"
puts stderr "***************************************************"


