#ifndef VBoxP_h
#define VBoxP_h

/*
 * Box Widget Private Data
 */
#include <X11/Xmu/Converters.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/BoxP.h>
#ifndef VBox_h
#include <X11/Xmw/VBox.h>
#endif

/* No new fields for the VBox widget class record */
typedef struct {
	XtPointer extension;
} VBoxClassPart;

/* Full class record declaration */
typedef struct _VBoxClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	BoxClassPart		box_class;
	VBoxClassPart		vbox_class;
} VBoxClassRec;

extern VBoxClassRec vboxClassRec;

/* New fields for the Box widget record */
typedef struct {
	Boolean		resize;
} VBoxPart;

/*
 * Full instance record declaration
 */
typedef struct _VBoxRec {
	CorePart	core;
	CompositePart	composite;
	BoxPart		box;
	VBoxPart	vbox;
} VBoxRec;

#endif /* VBoxP_h */
