/*  This file is part of "xprintmon"
 *  Copyright (C) 2006 Bernhard R. Link
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02111-1301  USA
 */
#include <config.h>

#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>

#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xaw/XawInit.h>
#include <X11/xpm.h>

#include "global.h"

#include "images/printer.xpm"
#include "images/activeprinter.xpm"

#define APP_CLASS "XPrintMon"

/* options */
static XrmOptionDescRec options[] = {
	{ "-user", ".mainform.user.label", XrmoptionSepArg, NULL },
	{ "-iconic", ".iconic", XrmoptionNoArg, "True" }
};

static String fallback_resources[] = {
#include "defaults/fallback.res"
	NULL
};

static Arg shell_args[] = {
	/* XtNiconPixmap und XtNiconMask? */
};

XtAppContext context;
Widget app_shell;
Pixmap bm_printer, bm_printermask, bm_activeprinter, bm_activeprintermask;


static void CreatePixmap(char **data, Pixmap *pm, Pixmap *msk) {
	Display *dpy = XtDisplay(app_shell);
	Window w = DefaultRootWindow(dpy);

	XpmCreatePixmapFromData(dpy, w, data, pm, msk, NULL);
}

int main(int argc, String argv[]) {
	const char *username;
	Boolean iconic;

	initCollectors();
	XawInitializeWidgetSet();

	app_shell = XtOpenApplication(&context, APP_CLASS,
			options, XtNumber(options),
			&argc, argv,
			fallback_resources,
			applicationShellWidgetClass,
			shell_args, XtNumber(shell_args));
	iconic = 0;
	XtVaGetValues(app_shell, XtNiconic, &iconic, NULL);
	username = getenv("USER");
	if( username == NULL )
		username = getenv("LOGNAME");
	if( username != NULL ) {
		XrmDatabase database, datafromenvironment = NULL;

		database = XtDatabase(XtDisplay(app_shell));
		XrmPutStringResource(&datafromenvironment,
				"XPrintMon.mainform.user.label",
				username);
		XrmCombineDatabase(datafromenvironment, &database, False);
		datafromenvironment = NULL;
	}

	CreatePixmap(printer_xpm, &bm_printer, &bm_printermask);
	CreatePixmap(activeprinter_xpm, &bm_activeprinter, &bm_activeprintermask);

	initPrinterWindowData(app_shell);
	registerCollectors(context);
	if( !closeonexec(ConnectionNumber(XtDisplay(app_shell)))) {
		exit(EXIT_FAILURE);
	}
	initDeleteProtocol(XtDisplay(app_shell));
	createMainWindow(app_shell);
	if( iconic ) {
		Atom wmstate, type;
		int format;
		unsigned char *data;
		unsigned long nitems, left;

		XtRealizeWidget(app_shell);
		XIconifyWindow(XtDisplay(app_shell),
				XtWindow(app_shell),
				XScreenNumberOfScreen(XtScreen(app_shell)));
		// TODO: this is a wild hack. perhaps only do it if not detecting a window
		// manager by trying to get structure notify ourself, or only after the map
		// notify request or something like that....
		// But many wm's ignore WM_HINTS initial state, but look at WM_STATE left from others...
		wmstate = XInternAtom(XtDisplay(app_shell), "WM_STATE", False);
		if( XGetWindowProperty(XtDisplay(app_shell),
					XtWindow(app_shell),
					wmstate, 0, 2, False, wmstate,
					&type, &format, &nitems, &left,
					&data) == Success ) {
//			fprintf(stderr, "got %d(=%d?) %d %lu %lu %p\n", (int)type, (int)wmstate, format, nitems, left, data);
			if( type == None ) {
				// I don't get this property stuff. Is it long or uint32?
				long fakewmstate[2]= { IconicState, None };

				XChangeProperty(XtDisplay(app_shell),
						XtWindow(app_shell),
						wmstate, wmstate, 32,
						PropModeReplace,
						(unsigned char*)fakewmstate, 2);
//			} else if( format == 32 ) {
//				fprintf(stderr, "state is %ld\n", *(long*)data);

			}
			XFree(data);
//		} else {
//			fprintf(stderr, "got nothing\n");
		}
	}

	XtAppMainLoop(context);
	return 0;
}

/* compatibility implementations for some functions */

#ifndef HAVE_STRNDUP
#warning Private strndup implementation used
/* That's not the best possible strndup implementation, but it suffices for what
 * is used here */
char *strndup(const char *str,size_t n) {
	char *r = malloc(n+1);
	if( r == NULL )
		return r;
	memcpy(r,str,n);
	r[n] = '\0';
	return r;
}
#endif
