/*-
# X-BASED DINOSAUR CUBE
#
#  Dino.h
#
###
#
#  Copyright (c) 1995 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Dino */

#ifndef _XtDino_h
#define _XtDino_h

/***********************************************************************
 *
 * Dino Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNframeColor ((char *) "frameColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNdelay ((char *) "delay")
#define XtNview ((char *) "view")
#define XtNmode ((char *) "mode")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNface ((char *) "face")
#define XtNpos ((char *) "position")
#define XtNdirection ((char *) "direction")
#define XtNstyle ((char *) "style")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCDelay ((char *) "Delay")
#define XtCView ((char *) "View")
#define XtCMode ((char *) "Mode")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCFace ((char *) "Face")
#define XtCPos ((char *) "Position")
#define XtCDirection ((char *) "Direction")
#define XtCStyle ((char *) "Style")

typedef struct _DinoClassRec *DinoWidgetClass;

extern WidgetClass dinoWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
	int         face, position, direction, style;
} dinoCallbackStruct;
#endif

#define PUZZLE_HIDE (-10)
#define PUZZLE_PRACTICE_QUERY (-9)
#define PUZZLE_RANDOMIZE_QUERY (-8)
#define PUZZLE_SOLVE_MESSAGE (-7)
#define PUZZLE_RESTORE (-6)
#define PUZZLE_CLEAR (-5)
#define PUZZLE_RESET (-4)
#define PUZZLE_AMBIGUOUS (-3)
#define PUZZLE_ILLEGAL (-2)
#define PUZZLE_IGNORE (-1)
#define PUZZLE_MOVED 0
#define PUZZLE_CONTROL 1
#define PUZZLE_SOLVED 2
#define PUZZLE_PRACTICE 3
#define PUZZLE_RANDOMIZE 4
#define PUZZLE_DEC 5
#define PUZZLE_ORIENTIZE 6
#define PUZZLE_INC 7
#define PUZZLE_PERIOD2 8
#define PUZZLE_PERIOD3 9
#define PUZZLE_BOTH 10
#define PUZZLE_COMPUTED 11
#define PUZZLE_UNDO 12
#define PUZZLE_REDO 13
#define PUZZLE_DIM 14
#define PUZZLE_VIEW 15

#define MENU_GET 0
#define MENU_WRITE 1
#define MENU_EXIT 2
#define MENU_UNDO 3
#define MENU_REDO 4
#define MENU_CLEAR 5
#define MENU_RANDOMIZE 6
#define MENU_PRACTICE 7
#define MENU_SOLVE 8
#define MENU_ORIENTIZE 9
#define MENU_STICKY 10
#define MENU_VIEW 11

#define PERIOD2 2
#define PERIOD3 3
#define BOTH 4
#define MAXMODES 3
#define MAXFACES 6
#define MAXVIEWS 2
#define DEFAULTMODE PERIOD3
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

typedef struct _DinoRec *DinoWidget;

#endif /* _XtDino_h */
/* DON'T ADD STUFF AFTER THIS #endif */
