/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/slinkcheck.c,v 1.2 2001/04/07 19:46:50 justins Exp $ */
/*
   
   xscorch - slinkcheck.c     Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Scorched checkbox widgets
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>
#include <slinkcheck.h>
#include <gdk/gdkkeysyms.h>



static GtkCheckButtonClass *parent_class;



enum _ScLinkCheckSignals {
   MODIFIED_SIGNAL,
   LAST_SIGNAL
};
static gint _sc_link_check_signals[LAST_SIGNAL] = { 0 };



static void _sc_link_check_set(GtkToggleButton *toggle) {

   ScLinkCheck *check = SC_LINK_CHECK(toggle);
   
   if(GTK_TOGGLE_BUTTON_CLASS(parent_class)->toggled != NULL) {
      GTK_TOGGLE_BUTTON_CLASS(parent_class)->toggled(toggle);
   }

   if(check->value != NULL) *check->value = gtk_toggle_button_get_active(toggle);
   gtk_signal_emit(GTK_OBJECT(check), _sc_link_check_signals[MODIFIED_SIGNAL]);

}
 
 
 
static void _sc_link_check_class_init(ScLinkCheckClass *klass) {

   GtkObjectClass *object_class = (GtkObjectClass *)klass;
   
   parent_class = gtk_type_class(gtk_check_button_get_type());
   
   _sc_link_check_signals[MODIFIED_SIGNAL] =
      gtk_signal_new("modified", 
                     GTK_RUN_LAST,
                     object_class->type,
                     GTK_SIGNAL_OFFSET(ScLinkCheckClass, modified),
                     gtk_marshal_NONE__NONE,
                     GTK_TYPE_NONE, 0);

   gtk_object_class_add_signals(object_class, _sc_link_check_signals, LAST_SIGNAL);

   klass->modified = NULL;
   GTK_TOGGLE_BUTTON_CLASS(klass)->toggled = _sc_link_check_set;

}



static void _sc_link_check_init_obj(ScLinkCheck *check) {
   
   check->value = NULL;
   
}



GtkType sc_link_check_get_type(void) {

   static GtkType sc_link_check_type = 0;
   
   if(sc_link_check_type == 0) {
      static const GtkTypeInfo sc_link_check_info = {
         (char *)"ScLinkCheck",
         sizeof(ScLinkCheck),
         sizeof(ScLinkCheckClass),
         (GtkClassInitFunc)_sc_link_check_class_init,
         (GtkObjectInitFunc)_sc_link_check_init_obj,
         (GtkArgSetFunc)NULL,
         (GtkArgGetFunc)NULL
      };
      sc_link_check_type = gtk_type_unique(gtk_check_button_get_type(), &sc_link_check_info);
   }
    
   return(sc_link_check_type);

}  



GtkWidget *sc_link_check_new(int *value) {

   ScLinkCheck *check;
   
   check = gtk_type_new(sc_link_check_get_type());
   g_return_val_if_fail(check != NULL, NULL);

   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), *value);
   check->value = value;

   return(GTK_WIDGET(check));

}



