// file      : xsde/cxx/parser/validating/idrefs-stl.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/pre.hxx>

#include <xsde/cxx/config.hxx>

#include <xsde/cxx/parser/validating/idrefs-stl.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace validating
      {
        void idrefs_pimpl::
        _pre ()
        {
          seq_.clear ();
          idrefs_pskel::_pre ();
        }

        void idrefs_pimpl::
        _post ()
        {
          idrefs_pskel::_post ();

          // Should have at least one element.
          //
          if (!_error_p () && seq_.size () < 1)
            _schema_error (schema_error::invalid_idrefs_value);
        }

        string_sequence idrefs_pimpl::
        post_idrefs ()
        {
          string_sequence r;
          r.swap (seq_);
          return r;
        }

        void idrefs_pimpl::
        _xsde_parse_item (const ro_string& s)
        {
          parser_.pre ();

          if (!parser_._error_p ())
            parser_._pre ();

          if (!parser_._error_p ())
            parser_._characters (s);

          if (!parser_._error_p ())
            parser_._post ();

          if (!parser_._error_p ())
          {
            const std::string& s = parser_.post_idref ();

            if (!parser_._error_p ())
            {
              seq_.push_back (s);
            }
          }

          if (parser_._error_p ())
            _copy_error (&parser_);
        }
      }
    }
  }
}

#include <xsde/cxx/post.hxx>
