// file      : xsde/xsde.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSDE_HXX
#define XSDE_HXX

#include <xsd-frontend/semantic-graph/elements.hxx> // Path

#include <cult/types.hxx>
#include <cult/containers/vector.hxx>

#include <cstdio> // std::remove

using namespace Cult::Types;

//
//
struct AutoUnlink
{
  AutoUnlink (XSDFrontend::SemanticGraph::Path const& file)
      : file_ (file), canceled_ (false)
  {
  }

  ~AutoUnlink ()
  {
    if (!canceled_)
    {
      std::remove (file_.native_file_string ().c_str ());
    }
  }

  void
  cancel ()
  {
    canceled_ = true;
  }

private:
  XSDFrontend::SemanticGraph::Path file_;
  Boolean canceled_;
};

//
//
struct AutoUnlinks
{
  Void
  add (XSDFrontend::SemanticGraph::Path const& file)
  {
    unlinks_.push_back (Evptr<AutoUnlink> (new AutoUnlink (file)));
  }

  Void
  cancel ()
  {
    for (Unlinks::Iterator i (unlinks_.begin ()); i != unlinks_.end (); ++i)
    {
      (*i)->cancel ();
    }
  }

private:
  typedef Cult::Containers::Vector<Evptr<AutoUnlink> > Unlinks;
  Unlinks unlinks_;
};

#endif // XSDE_HXX
