/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef AUDIODIALOG_H
#define AUDIODIALOG_H

#include "AudioDialogData.h"
#include "AudioConfig.h"

class AudioDialog : public AudioDialogData
{
    Q_OBJECT

 public:

    AudioDialog(QWidget* parent=0, const char* name=0);
    
    void setConfig(const AudioConfig&);
    const AudioConfig& getConfig() const;
    void setButtons();

 protected:

    AudioConfig config;

 protected slots:
    
    void setPrecision(int);
    void setChannels(int);
    void setFrequency(int);
    void setBitsPerSample(int p)  { setPrecision(p); }  // old name

 signals:

    void changed(const AudioConfig&);
};

#endif  /* AUDIODIALOG_H */
