#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "xtux.h"
#include "client.h"
#include "win.h"
#include "input.h"
#include "image.h" /* For screenshot() */
#include "draw.h"
#include "cl_net.h"
#include "cl_netmsg_send.h"

extern win_t win;
extern client_t client;

char textentry_input_buffer[TEXTMESSAGE_STRLEN];
static int textentry_pos = 0;

/* What key does what, DEFAULT settings */
int key_config[NUM_KEYS] = {
    XK_Left,
    XK_Right,
    XK_Up,
    XK_Down,
    XK_z,
    XK_x,
    XK_space,
    XK_Control_R,
    XK_Control_L,
    XK_Alt_L,
    XK_Shift_L,
    XK_F12,
    XK_F1,
    XK_minus,
    XK_equal,
    XK_Return,
    XK_F5,
    XK_Tab
};

static byte keypress = 0; /* Keys pressed at any one time. */
static int turning = 0;

void textentry_key_handle(int key, int action);
void normal_key_handle(int key, int action);

byte get_input(void)
{
    XEvent event;
    int key;
    int action;

    while( XPending(win.d) ) {
	XNextEvent(win.d, &event); /* set event to next event in queue */

	/* Windows may have been drawn over, so update it */
	if( event.type == GraphicsExpose || event.type == Expose ) {
	    win.dirty = 1;
	    continue;
	}
	
	if( event.type == KeyPress )
	    action = PRESSED;
	else if( event.type == KeyRelease )
	    action = RELEASED;
	else { /* Shouldn't happen, as we've masked out what we don't want */
	    fprintf(stderr, "Unknown event recieved. Type %d\n", event.type);
	    continue;
	}

	if( action ) {
	    key = XLookupKeysym(&event.xkey, 0);
	    /* Go to menu if esc is pressed regardless of mode */
	    if( key == XK_Escape ) {
		client.state = MENU;
		break; /* Back to main */
	    } else if( key == key_config[K_SNIPER] )
		client.sniper_mode = (action > 0);
	    else if( key == key_config[K_SCREENSHOT] && action == PRESSED )
		screenshot();
	    else if( key == key_config[K_NS_TOGGLE] && action == PRESSED ) {
		if( ++client.netstats >= NUM_NETSTATS )
		    client.netstats = 0;
	    } else if( key == key_config[K_RAD_DEC] && action == PRESSED )
		client.crosshair_radius -= 5;
	    else if( key == key_config[K_RAD_INC] && action == PRESSED )
		client.crosshair_radius += 5;
	    else if( key == key_config[K_TEXTENTRY] && action == PRESSED ) {
		if( client.textentry ) {
		    cl_netmsg_send_textmessage(textentry_input_buffer);
		    draw_status_bar(); /* Put status bar back */
		} else { /* Start message */
		    memset(textentry_input_buffer, 0, textentry_pos);
		    textentry_pos = 0;
		    draw_textentry();
		}
		client.textentry = !client.textentry; /* Toggle */
		win.dirty = 1;
	    } else if( key == key_config[K_SUICIDE] && action == PRESSED ) {
		cl_netmsg_send_killme();
	    } else if( key == key_config[K_FRAGS] && action == PRESSED ) {
		cl_netmsg_send_query_frags();
	    } else { /* Game specific input */
		if( client.textentry ) { /* Text entry in status bar */
		    XPutBackEvent(win.d, &event);
		    textentry_key_handle(key, action);
		} else { /* Normal game input */
		    normal_key_handle(key, action);
		}
	    }

	}

    } /* Pending events */

    if( client.movement_mode == NORMAL && turning )
	client.dir += turning * (client.sniper_mode? 2 : client.turn_rate);

    return keypress;

}


void input_clear(void)
{
    XEvent e;

    while( XPending(win.d) )
	XNextEvent(win.d, &e);

}

int get_key(void)
{
    XEvent event;
    int key, pressed;
    static int shift = 0;

    while( XPending(win.d) ) {
	XNextEvent(win.d, &event);
	if( event.type == GraphicsExpose || event.type == Expose ) {
	    win.dirty = 1;
	    continue;
	}

	if( event.type == KeyPress )
	    pressed = 1;
	else if( event.type == KeyRelease )
	    pressed = 0;
	else
	    continue; /* Not a keypress or a release */

	key = XLookupKeysym(&event.xkey, 0);
	if( key == XK_Shift_L || key == XK_Shift_R ) {
	    shift = pressed;
	    continue;
	}

	if( pressed ) {
	    if( shift && isalpha(key) )
		return toupper(key);
	    else
		return key;
	} else
	    continue; /* Don't return key releases */

    }
    
    return XK_VoidSymbol;

}


void textentry_key_handle(int key, int action)
{

    while( (key = get_key()) != XK_VoidSymbol ) {
	if( key == XK_BackSpace || key == XK_Delete ) {
	    if( textentry_pos > 0 ) {
		textentry_input_buffer[--textentry_pos] = '\0';
	    }
	} else if( textentry_pos < TEXTMESSAGE_STRLEN ) {
	    textentry_input_buffer[textentry_pos++] = key;	    
	}
    }
    
    draw_textentry();    
    win.dirty = 1;

}


void normal_key_handle(int key, int action)
{
    int i, bit;


    if( client.movement_mode == NORMAL ) {
	if( key == key_config[K_ACLOCKWISE] ) {
	    if( action == PRESSED )
		turning = -1;
	    else
		turning = 0;
	} else if( key == key_config[K_CLOCKWISE] ) {
	    if( action == PRESSED )
		turning = 1;
	    else
		turning = 0;
	}
    } else {
	/* Make the turn left/right keys act like move left/right */
	if( key == key_config[K_ACLOCKWISE] )
	    key = key_config[K_LEFT];
	else if( key == key_config[K_CLOCKWISE] )
	    key = key_config[K_RIGHT];
    }

    /* The keys that map to the keypress bit mask that is sent to the server */
    for( i=K_FORWARD ; i <= K_B4 ; i++ ) {
	bit = 1<<(i-K_FORWARD);
	if( key == key_config[i] ) {
	    if( action == PRESSED )
		keypress |= bit;
	    else
		keypress &= ~bit;
	}
    }


}
