/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(SIGCXX_DISPATCH_H)
#define SIGCXX_DISPATCH_H

#include <gdk/gdk.h>

#include <list>

#include <sigc++/dispatch.h>

namespace SigC
{

class GtkDispatcher : public Dispatcher
{
    struct FileEvent {
        GtkDispatcher *disp;
        gint tag;
	Handler *cb;
	Event ev;

	FileEvent () {}
	FileEvent (GtkDispatcher *_disp, gint _tag, 
		   Handler *_cb, Event _ev)
	    : disp (_disp), tag (_tag), cb (_cb), ev (_ev)
          {}
    };
    struct TimerEvent {
        GtkDispatcher *disp;
        gint tag;
	Handler *cb;

	TimerEvent () {}
	TimerEvent (GtkDispatcher *_disp, gint _tag, 
		    Handler *_cb)
	    : disp (_disp), tag (_tag), cb (_cb)
          {}
    };
    list<FileEvent *> fevents;
    list<TimerEvent *> tevents;

    static void input_callback (gpointer, gint, GdkInputCondition);
    static gint timer_callback (gpointer);
  public:
    GtkDispatcher();
    virtual ~GtkDispatcher();

    virtual void add_input_handler(Handler *, int fd);
    virtual void add_output_handler(Handler *, int fd);
    virtual void add_exception_handler(Handler *, int fd);
    virtual void add_timeout_handler(Handler *,
                                     unsigned long tmout);
    virtual void remove(Handler *, Event);
    virtual void run(bool infinite = true);
    virtual void move(Dispatcher *);
    virtual bool idle() const;
    virtual void exit();
};

}

#endif
