/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_UCXX_SIGSLOT_H)
#define __INC_UCXX_SIGSLOT_H

#include <cstring>

#include <vector>
#include <string>
#include <stdexcept>

#include <sigc++/signal_system.h>

#include <uc++/any.h>

namespace uC
{

typedef std::vector<Any> ParamList;

class Signal : public SigC::Signal1<Any, const ParamList&>,
               public SigC::Object
{
  public:
    typedef SigC::Signal1<Any, const ParamList&> Base;
    typedef SigC::Slot1<Any, const ParamList&> Slot;
    
    Signal(const Slot& s = Slot()) : slot_(s) { }
    
    // shadows underlying SigC method - invokes wrapped slot,
    // which in turn should be connected somehow invoke us via real_emit
    Any emit(const ParamList& args);

    // This merely exists because SigC::Signal1 is no SigC::Object
    Any real_emit(const ParamList& args) {
      return(Base::emit(args));
    }
  private:
    Slot slot_;
};

}

#endif
