/* Generate check macros for tree codes.

   Copyright (C) 1998, 1999, 2000 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to the
   Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/
#include <stdio.h>

#define DEFTREECODE(SYM, NAME)   #SYM,

const char *tree_codes[] = {
#include "tree.def"
(char*)0
};

static void usage ()
{
  fprintf(stderr, "Usage: gencheck\n");
}

int main(int argc, char *argv[])
{
  int i;

  switch (argc)
  {
    case 1:
      break;

    default:
      usage ();
      return (1);
  }

  printf ("/* This file is generated using gencheck. Do not edit. */\n");
  for (i = 0; tree_codes[i]; i++)
  {
    printf ("#define %s_CHECK(t)\tTREE_CHECK (t, %s)\n",
            tree_codes[i], tree_codes[i]);
  }
  
  return 0;
}
