/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SCaret_h
#define SCaret_h

#include "swidget/SComponent.h"
#include "stoolkit/SEvent.h"

/**
 * A caret that redraws itself differently for lr and rl text 
 */
class SCaret : public SComponent, public SEventTarget
{
public:
  SCaret (void);
  virtual ~SCaret ();

  virtual void redraw (SCanvas* canvas, int x, int y, 
       unsigned int width, unsigned int height);
  void redraw (SCanvas* canvas);

  void setDirection (char lr);
  char getDirection() const;

  void setGlyphIndex (unsigned int position);
  unsigned int  getGlyphIndex () const;

  virtual void setBackground (const SColor& bg);
  void setForeground (const SColor& lrfg, const SColor& rlfg);

  void redraw ();
  void on (bool ison=true);
  bool isOn () const;
  void animate (bool _animate);
  bool isAnimating() const;

  STimer*  timer;
  bool timeout (const SEventSource* s);

  virtual void resize (const SDimension& size);
  virtual void move (const SLocation& loc);

protected:
  bool    isSaneSize();
  SPen    lrpen;
  SPen    rlpen;
  bool    showCaret;
  bool    skipBlink;
  bool    state;
  char    lr;
};

#endif /* SCaret_h */
