/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 

#include "stoolkit/SBinHashtable.h"
#include "stoolkit/SString.h"
#include "stoolkit/SStringVector.h"

#include <stdio.h>

typedef SBinHashtable<int> Counter;

void printArray (const SString &title, const Counter& c, int all);
int countWords (FILE* in, Counter& c);

/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 */
main ()
{
 //SObject::debug(1);
 //SShared::debug(1);
 fprintf (stderr, "Word Counter by Gaspar Sinai. Expect input on stdin.\n");
 Counter c;
 int all = countWords (stdin, c);
 printArray ("Counter Results", c, all);
 return 0;
}

int
countWords(FILE* file, Counter& c)
{
  char line[1024];
  line[sizeof (line)-1] = 0;
  int ret = 0;
  while (fgets (line, sizeof (line)-1, file))
  {
    SStringVector list(line, "=()*&^%$#@!\"'{}[]:;,.<>~`\\|\t \n/0123456789");
    //SStringVector list(line, " ");
    for (unsigned int i=0; i<list.size(); i++)
    {
      int cnt = c.get(list[i]);
      c.put (list[i], ++cnt);
      ret++;
    }
  }
  return ret;
}

typedef SBinVector<int> SortedInt;
typedef SVector<SString> KeyArray;
void
printArray (const SString &title, const Counter& c, int all)
{
 int count = 0;
 SortedInt arr;
 KeyArray  karr;
 for (unsigned int i=0; i<c.size(); i++)
 {
   for (unsigned int j=0; j<c.size (i); j++)
   {
     const SString key = c.key(i,j);
     int value = c[key];
     int pos = arr.appendSorted(value);
     karr.insert (pos, key);
     count++;
     //fprintf (stdout, "[%u][%u] [%*.*s] %d times\n", i, j, SSARGS(key), value);
   }
 }
 for (unsigned int k=0; k<karr.size(); k++)
 {
     SString key = karr[k];
     int value = c[key];

     fprintf (stdout, "%4d [%*.*s]\n", value, SSARGS(key));
     count++;
 }
 fprintf (stdout, "%*.*s %u buckets %d elements. %d words in all.\n", SSARGS(title), c.size(), count, all);
}
