/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.ServerDescriptor;
import IceGrid.ServerInstanceDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.Node;
import IceGridGUI.Application.PropertySet;
import IceGridGUI.Application.Server;
import IceGridGUI.Application.ServerInstanceEditor;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ServerInstance
extends TreeNode
implements Server {
    private ServerInstanceDescriptor _descriptor;
    private final boolean _ephemeral;
    private boolean _isIceBox;
    private ServerInstanceEditor _editor;
    private Utils.Resolver _resolver;
    private Editable _editable;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _serverIcon;
    private static Icon _iceboxServerIcon;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ServerInstanceDescriptor copyDescriptor(ServerInstanceDescriptor sid) {
        ServerInstanceDescriptor copy = (ServerInstanceDescriptor)sid.clone();
        copy.propertySet = PropertySet.copyDescriptor(copy.propertySet);
        return copy;
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = true;
        Object clipboard = this.getCoordinator().getClipboard();
        if (clipboard != null && (clipboard instanceof ServerDescriptor || clipboard instanceof ServerInstanceDescriptor)) {
            actions[14] = true;
        }
        actions[15] = true;
        if (!this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
        }
        return actions;
    }

    public void copy() {
        this.getCoordinator().setClipboard(ServerInstance.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ServerInstanceEditor)this.getRoot().getEditor(ServerInstanceEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new ServerInstanceEditor();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _serverIcon = Utils.getIcon("/icons/16x16/server_inactive.png");
            _iceboxServerIcon = Utils.getIcon("/icons/16x16/icebox_server_inactive.png");
        }
        _cellRenderer.setLeafIcon(this._isIceBox ? _iceboxServerIcon : _serverIcon);
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public void destroy() {
        Node node = (Node)this._parent;
        if (this._ephemeral) {
            node.removeServer(this);
        } else {
            node.removeDescriptor(this._descriptor);
            node.removeServer(this);
            node.getEditable().removeElement(this._id, this._editable, Server.class);
            this.getRoot().updated();
        }
    }

    public Object getDescriptor() {
        return this._descriptor;
    }

    public Object saveDescriptor() {
        return this._descriptor.clone();
    }

    public void restoreDescriptor(Object savedDescriptor) {
        ServerInstanceDescriptor copy = (ServerInstanceDescriptor)savedDescriptor;
        this._descriptor.template = copy.template;
        this._descriptor.parameterValues = copy.parameterValues;
        this._descriptor.propertySet = copy.propertySet;
    }

    ServerInstance(boolean brandNew, TreeNode parent, String serverId, Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor, boolean isIceBox) throws UpdateFailedException {
        super(parent, serverId);
        this._ephemeral = false;
        this._editable = new Editable(brandNew);
        this.rebuild(resolver, instanceDescriptor, isIceBox);
    }

    ServerInstance(TreeNode parent, String serverId, ServerInstanceDescriptor instanceDescriptor) {
        super(parent, serverId);
        this._ephemeral = true;
        this._editable = null;
        this.rebuild(null, instanceDescriptor, false);
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            TemplateDescriptor templateDescriptor = this.getRoot().findServerTemplateDescriptor(this._descriptor.template);
            LinkedList attributes = ServerInstance.parameterValuesToAttributes(this._descriptor.parameterValues, templateDescriptor.parameters);
            attributes.addFirst(ServerInstance.createAttribute("template", this._descriptor.template));
            if (this._descriptor.propertySet.references.length == 0 && this._descriptor.propertySet.properties.size() == 0) {
                writer.writeElement("server-instance", attributes);
            } else {
                writer.writeStartTag("server-instance", attributes);
                ServerInstance.writePropertySet(writer, "", this._descriptor.propertySet, null);
                writer.writeEndTag("server-instance");
            }
        }
    }

    void isIceBox(boolean newValue) {
        this._isIceBox = newValue;
    }

    public Object rebuild(List editables) throws UpdateFailedException {
        ServerInstance newServer;
        Backup backup = new Backup(((Node)this._parent).getEditable().save());
        Node node = (Node)this._parent;
        TemplateDescriptor templateDescriptor = this.getRoot().findServerTemplateDescriptor(this._descriptor.template);
        HashSet parameters = new HashSet(templateDescriptor.parameters);
        if (!((Object)parameters).equals(this._descriptor.parameterValues.keySet())) {
            backup.parameterValues = this._descriptor.parameterValues;
            this._descriptor.parameterValues = Editor.makeParameterValues(this._descriptor.parameterValues, templateDescriptor.parameters);
        }
        if (this._id.equals((newServer = node.createServer(false, this._descriptor)).getId())) {
            block9: {
                if (this._editable.isModified()) {
                    newServer.getEditable().markModified();
                }
                node.removeServer(this);
                try {
                    node.insertServer(newServer, true);
                }
                catch (UpdateFailedException e) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
            if (backup.parameterValues != null) {
                editables.add(newServer.getEditable());
            }
        } else {
            newServer.getEditable().markNew();
            node.removeServer(this);
            node.getEditable().removeElement(this._id, this._editable, Server.class);
            try {
                node.insertServer(newServer, true);
            }
            catch (UpdateFailedException e) {
                this.restore(backup);
                throw e;
            }
        }
        return backup;
    }

    public void restore(Object backupObj) {
        block4: {
            TreeNode badServer;
            Backup backup = (Backup)backupObj;
            Node node = (Node)this._parent;
            node.getEditable().restore(backup.nodeEditable);
            if (backup.parameterValues != null) {
                this._descriptor.parameterValues = backup.parameterValues;
            }
            if ((badServer = node.findChildWithDescriptor(this._descriptor)) != null) {
                node.removeServer(badServer);
            }
            try {
                node.insertServer(this, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    void rebuild(Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor, boolean isIceBox) {
        this._resolver = resolver;
        this._isIceBox = isIceBox;
        this._descriptor = instanceDescriptor;
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    public Editable getEditable() {
        return this._editable;
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    public String toString() {
        if (this._ephemeral) {
            return super.toString();
        }
        return this._id + ": " + this._descriptor.template + "<>";
    }

    static {
        $assertionsDisabled = !ServerInstance.class.desiredAssertionStatus();
    }

    private static class Backup {
        Editable nodeEditable;
        Map parameterValues;

        Backup(Editable ne) {
            this.nodeEditable = ne;
        }
    }
}

