/*
 * Decompiled with CFR 0.152.
 */
package IceBox;

import Ice.Application;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.Current;
import Ice.Identity;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.Logger;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.Properties;
import Ice.Util;
import IceBox.FailureException;
import IceBox.Service;
import IceBox.SliceChecksums;
import IceBox._ServiceManagerDisp;
import IceUtil.Options;
import IceUtil.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ServiceManagerI
extends _ServiceManagerDisp {
    private Application _server;
    private Logger _logger;
    private String[] _argv;
    private HashMap _services = new HashMap();

    public ServiceManagerI(Application server, String[] args) {
        this._server = server;
        ServiceManagerI serviceManagerI = this;
        this._logger = serviceManagerI._server.communicator().getLogger();
        this._argv = args;
    }

    public Map getSliceChecksums(Current current) {
        return SliceChecksums.checksums;
    }

    public void shutdown(Current current) {
        ServiceManagerI serviceManagerI = this;
        serviceManagerI._server.communicator().shutdown();
    }

    public int run() {
        try {
            ServiceManagerI serviceManagerI = this;
            ObjectAdapter adapter = serviceManagerI._server.communicator().createObjectAdapter("IceBox.ServiceManager");
            ServiceManagerI serviceManagerI2 = this;
            Properties properties = serviceManagerI2._server.communicator().getProperties();
            Identity managerIdentity = new Identity();
            String identity = properties.getProperty("IceBox.ServiceManager.Identity");
            if (identity.length() != 0) {
                ServiceManagerI serviceManagerI3 = this;
                managerIdentity = serviceManagerI3._server.communicator().stringToIdentity(identity);
            } else {
                managerIdentity.category = properties.getPropertyWithDefault("IceBox.InstanceName", "IceBox");
                managerIdentity.name = "ServiceManager";
            }
            adapter.add(this, managerIdentity);
            String order = properties.getProperty("IceBox.LoadOrder");
            String[] loadOrder = null;
            if (order.length() > 0) {
                loadOrder = order.trim().split("[,\t ]+");
            }
            String prefix = "IceBox.Service.";
            Map services = properties.getPropertiesForPrefix("IceBox.Service.");
            if (loadOrder != null) {
                for (int i = 0; i < loadOrder.length; ++i) {
                    if (loadOrder[i].length() <= 0) continue;
                    String key = "IceBox.Service." + loadOrder[i];
                    String value = (String)services.get(key);
                    if (value == null) {
                        FailureException ex = new FailureException();
                        ex.reason = "ServiceManager: no service definition for `" + loadOrder[i] + "'";
                        throw ex;
                    }
                    this.load(loadOrder[i], value);
                    services.remove(key);
                }
            }
            Iterator p = services.entrySet().iterator();
            while (p.hasNext()) {
                Map.Entry entry = p.next();
                String name = ((String)entry.getKey()).substring("IceBox.Service.".length());
                String value = (String)entry.getValue();
                this.load(name, value);
            }
            String bundleName = properties.getProperty("IceBox.PrintServicesReady");
            if (bundleName.length() > 0) {
                System.out.println(bundleName + " ready");
            }
            ServiceManagerI serviceManagerI4 = this;
            serviceManagerI4._server.shutdownOnInterrupt();
            try {
                adapter.activate();
            }
            catch (ObjectAdapterDeactivatedException ex) {
                // empty catch block
            }
            ServiceManagerI serviceManagerI5 = this;
            serviceManagerI5._server.communicator().waitForShutdown();
            ServiceManagerI serviceManagerI6 = this;
            serviceManagerI6._server.defaultInterrupt();
            this.stopAll();
        }
        catch (FailureException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(ex.reason);
            ex.printStackTrace(pw);
            pw.flush();
            this._logger.error(sw.toString());
            this.stopAll();
            return 1;
        }
        catch (LocalException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            this._logger.error("ServiceManager: " + ex + "\n" + sw.toString());
            this.stopAll();
            return 1;
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            this._logger.error("ServiceManager: unknown exception\n" + sw.toString());
            this.stopAll();
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private void load(String name, String value) throws FailureException {
        void var4_5;
        String[] args;
        String className;
        int pos = StringUtil.findFirstOf(value, " \t\n");
        if (pos == -1) {
            className = value;
            args = new String[]{};
        } else {
            className = value.substring(0, pos);
            try {
                args = Options.split(value.substring(pos));
            }
            catch (Options.BadQuote ex) {
                FailureException e = new FailureException();
                e.reason = "ServiceManager: invalid arguments for service `" + name + "':\n" + ex.toString();
                throw e;
            }
        }
        this.start(name, className, (String[])var4_5);
    }

    private void start(String service, String className, String[] args) throws FailureException {
        int j;
        ArrayList<String> l = new ArrayList<String>();
        for (j = 0; j < args.length; ++j) {
            l.add(args[j]);
        }
        for (j = 0; j < this._argv.length; ++j) {
            if (!this._argv[j].startsWith("--" + service + ".")) continue;
            l.add(this._argv[j]);
        }
        String[] serviceArgs = new String[l.size()];
        l.toArray(serviceArgs);
        ServiceInfo info = new ServiceInfo();
        try {
            Class<?> c = Class.forName(className);
            Object obj = c.newInstance();
            try {
                info.service = (Service)obj;
            }
            catch (ClassCastException ex) {
                FailureException e = new FailureException();
                e.reason = "ServiceManager: class " + className + " does not implement IceBox.Service";
                throw e;
            }
        }
        catch (ClassNotFoundException ex) {
            FailureException e = new FailureException();
            e.reason = "ServiceManager: class " + className + " not found";
            e.initCause(ex);
            throw e;
        }
        catch (IllegalAccessException ex) {
            FailureException e = new FailureException();
            e.reason = "ServiceManager: unable to access default constructor in class " + className;
            e.initCause(ex);
            throw e;
        }
        catch (InstantiationException ex) {
            FailureException e = new FailureException();
            e.reason = "ServiceManager: unable to instantiate class " + className;
            e.initCause(ex);
            throw e;
        }
        try {
            Communicator communicator;
            ServiceManagerI serviceManagerI = this;
            Properties properties = serviceManagerI._server.communicator().getProperties();
            if (properties.getPropertyAsInt("IceBox.UseSharedCommunicator." + service) > 0) {
                Properties fileProperties = Util.createProperties(serviceArgs);
                properties.parseCommandLineOptions("", fileProperties.getCommandLineOptions());
                serviceArgs = properties.parseIceCommandLineOptions(serviceArgs);
                serviceArgs = properties.parseCommandLineOptions(service, serviceArgs);
            } else {
                Properties serviceProperties = properties._clone();
                String name = serviceProperties.getProperty("Ice.ProgramName");
                if (!name.equals(service)) {
                    name = name.length() == 0 ? service : name + "-" + service;
                }
                Properties fileProperties = Util.createProperties(serviceArgs);
                serviceProperties.parseCommandLineOptions("", fileProperties.getCommandLineOptions());
                serviceProperties.setProperty("Ice.ProgramName", name);
                serviceArgs = serviceProperties.parseIceCommandLineOptions(serviceArgs);
                serviceArgs = serviceProperties.parseCommandLineOptions(service, serviceArgs);
                InitializationData initData = new InitializationData();
                initData.properties = serviceProperties;
                info.communicator = Util.initialize(serviceArgs, initData);
            }
            if (info.communicator != null) {
                communicator = info.communicator;
            } else {
                ServiceManagerI serviceManagerI2 = this;
                communicator = serviceManagerI2._server.communicator();
            }
            Communicator communicator2 = communicator;
            try {
                info.service.start(service, communicator2, serviceArgs);
            }
            catch (Throwable ex) {
                if (info.communicator != null) {
                    PrintWriter pw;
                    StringWriter sw;
                    try {
                        info.communicator.shutdown();
                        info.communicator.waitForShutdown();
                    }
                    catch (CommunicatorDestroyedException e) {
                    }
                    catch (Exception e) {
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        pw.flush();
                        this._logger.warning("ServiceManager: exception in shutting down communicator for service " + service + "\n" + sw.toString());
                    }
                    try {
                        info.communicator.destroy();
                    }
                    catch (Exception e) {
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        pw.flush();
                        this._logger.warning("ServiceManager: exception in destroying communciator for service" + service + "\n" + sw.toString());
                    }
                }
                throw ex;
            }
            this._services.put(service, info);
        }
        catch (FailureException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            FailureException e = new FailureException();
            e.reason = "ServiceManager: exception while starting service " + service + ": " + ex;
            e.initCause(ex);
            throw e;
        }
    }

    private void stopAll() {
        Iterator p = this._services.entrySet().iterator();
        while (p.hasNext()) {
            PrintWriter pw;
            StringWriter sw;
            Map.Entry entry = p.next();
            String name = (String)entry.getKey();
            ServiceInfo info = (ServiceInfo)entry.getValue();
            try {
                info.service.stop();
            }
            catch (Exception e) {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                this._logger.warning("ServiceManager: exception in stop for service " + name + "\n" + sw.toString());
            }
            if (info.communicator == null) continue;
            try {
                info.communicator.shutdown();
                info.communicator.waitForShutdown();
            }
            catch (CommunicatorDestroyedException e) {
            }
            catch (Exception e) {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                this._logger.warning("ServiceManager: exception in stop for service " + name + "\n" + sw.toString());
            }
            try {
                info.communicator.destroy();
            }
            catch (Exception e) {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                this._logger.warning("ServiceManager: exception in stop for service " + name + "\n" + sw.toString());
            }
        }
        this._services.clear();
    }

    class ServiceInfo {
        public Service service;
        public Communicator communicator = null;

        ServiceInfo() {
        }
    }
}

