/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Ice.Current;
import IceGrid.AdapterInfo;
import IceGrid._AdapterObserverDisp;
import IceGridGUI.Coordinator;
import javax.swing.SwingUtilities;

class AdapterObserverI
extends _AdapterObserverDisp {
    private final Coordinator _coordinator;
    private final boolean _trace;

    AdapterObserverI(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._trace = coordinator.traceObservers();
    }

    public synchronized void adapterInit(final AdapterInfo[] adapters, Current current) {
        if (this._trace) {
            if (adapters.length == 0) {
                this._coordinator.traceObserver("adapterInit (no adapter)");
            } else {
                String names = "";
                for (int i = 0; i < adapters.length; ++i) {
                    names = names + " " + adapters[i].id;
                }
                this._coordinator.traceObserver("adapterInit for adapters" + names);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AdapterObserverI.this._coordinator.adapterInit(adapters);
            }
        });
    }

    public void adapterAdded(final AdapterInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("adapterAdded for adapter " + info.id);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AdapterObserverI.this._coordinator.adapterAdded(info);
            }
        });
    }

    public void adapterUpdated(final AdapterInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("adapterUpdated for adapter " + info.id);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AdapterObserverI.this._coordinator.adapterUpdated(info);
            }
        });
    }

    public void adapterRemoved(final String id, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("adapterRemoved for adapter " + id);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AdapterObserverI.this._coordinator.adapterRemoved(id);
            }
        });
    }
}

