/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.AdapterDescriptor;
import IceGrid.CommunicatorDescriptor;
import IceGrid.DbEnvDescriptor;
import IceGrid.PropertyDescriptor;
import IceGrid.PropertySetDescriptor;
import IceGrid.ServiceDescriptor;
import IceGrid.ServiceInstanceDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.Adapter;
import IceGridGUI.Application.DbEnv;
import IceGridGUI.Application.DescriptorHolder;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.PlainServer;
import IceGridGUI.Application.PlainService;
import IceGridGUI.Application.Service;
import IceGridGUI.Application.ServiceInstance;
import IceGridGUI.Application.ServiceTemplate;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

abstract class Communicator
extends TreeNode
implements DescriptorHolder {
    protected Adapters _adapters = new Adapters();
    protected DbEnvs _dbEnvs = new DbEnvs();
    protected Services _services = new Services();
    protected ChildList[] _childListArray = new ChildList[]{this._adapters, this._dbEnvs, this._services};
    static /* synthetic */ Class class$IceGridGUI$Application$Communicator;

    public Enumeration children() {
        return new Enumeration(){
            private int _index = 0;
            private Iterator _p;
            {
                this._p = Communicator.this._childListArray[0].iterator();
            }

            public boolean hasMoreElements() {
                if (this._p.hasNext()) {
                    return true;
                }
                while (++this._index < Communicator.this._childListArray.length) {
                    this._p = Communicator.this._childListArray[this._index].iterator();
                    if (!this._p.hasNext()) continue;
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                try {
                    return this._p.next();
                }
                catch (NoSuchElementException nse) {
                    if (this.hasMoreElements()) {
                        return this._p.next();
                    }
                    throw nse;
                }
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public javax.swing.tree.TreeNode getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(childIndex);
        }
        int offset = 0;
        for (int i = 0; i < this._childListArray.length; ++i) {
            if (childIndex < offset + this._childListArray[i].size()) {
                return this._childListArray[i].get(childIndex - offset);
            }
            offset += this._childListArray[i].size();
        }
        throw new ArrayIndexOutOfBoundsException(childIndex);
    }

    public int getChildCount() {
        int result = 0;
        for (int i = 0; i < this._childListArray.length; ++i) {
            result += this._childListArray[i].size();
        }
        return result;
    }

    public int getIndex(javax.swing.tree.TreeNode node) {
        int offset = 0;
        for (int i = 0; i < this._childListArray.length; ++i) {
            int index = this._childListArray[i].indexOf(node);
            if (index == -1) {
                offset += this._childListArray[i].size();
                continue;
            }
            return offset + index;
        }
        return -1;
    }

    public boolean isLeaf() {
        for (int i = 0; i < this._childListArray.length; ++i) {
            if (this._childListArray[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void newAdapter() {
        this._adapters.newChild();
    }

    public void newDbEnv() {
        this._dbEnvs.newChild();
    }

    public void newService() {
        this._services.newChild();
    }

    public void newServiceFromTemplate() {
        this._services.newServiceFromTemplate();
    }

    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor instanceof Adapter.AdapterCopy) {
            Adapter.AdapterCopy copy = (Adapter.AdapterCopy)descriptor;
            this._adapters.newAdapter(Adapter.copyDescriptor(copy.descriptor), new HashMap(copy.parentProperties));
        } else if (descriptor instanceof DbEnvDescriptor) {
            DbEnvDescriptor d = (DbEnvDescriptor)descriptor;
            this._dbEnvs.newDbEnv(DbEnv.copyDescriptor(d));
        } else if (descriptor instanceof ServiceInstanceDescriptor && this._services.initialized()) {
            ServiceInstanceDescriptor d = (ServiceInstanceDescriptor)descriptor;
            this._services.newService(ServiceInstance.copyDescriptor(d));
        } else {
            ((TreeNode)this._parent).paste();
        }
    }

    abstract CommunicatorDescriptor getCommunicatorDescriptor();

    abstract Editable getEnclosingEditable();

    List findInstances() {
        LinkedList<Communicator> result = new LinkedList<Communicator>();
        result.add(this);
        return result;
    }

    TreeNode findChildLike(TreeNode other) {
        if (other instanceof Adapter) {
            return this._adapters.findChildById(other.getId());
        }
        if (other instanceof DbEnv) {
            return this._dbEnvs.findChildById(other.getId());
        }
        if (other instanceof Service) {
            return this._dbEnvs.findChildById(other.getId());
        }
        return null;
    }

    protected Communicator(TreeNode parent, String id) {
        super(parent, id);
    }

    Adapters getAdapters() {
        return this._adapters;
    }

    DbEnvs getDbEnvs() {
        return this._dbEnvs;
    }

    Services getServices() {
        return this._services;
    }

    List findServiceInstances(String template) {
        LinkedList<ServiceInstance> result = new LinkedList<ServiceInstance>();
        Iterator p = this._services.iterator();
        while (p.hasNext()) {
            Object obj = p.next();
            if (!(obj instanceof ServiceInstance)) continue;
            ServiceInstance service = (ServiceInstance)obj;
            ServiceInstanceDescriptor d = (ServiceInstanceDescriptor)service.getDescriptor();
            if (!d.template.equals(template)) continue;
            result.add(service);
        }
        return result;
    }

    void removeServiceInstances(String template) {
        Iterator p = this._services.iterator();
        while (p.hasNext()) {
            Object obj = p.next();
            if (!(obj instanceof ServiceInstance)) continue;
            ServiceInstance service = (ServiceInstance)obj;
            ServiceInstanceDescriptor d = (ServiceInstanceDescriptor)service.getDescriptor();
            if (!d.template.equals(template)) continue;
            p.remove();
            this._services.removeDescriptor(d);
            this.getEnclosingEditable().markModified();
        }
    }

    String getProperty(String key) {
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        Iterator p = descriptor.propertySet.properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            if (!pd.name.equals(key)) continue;
            return pd.value;
        }
        return null;
    }

    String lookupPropertyValue(String val) {
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        Iterator p = descriptor.propertySet.properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            if (!pd.value.equals(val)) continue;
            return pd.name;
        }
        return "";
    }

    void setProperty(String key, String newValue) {
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        this.removeProperty(key);
        ((LinkedList)descriptor.propertySet.properties).addFirst(new PropertyDescriptor(key, newValue));
    }

    void removeProperty(String key) {
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        Iterator p = descriptor.propertySet.properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            if (!pd.name.equals(key)) continue;
            p.remove();
        }
    }

    Map propertiesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        Iterator p = descriptor.propertySet.properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            result.put(pd.name, pd.value);
        }
        return result;
    }

    class Services
    extends ChildList {
        static final /* synthetic */ boolean $assertionsDisabled;

        Services() {
            super(false);
        }

        void newChild() {
            ServiceDescriptor serviceDescriptor = new ServiceDescriptor(new LinkedList(), new PropertySetDescriptor(new String[0], new LinkedList()), new LinkedList(), new String[0], "", "NewService", "");
            ServiceInstanceDescriptor descriptor = new ServiceInstanceDescriptor("", new HashMap(), serviceDescriptor, new PropertySetDescriptor(new String[0], new LinkedList()));
            this.newService(descriptor);
        }

        void newServiceFromTemplate() {
            ServiceInstanceDescriptor descriptor = new ServiceInstanceDescriptor("", new HashMap(), null, new PropertySetDescriptor(new String[0], new LinkedList()));
            this.newService(descriptor);
        }

        void move(TreeNode child, boolean up) {
            int index = Communicator.this.getIndex(child);
            int listIndex = this._children.indexOf(child);
            Object descriptor = child.getDescriptor();
            Communicator.this.getEnclosingEditable().markModified();
            Communicator.this.getRoot().updated();
            this._descriptors.remove(listIndex);
            if (up) {
                this._descriptors.add(listIndex - 1, descriptor);
            } else {
                this._descriptors.add(listIndex + 1, descriptor);
            }
            this._children.remove(listIndex);
            Communicator.this.getRoot().getTreeModel().nodesWereRemoved(Communicator.this, new int[]{index}, new Object[]{child});
            if (up) {
                this._children.add(listIndex - 1, child);
                Communicator.this.getRoot().getTreeModel().nodesWereInserted(Communicator.this, new int[]{index - 1});
            } else {
                this._children.add(listIndex + 1, child);
                Communicator.this.getRoot().getTreeModel().nodesWereInserted(Communicator.this, new int[]{index + 1});
            }
            Communicator.this.getRoot().setSelectedNode(child);
            Communicator.this.getCoordinator().showActions(child);
        }

        TreeNode createChild(Object o) throws UpdateFailedException {
            ServiceInstanceDescriptor descriptor = (ServiceInstanceDescriptor)o;
            if (descriptor.descriptor == null) {
                TemplateDescriptor templateDescriptor = Communicator.this.getRoot().findServiceTemplateDescriptor(descriptor.template);
                if (!$assertionsDisabled && templateDescriptor == null) {
                    throw new AssertionError();
                }
                String serviceName = null;
                String displayString = null;
                Utils.Resolver serviceResolver = null;
                if (Communicator.this instanceof PlainServer) {
                    serviceResolver = new Utils.Resolver(Communicator.this.getResolver(), descriptor.parameterValues, templateDescriptor.parameterDefaults);
                    ServiceDescriptor serviceDescriptor = (ServiceDescriptor)templateDescriptor.descriptor;
                    if (!$assertionsDisabled && serviceDescriptor == null) {
                        throw new AssertionError();
                    }
                    serviceName = serviceResolver.substitute(serviceDescriptor.name);
                    serviceResolver.put("service", serviceName);
                    displayString = serviceName + ": " + descriptor.template + "<>";
                } else {
                    serviceName = descriptor.template + "<>";
                }
                return new ServiceInstance(Communicator.this, serviceName, displayString, descriptor, serviceResolver);
            }
            ServiceDescriptor serviceDescriptor = descriptor.descriptor;
            String serviceName = null;
            Utils.Resolver serviceResolver = null;
            if (Communicator.this instanceof PlainServer) {
                serviceResolver = new Utils.Resolver(Communicator.this.getResolver());
                serviceName = serviceResolver.substitute(serviceDescriptor.name);
                serviceResolver.put("service", serviceName);
            } else {
                serviceName = serviceDescriptor.name;
            }
            return new PlainService(Communicator.this, serviceName, descriptor, serviceResolver);
        }

        void tryUpdate(TreeNode child) throws UpdateFailedException {
            Object descriptor = child.getDescriptor();
            int listIndex = this._children.indexOf(child);
            if (!$assertionsDisabled && listIndex == -1) {
                throw new AssertionError();
            }
            TreeNode newChild = this.createChild(descriptor);
            this._children.set(listIndex, newChild);
            Communicator.this.getRoot().getTreeModel().nodeChanged(newChild);
            Communicator.this.getEnclosingEditable().markModified();
        }

        private void newService(ServiceInstanceDescriptor descriptor) {
            if (descriptor.descriptor == null) {
                ServiceInstance service;
                block8: {
                    String name = this.makeNewChildId("NewService");
                    ServiceTemplate t = Communicator.this.getRoot().findServiceTemplate(descriptor.template);
                    if (t == null) {
                        if (Communicator.this.getRoot().getServiceTemplates().getChildCount() == 0) {
                            JOptionPane.showMessageDialog(Communicator.this.getCoordinator().getMainFrame(), "You need to create a service template before you can create a service from a template.", "No Service Template", 1);
                            return;
                        }
                        t = (ServiceTemplate)Communicator.this.getRoot().getServiceTemplates().getChildAt(0);
                        descriptor.template = t.getId();
                        descriptor.parameterValues = new HashMap();
                    }
                    TemplateDescriptor td = (TemplateDescriptor)t.getDescriptor();
                    descriptor.parameterValues = Editor.makeParameterValues(descriptor.parameterValues, td.parameters);
                    service = new ServiceInstance(Communicator.this, name, descriptor);
                    try {
                        this.addChild(service, true);
                    }
                    catch (UpdateFailedException e) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                Communicator.this.getRoot().setSelectedNode(service);
            } else {
                PlainService service;
                block9: {
                    descriptor.descriptor.name = this.makeNewChildId(descriptor.descriptor.name);
                    service = new PlainService(Communicator.this, descriptor);
                    try {
                        this.addChild(service, true);
                    }
                    catch (UpdateFailedException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
                Communicator.this.getRoot().setSelectedNode(service);
            }
        }

        static {
            $assertionsDisabled = !(class$IceGridGUI$Application$Communicator == null ? (class$IceGridGUI$Application$Communicator = Communicator.class$("IceGridGUI.Application.Communicator")) : class$IceGridGUI$Application$Communicator).desiredAssertionStatus();
        }
    }

    class DbEnvs
    extends ChildList {
        static final /* synthetic */ boolean $assertionsDisabled;

        DbEnvs() {
            super(true);
        }

        void newChild() {
            DbEnvDescriptor descriptor = new DbEnvDescriptor("NewDbEnv", "", "", new LinkedList());
            this.newDbEnv(descriptor);
        }

        TreeNode createChild(Object descriptor) {
            DbEnvDescriptor dd = (DbEnvDescriptor)descriptor;
            String name = Utils.substitute(dd.name, Communicator.this.getResolver());
            return new DbEnv(Communicator.this, name, dd, false);
        }

        private void newDbEnv(DbEnvDescriptor descriptor) {
            DbEnv dbEnv;
            block2: {
                descriptor.name = this.makeNewChildId(descriptor.name);
                dbEnv = new DbEnv(Communicator.this, descriptor.name, descriptor, true);
                try {
                    this.addChild(dbEnv, true);
                }
                catch (UpdateFailedException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
            Communicator.this.getRoot().setSelectedNode(dbEnv);
        }

        static {
            $assertionsDisabled = !(class$IceGridGUI$Application$Communicator == null ? (class$IceGridGUI$Application$Communicator = Communicator.class$("IceGridGUI.Application.Communicator")) : class$IceGridGUI$Application$Communicator).desiredAssertionStatus();
        }
    }

    class Adapters
    extends ChildList {
        static final /* synthetic */ boolean $assertionsDisabled;

        Adapters() {
            super(true);
        }

        void write(XMLWriter writer, List props) throws IOException {
            Iterator p = this._children.iterator();
            while (p.hasNext()) {
                Adapter child = (Adapter)p.next();
                child.write(writer, props);
            }
        }

        void newChild() {
            AdapterDescriptor descriptor = new AdapterDescriptor("NewAdapter", "", null, "", "", false, true, new LinkedList(), new LinkedList());
            this.newAdapter(descriptor, null);
        }

        TreeNode createChild(Object descriptor) {
            AdapterDescriptor ad = (AdapterDescriptor)descriptor;
            String name = Utils.substitute(ad.name, Communicator.this.getResolver());
            return new Adapter(Communicator.this, name, ad, null, false);
        }

        private void newAdapter(AdapterDescriptor descriptor, Map parentProperties) {
            Adapter adapter;
            block5: {
                String newName = this.makeNewChildId(descriptor.name);
                if (!newName.equals(descriptor.name) && parentProperties != null) {
                    String key = descriptor.name + ".Endpoints";
                    String val = (String)parentProperties.remove(key);
                    if (val != null) {
                        parentProperties.put(newName + ".Endpoints", val);
                    }
                    if ((val = (String)parentProperties.remove(key = descriptor.name + ".PublishedEndpoints")) != null) {
                        parentProperties.put(newName + ".PublishedEndpoints", val);
                    }
                }
                descriptor.name = newName;
                adapter = new Adapter(Communicator.this, descriptor.name, descriptor, parentProperties, true);
                try {
                    this.addChild(adapter, true);
                }
                catch (UpdateFailedException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            Communicator.this.getRoot().setSelectedNode(adapter);
        }

        static {
            $assertionsDisabled = !(class$IceGridGUI$Application$Communicator == null ? (class$IceGridGUI$Application$Communicator = Communicator.class$("IceGridGUI.Application.Communicator")) : class$IceGridGUI$Application$Communicator).desiredAssertionStatus();
        }
    }

    abstract class ChildList {
        protected List _children = new LinkedList();
        protected List _descriptors;
        protected boolean _sorted;
        static final /* synthetic */ boolean $assertionsDisabled;

        abstract TreeNode createChild(Object var1) throws UpdateFailedException;

        protected ChildList(boolean sorted) {
            this._sorted = sorted;
        }

        void write(XMLWriter writer) throws IOException {
            Iterator p = this._children.iterator();
            while (p.hasNext()) {
                TreeNode child = (TreeNode)p.next();
                child.write(writer);
            }
        }

        Iterator iterator() {
            return this._children.iterator();
        }

        TreeNode get(int index) {
            return (TreeNode)this._children.get(index);
        }

        int indexOf(Object obj) {
            return this._children.indexOf(obj);
        }

        int size() {
            return this._children.size();
        }

        boolean isEmpty() {
            return this._children.isEmpty();
        }

        void init(List descriptors) throws UpdateFailedException {
            if (!$assertionsDisabled && this._descriptors != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this._children.isEmpty()) {
                throw new AssertionError();
            }
            this._descriptors = descriptors;
            Iterator p = this._descriptors.iterator();
            while (p.hasNext()) {
                Object descriptor = p.next();
                TreeNode child = this.createChild(descriptor);
                this.addChild(child, false);
            }
        }

        boolean initialized() {
            return this._descriptors != null;
        }

        void clear() {
            this._descriptors = null;
            this._children.clear();
        }

        TreeNode addNewChild(Object descriptor) throws UpdateFailedException {
            TreeNode child = this.createChild(descriptor);
            this.addChild(child, true);
            return child;
        }

        TreeNode findChildWithDescriptor(Object descriptor) {
            Iterator p = this._children.iterator();
            while (p.hasNext()) {
                TreeNode child = (TreeNode)p.next();
                if (child.getDescriptor() != descriptor) continue;
                return child;
            }
            return null;
        }

        TreeNode findChildById(String id) {
            Iterator p = this._children.iterator();
            while (p.hasNext()) {
                TreeNode child = (TreeNode)p.next();
                if (!child.getId().equals(id)) continue;
                return child;
            }
            return null;
        }

        void addChild(TreeNode child, boolean fireEvent) throws UpdateFailedException {
            if (this._sorted) {
                DefaultTreeModel treeModel;
                DefaultTreeModel defaultTreeModel = treeModel = fireEvent ? Communicator.this.getRoot().getTreeModel() : null;
                if (!Communicator.this.insertSortedChild(child, this._children, treeModel)) {
                    throw new UpdateFailedException(Communicator.this, child.getId());
                }
            } else {
                this._children.add(child);
                if (fireEvent) {
                    Communicator.this.getRoot().getTreeModel().nodesWereInserted(Communicator.this, new int[]{Communicator.this.getIndex(child)});
                }
            }
        }

        int removeChild(TreeNode child) {
            int index = Communicator.this.getIndex(child);
            this._children.remove(child);
            Communicator.this.getRoot().getTreeModel().nodesWereRemoved(Communicator.this, new int[]{index}, new Object[]{child});
            return index;
        }

        void destroyChild(TreeNode child) {
            if (child.isEphemeral()) {
                this.removeChild(child);
            } else {
                Object descriptor = child.getDescriptor();
                this.removeDescriptor(descriptor);
                Communicator.this.getEnclosingEditable().markModified();
                Communicator.this.getRoot().updated();
                this.removeChild(child);
            }
        }

        void addDescriptor(Object descriptor) {
            this._descriptors.add(descriptor);
        }

        void removeDescriptor(Object descriptor) {
            Iterator p = this._descriptors.iterator();
            while (p.hasNext()) {
                if (descriptor != p.next()) continue;
                p.remove();
                break;
            }
        }

        boolean canMove(TreeNode child, boolean up) {
            int i = this._children.indexOf(child);
            if (!$assertionsDisabled && i == -1) {
                throw new AssertionError();
            }
            return up && i > 0 || !up && i < this._children.size() - 1;
        }

        void tryAdd(Object descriptor) throws UpdateFailedException {
            this.addDescriptor(descriptor);
            try {
                this.addNewChild(descriptor);
            }
            catch (UpdateFailedException e) {
                this.removeDescriptor(descriptor);
                throw e;
            }
            Communicator.this.getEnclosingEditable().markModified();
        }

        void tryUpdate(TreeNode child) throws UpdateFailedException {
            if (!$assertionsDisabled && !this._sorted) {
                throw new AssertionError();
            }
            Object descriptor = child.getDescriptor();
            this.removeChild(child);
            try {
                this.addNewChild(descriptor);
            }
            catch (UpdateFailedException e) {
                this.addChild(child, true);
                throw e;
            }
            Communicator.this.getEnclosingEditable().markModified();
        }

        protected String makeNewChildId(String base) {
            String id = base;
            int i = 0;
            while (this.findChildById(id) != null) {
                id = base + "-" + ++i;
            }
            return id;
        }

        static {
            $assertionsDisabled = !(class$IceGridGUI$Application$Communicator == null ? (class$IceGridGUI$Application$Communicator = Communicator.class$("IceGridGUI.Application.Communicator")) : class$IceGridGUI$Application$Communicator).desiredAssertionStatus();
        }
    }
}

