/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Glacier2.CannotCreateSessionException;
import Glacier2.RouterPrxHelper;
import Glacier2.SessionNotExistException;
import Glacier2.SessionPrx;
import Ice.Communicator;
import Ice.Identity;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.LongHolder;
import Ice.ObjectNotExistException;
import Ice.Properties;
import Ice.RouterPrx;
import Ice.StringSeqHolder;
import Ice.UserException;
import Ice.Util;
import IceGrid.AMI_Admin_removeApplication;
import IceGrid.AccessDeniedException;
import IceGrid.AdapterDynamicInfo;
import IceGrid.AdapterInfo;
import IceGrid.AdminPrx;
import IceGrid.AdminSessionPrx;
import IceGrid.AdminSessionPrxHelper;
import IceGrid.ApplicationDescriptor;
import IceGrid.ApplicationInfo;
import IceGrid.ApplicationUpdateInfo;
import IceGrid.DeploymentException;
import IceGrid.DistributionDescriptor;
import IceGrid.FileParserPrx;
import IceGrid.FileParserPrxHelper;
import IceGrid.LocatorPrx;
import IceGrid.LocatorPrxHelper;
import IceGrid.NodeDynamicInfo;
import IceGrid.ObjectInfo;
import IceGrid.ParseException;
import IceGrid.PermissionDeniedException;
import IceGrid.RegistryInfo;
import IceGrid.RegistryPrx;
import IceGrid.RegistryPrxHelper;
import IceGrid.ServerDynamicInfo;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.ApplicationPane;
import IceGridGUI.BareBonesBrowserLaunch;
import IceGridGUI.Coordinator;
import IceGridGUI.LiveActions;
import IceGridGUI.LiveDeployment.TreeNode;
import IceGridGUI.LiveDeploymentPane;
import IceGridGUI.Logger;
import IceGridGUI.MainPane;
import IceGridGUI.SessionKeeper;
import IceGridGUI.StatusBar;
import IceGridGUI.Tab;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;

public class Coordinator {
    private final InitializationData _initData;
    private Communicator _communicator;
    private boolean _traceObservers;
    private boolean _traceSaveToRegistry;
    private Preferences _prefs;
    private StatusBarI _statusBar = new StatusBarI();
    private IceGridGUI.LiveDeployment.Root _liveDeploymentRoot;
    private LiveDeploymentPane _liveDeploymentPane;
    private Map _liveApplications = new HashMap();
    private MainPane _mainPane;
    private int _latestSerial = -1;
    private int _writeSerial = -1;
    private Runnable _onExclusiveWrite;
    private int _writeAccessCount = 0;
    private boolean _substitute = false;
    private JFrame _mainFrame;
    private SessionKeeper _sessionKeeper;
    private Object _clipboard;
    private Action _newApplication;
    private Action _newApplicationWithDefaultTemplates;
    private Action _login;
    private Action _logout;
    private Action _acquireExclusiveWriteAccess;
    private Action _releaseExclusiveWriteAccess;
    private Action _openApplicationFromFile;
    private Action _openApplicationFromRegistry;
    private Action _closeApplication;
    private Action _save;
    private Action _saveToRegistry;
    private Action _saveToFile;
    private Action _discardUpdates;
    private Action _exit;
    private Action _back;
    private Action _forward;
    private Action _helpContents;
    private Action _about;
    private Action _patchApplication;
    private Action _showApplicationDetails;
    private Action _removeApplicationFromRegistry;
    private Action _cutText = new DefaultEditorKit.CutAction();
    private Action _copyText = new DefaultEditorKit.CopyAction();
    private Action _pasteText = new DefaultEditorKit.PasteAction();
    private DeleteTextAction _deleteText = new DeleteTextAction("Delete");
    private ActionWrapper _cut;
    private ActionWrapper _copy;
    private ActionWrapper _paste;
    private ActionWrapper _delete;
    private ActionWrapper _moveUp;
    private ActionWrapper _moveDown;
    private LiveActions _liveActionsForMenu = new LiveActions();
    private LiveActions _liveActionsForPopup = new LiveActions();
    private ApplicationActions _appActionsForMenu = new ApplicationActions(false);
    private ApplicationActions _appActionsForPopup = new ApplicationActions(true);
    private JToggleButton _showVarsTool;
    private JToggleButton _substituteTool;
    private JCheckBoxMenuItem _substituteMenuItem;
    private JCheckBoxMenuItem _showVarsMenuItem;
    private JMenu _newMenu;
    private JMenu _newServerMenu;
    private JMenu _newServiceMenu;
    private JMenu _newTemplateMenu;
    private JMenu _appMenu;
    private JMenu _nodeMenu;
    private JMenu _registryMenu;
    private JMenu _serverMenu;
    private JMenu _serviceMenu;
    private JMenu _signalMenu;
    private final Thread _shutdownHook;
    private JFileChooser _openChooser;
    private JFileChooser _saveXMLChooser;
    private JFileChooser _saveLogChooser;
    private Process _icegridadminProcess;
    private String _fileParser;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Communicator getCommunicator() {
        if (this._communicator == null) {
            try {
                this._communicator = Util.initialize(this._initData);
            }
            catch (LocalException e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Communicator initialization failed", 0);
            }
        }
        return this._communicator;
    }

    public Properties getProperties() {
        return this._initData.properties;
    }

    public Tab getCurrentTab() {
        return (Tab)((Object)this._mainPane.getSelectedComponent());
    }

    public Action getBackAction() {
        return this._back;
    }

    public Action getForwardAction() {
        return this._forward;
    }

    public Action getCloseApplicationAction() {
        return this._closeApplication;
    }

    public Action getSaveAction() {
        return this._save;
    }

    public Action getSaveToRegistryAction() {
        return this._saveToRegistry;
    }

    public Action getSaveToFileAction() {
        return this._saveToFile;
    }

    public Action getDiscardUpdatesAction() {
        return this._discardUpdates;
    }

    public ApplicationPane openLiveApplication(String applicationName) {
        ApplicationPane app = (ApplicationPane)this._liveApplications.get(applicationName);
        if (app == null) {
            Root root;
            ApplicationDescriptor desc = this._liveDeploymentRoot.getApplicationDescriptor(applicationName);
            if (desc == null) {
                JOptionPane.showMessageDialog(this._mainFrame, "The application '" + applicationName + "' was not found in the registry.", "No such application", 0);
                return null;
            }
            desc = Root.copyDescriptor(desc);
            try {
                root = new Root(this, desc, true, null);
            }
            catch (UpdateFailedException e) {
                JOptionPane.showMessageDialog(this._mainFrame, e.toString(), "Bad Application Descriptor: Unable load from Registry", 0);
                return null;
            }
            app = new ApplicationPane(root);
            this._mainPane.addApplication(app);
            this._liveApplications.put(applicationName, app);
        }
        this._mainPane.setSelectedComponent(app);
        return app;
    }

    public void removeLiveApplication(String name) {
        this._liveApplications.remove(name);
    }

    public void addLiveApplication(Root root) {
        ApplicationPane app = this._mainPane.findApplication(root);
        if (!$assertionsDisabled && app == null) {
            throw new AssertionError();
        }
        this._liveApplications.put(app.getRoot().getId(), app);
    }

    public ApplicationPane getLiveApplication(String name) {
        return (ApplicationPane)this._liveApplications.get(name);
    }

    void applicationInit(String instanceName, int serial, List applications) {
        if (!$assertionsDisabled && this._latestSerial != -1) {
            throw new AssertionError();
        }
        this._latestSerial = serial;
        this._liveDeploymentRoot.applicationInit(instanceName, this._sessionKeeper.getReplicaName(), applications);
    }

    void applicationAdded(int serial, ApplicationInfo info) {
        this._liveDeploymentRoot.applicationAdded(info);
        this._liveDeploymentPane.refresh();
        this._statusBar.setText("Last update: new application '" + info.descriptor.name + "'");
        this.updateSerial(serial);
    }

    void applicationRemoved(int serial, String name) {
        this._liveDeploymentRoot.applicationRemoved(name);
        this._liveDeploymentPane.refresh();
        this._statusBar.setText("Last update: application '" + name + "' was removed");
        ApplicationPane app = (ApplicationPane)this._liveApplications.get(name);
        if (app != null) {
            if (app.getRoot().kill()) {
                this._mainPane.remove(app);
            }
            this._liveApplications.remove(name);
        }
        this.updateSerial(serial);
    }

    void applicationUpdated(int serial, ApplicationUpdateInfo update) {
        this._liveDeploymentRoot.applicationUpdated(update);
        this._liveDeploymentPane.refresh();
        this._statusBar.setText("Last update: application  '" + update.descriptor.name + "' was updated");
        ApplicationPane app = (ApplicationPane)this._liveApplications.get(update.descriptor.name);
        if (app != null && app.getRoot().update(update.descriptor)) {
            app.refresh();
        }
        this.updateSerial(serial);
    }

    void adapterInit(AdapterInfo[] adapters) {
        this._liveDeploymentRoot.adapterInit(adapters);
        this._liveDeploymentPane.refresh();
    }

    void adapterAdded(AdapterInfo info) {
        this._liveDeploymentRoot.adapterAdded(info);
        this._liveDeploymentPane.refresh();
    }

    void adapterUpdated(AdapterInfo info) {
        this._liveDeploymentRoot.adapterUpdated(info);
        this._liveDeploymentPane.refresh();
    }

    void adapterRemoved(String id) {
        this._liveDeploymentRoot.adapterRemoved(id);
        this._liveDeploymentPane.refresh();
    }

    void objectInit(ObjectInfo[] objects) {
        this._liveDeploymentRoot.objectInit(objects);
        this._liveDeploymentPane.refresh();
    }

    void objectAdded(ObjectInfo info) {
        this._liveDeploymentRoot.objectAdded(info);
        this._liveDeploymentPane.refresh();
    }

    void objectUpdated(ObjectInfo info) {
        this._liveDeploymentRoot.objectUpdated(info);
        this._liveDeploymentPane.refresh();
    }

    void objectRemoved(Identity id) {
        this._liveDeploymentRoot.objectRemoved(id);
        this._liveDeploymentPane.refresh();
    }

    public void accessDenied(AccessDeniedException e) {
        JOptionPane.showMessageDialog(this._mainFrame, "Another session (username = " + e.lockUserId + ") has exclusive write access to the registry", "Access Denied", 0);
    }

    public void pasteApplication() {
        Object descriptor = this.getClipboard();
        ApplicationDescriptor desc = Root.copyDescriptor((ApplicationDescriptor)descriptor);
        Root root = new Root(this, desc);
        ApplicationPane app = new ApplicationPane(root);
        this._mainPane.addApplication(app);
        this._mainPane.setSelectedComponent(app);
        root.setSelectedNode(root);
    }

    public void removeApplicationFromRegistry(final String name) {
        this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Runnable runnable = new Runnable(){

                private void release() {
                    Coordinator.this.releaseExclusiveWriteAccess();
                    Coordinator.this.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                }

                private void handleFailure(String prefix, String title, String message) {
                    this.release();
                    Coordinator.this.getStatusBar().setText(prefix + "failed!");
                    JOptionPane.showMessageDialog(Coordinator.this.getMainFrame(), message, title, 0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run() {
                    Coordinator.this.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                    boolean asyncRelease = false;
                    String prefix = "Deleting application '" + name + "'...";
                    AMI_Admin_removeApplication cb = new AMI_Admin_removeApplication(this, prefix){
                        private final /* synthetic */ String val$prefix;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$prefix = val$prefix;
                        }

                        public void ice_response() {
                            if (Coordinator.access$4800(1.access$4700(this.this$1))) {
                                1.access$4700(this.this$1).traceSaveToRegistry("removeApplication for application " + 1.access$4900(this.this$1) + ": success");
                            }
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public void run() {
                                    1.access$5100(2.access$5000(this.this$2));
                                    1.access$4700(2.access$5000(this.this$2)).getStatusBar().setText(2.access$5200(this.this$2) + "done.");
                                }
                            });
                        }

                        public void ice_exception(UserException e) {
                            if (Coordinator.access$4800(1.access$4700(this.this$1))) {
                                1.access$4700(this.this$1).traceSaveToRegistry("removeApplication for application " + 1.access$4900(this.this$1) + ": failed");
                            }
                            SwingUtilities.invokeLater(new Runnable(this, e){
                                private final /* synthetic */ UserException val$e;
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$e = val$e;
                                }

                                public void run() {
                                    1.access$5300(2.access$5000(this.this$2), 2.access$5200(this.this$2), "Delete failed", "IceGrid exception: " + this.val$e.toString());
                                }
                            });
                        }

                        public void ice_exception(LocalException e) {
                            if (Coordinator.access$4800(1.access$4700(this.this$1))) {
                                1.access$4700(this.this$1).traceSaveToRegistry("removeApplication for application " + 1.access$4900(this.this$1) + ": failed");
                            }
                            SwingUtilities.invokeLater(new Runnable(this, e){
                                private final /* synthetic */ LocalException val$e;
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$e = val$e;
                                }

                                public void run() {
                                    1.access$5300(2.access$5000(this.this$2), 2.access$5200(this.this$2), "Delete failed", "Communication exception: " + this.val$e.toString());
                                }
                            });
                        }

                        static /* synthetic */ 1 access$5000(2 x0) {
                            return x0.this$1;
                        }

                        static /* synthetic */ String access$5200(2 x0) {
                            return x0.val$prefix;
                        }
                    };
                    if (Coordinator.this._traceSaveToRegistry) {
                        Coordinator.this.traceSaveToRegistry("sending removeApplication for application " + name);
                    }
                    try {
                        try {
                            Coordinator.this._sessionKeeper.getAdmin().removeApplication_async(cb, name);
                            return;
                        }
                        catch (LocalException e) {
                            if (Coordinator.this._traceSaveToRegistry) {
                                Coordinator.this.traceSaveToRegistry("Ice communications exception while removing application " + name);
                            }
                            JOptionPane.showMessageDialog(Coordinator.this.getMainFrame(), e.toString(), "Communication Exception", 0);
                            Object var6_5 = null;
                            if (asyncRelease) return;
                            Coordinator.this.releaseExclusiveWriteAccess();
                            Coordinator.this.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (asyncRelease) throw throwable;
                        Coordinator.this.releaseExclusiveWriteAccess();
                        Coordinator.this.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                        throw throwable;
                    }
                }

                static /* synthetic */ Coordinator access$4700(1 x0) {
                    return x0.Coordinator.this;
                }

                static /* synthetic */ String access$4900(1 x0) {
                    return x0.name;
                }

                static /* synthetic */ void access$5100(1 x0) {
                    x0.release();
                }

                static /* synthetic */ void access$5300(1 x0, String x1, String x2, String x3) {
                    x0.handleFailure(x1, x2, x3);
                }
            };
            this.acquireExclusiveWriteAccess(runnable);
        }
        catch (AccessDeniedException e) {
            this.accessDenied(e);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Could not remove application '" + name + "' from IceGrid registry:\n" + e.toString(), "Trouble with IceGrid registry", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusiveWriteAccess(Runnable runnable) throws AccessDeniedException {
        if (this._writeSerial == -1) {
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this._writeSerial = this._sessionKeeper.getSession().startUpdate();
                if (this._traceSaveToRegistry) {
                    this.traceSaveToRegistry("startUpdate returned serial " + this._writeSerial);
                }
            }
            finally {
                this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (!$assertionsDisabled && this._onExclusiveWrite != null) {
            throw new AssertionError();
        }
        ++this._writeAccessCount;
        if (this._traceSaveToRegistry) {
            this.traceSaveToRegistry("acquireExclusiveWriteAccess: writeAccessCount is " + this._writeAccessCount);
        }
        if (runnable != null) {
            if (this._traceSaveToRegistry) {
                this.traceSaveToRegistry("lastestSerial is " + this._latestSerial);
            }
            if (this._writeSerial <= this._latestSerial) {
                if (this._traceSaveToRegistry) {
                    this.traceSaveToRegistry("run update immediately");
                }
                runnable.run();
            } else {
                if (this._traceSaveToRegistry) {
                    this.traceSaveToRegistry("wait for updates from ApplicationObserver");
                }
                this._onExclusiveWrite = runnable;
                this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    public void releaseExclusiveWriteAccess() {
        if (--this._writeAccessCount == 0) {
            try {
                this._writeSerial = -1;
                this._sessionKeeper.getSession().finishUpdate();
                if (this._traceSaveToRegistry) {
                    this.traceSaveToRegistry("finishUpdate done");
                }
            }
            catch (AccessDeniedException e) {
                this.accessDenied(e);
            }
            catch (ObjectNotExistException e) {
            }
            catch (LocalException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "Could not release exclusive write access on the IceGrid registry:\n" + e.toString(), "Trouble with IceGrid registry", 0);
            }
        }
        if (this._traceSaveToRegistry) {
            this.traceSaveToRegistry("releaseExclusiveWriteAccess: writeAccessCount is " + this._writeAccessCount);
        }
    }

    private void updateSerial(int serial) {
        if (!$assertionsDisabled && serial != this._latestSerial + 1) {
            throw new AssertionError();
        }
        this._latestSerial = serial;
        if (this._writeAccessCount > 0 && this._writeSerial <= this._latestSerial && this._onExclusiveWrite != null) {
            Runnable runnable = this._onExclusiveWrite;
            this._onExclusiveWrite = null;
            if (this._traceSaveToRegistry) {
                this.traceSaveToRegistry("writeSerial <= latestSerial, running update");
            }
            runnable.run();
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void registryUp(RegistryInfo info) {
        this._liveDeploymentRoot.registryUp(info);
        this._liveDeploymentPane.refresh();
    }

    void registryDown(String registry) {
        this._liveDeploymentRoot.registryDown(registry);
        this._liveDeploymentPane.refresh();
    }

    void nodeUp(NodeDynamicInfo updatedInfo) {
        this._liveDeploymentRoot.nodeUp(updatedInfo);
        this._liveDeploymentPane.refresh();
    }

    void nodeDown(String node) {
        this._liveDeploymentRoot.nodeDown(node);
        this._liveDeploymentPane.refresh();
    }

    void updateServer(String node, ServerDynamicInfo updatedInfo) {
        this._liveDeploymentRoot.updateServer(node, updatedInfo);
        this._liveDeploymentPane.refresh();
    }

    void updateAdapter(String node, AdapterDynamicInfo updatedInfo) {
        this._liveDeploymentRoot.updateAdapter(node, updatedInfo);
        this._liveDeploymentPane.refresh();
    }

    void sessionLost() {
        this._latestSerial = -1;
        this._writeSerial = -1;
        this._writeAccessCount = 0;
        this._onExclusiveWrite = null;
        this._liveDeploymentRoot.clear();
        Iterator p = this._liveApplications.values().iterator();
        while (p.hasNext()) {
            ApplicationPane app = (ApplicationPane)p.next();
            if (!app.getRoot().kill()) continue;
            this._mainPane.remove(app);
        }
        this._liveApplications.clear();
        this._logout.setEnabled(false);
        this._openApplicationFromRegistry.setEnabled(false);
        this._patchApplication.setEnabled(false);
        this._showApplicationDetails.setEnabled(false);
        this._removeApplicationFromRegistry.setEnabled(false);
        this._appMenu.setEnabled(false);
        this._newApplicationWithDefaultTemplates.setEnabled(false);
        this._acquireExclusiveWriteAccess.setEnabled(false);
        this._releaseExclusiveWriteAccess.setEnabled(false);
        this._saveToRegistry.setEnabled(false);
    }

    AdminSessionPrx login(SessionKeeper.LoginInfo info, Component parent, LongHolder keepAlivePeriodHolder) {
        this._liveDeploymentRoot.clear();
        AdminSessionPrx session = null;
        this.destroyCommunicator();
        InitializationData initData = this._initData;
        if (info.routed && info.routerSSLEnabled || !info.routed && info.registrySSLEnabled) {
            initData = (InitializationData)initData.clone();
            initData.properties = initData.properties._clone();
            initData.properties.setProperty("Ice.Plugin.IceSSL", "IceSSL.PluginFactory");
            initData.properties.setProperty("IceSSL.Keystore", info.keystore);
            initData.properties.setProperty("IceSSL.Password", new String(info.keyPassword));
            initData.properties.setProperty("IceSSL.KeystorePassword", new String(info.keystorePassword));
            initData.properties.setProperty("IceSSL.Alias", info.alias);
            initData.properties.setProperty("IceSSL.Truststore", info.truststore);
            initData.properties.setProperty("IceSSL.TruststorePassword", new String(info.truststorePassword));
        }
        try {
            this._communicator = Util.initialize(initData);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(parent, e.toString(), "Communicator initialization failed", 0);
            return null;
        }
        if (info.routed) {
            Identity routerId = new Identity();
            routerId.category = info.routerInstanceName;
            routerId.name = "router";
            String str = "\"" + this._communicator.identityToString(routerId) + "\"";
            if (!info.routerEndpoints.equals("")) {
                str = str + ":" + info.routerEndpoints;
            }
            try {
                SessionPrx s;
                Glacier2.RouterPrx router = RouterPrxHelper.uncheckedCast(this._communicator.stringToProxy(str));
                this._communicator.setDefaultRouter(router);
                if (info.routerUseSSL) {
                    s = (router = RouterPrxHelper.uncheckedCast(router.ice_secure(true))).createSessionFromSecureConnection();
                    if (s == null) {
                        JOptionPane.showMessageDialog(parent, "createSessionFromSecureConnection returned a null session: \nverify that Glacier2.SSLSessionManager is set to <IceGridInstanceName>/AdminSSLSessionManager in your Glacier2 router configuration", "Login failed", 0);
                        return null;
                    }
                } else {
                    s = router.createSession(info.routerUsername, new String(info.routerPassword));
                    if (s == null) {
                        JOptionPane.showMessageDialog(parent, "createSession returned a null session: \nverify that Glacier2.SessionManager is set to <IceGridInstanceName>/AdminSessionManager in your Glacier2 router configuration", "Login failed", 0);
                        return null;
                    }
                }
                session = AdminSessionPrxHelper.uncheckedCast(s);
                keepAlivePeriodHolder.value = router.getSessionTimeout() * 1000L / 2L;
            }
            catch (Glacier2.PermissionDeniedException e) {
                if (e.reason.length() == 0) {
                    e.reason = info.routerUseSSL ? "Invalid credentials" : "Invalid username/password";
                }
                JOptionPane.showMessageDialog(parent, "Permission denied: " + e.reason, "Login failed", 0);
                return null;
            }
            catch (CannotCreateSessionException e) {
                JOptionPane.showMessageDialog(parent, "Could not create session: " + e.reason, "Login failed", 0);
                return null;
            }
            catch (LocalException e) {
                JOptionPane.showMessageDialog(parent, "Could not create session: " + e.toString(), "Login failed", 0);
                return null;
            }
        }
        if (info.registryEndpoints.equals("")) {
            JOptionPane.showMessageDialog(parent, "You need to provide one or more endpoint for the Registry", "Login failed", 0);
            return null;
        }
        Identity locatorId = new Identity();
        locatorId.category = info.registryInstanceName;
        locatorId.name = "Locator";
        String str = "\"" + this._communicator.identityToString(locatorId) + "\"";
        str = str + ":" + info.registryEndpoints;
        RegistryPrx currentRegistry = null;
        try {
            LocatorPrx defaultLocator = LocatorPrxHelper.checkedCast(this._communicator.stringToProxy(str));
            if (defaultLocator == null) {
                JOptionPane.showMessageDialog(parent, "This version of IceGrid Admin requires an IceGrid Registry version 3.2 or higher", "Version Mismatch", 0);
                return null;
            }
            currentRegistry = defaultLocator.getLocalRegistry();
            currentRegistry = RegistryPrxHelper.uncheckedCast(currentRegistry.ice_endpoints(defaultLocator.ice_getEndpoints()));
            this._communicator.setDefaultLocator(defaultLocator);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(parent, "Could not contact '" + str + "': " + e.toString(), "Login failed", 0);
            return null;
        }
        RegistryPrx registry = currentRegistry;
        if (info.connectToMaster && !currentRegistry.ice_getIdentity().name.equals("Registry")) {
            Identity masterRegistryId = new Identity();
            masterRegistryId.category = info.registryInstanceName;
            masterRegistryId.name = "Registry";
            registry = RegistryPrxHelper.uncheckedCast(this._communicator.stringToProxy("\"" + this._communicator.identityToString(masterRegistryId) + "\""));
        }
        do {
            try {
                if (info.registryUseSSL) {
                    registry = RegistryPrxHelper.uncheckedCast(registry.ice_secure(true));
                    session = registry.createAdminSessionFromSecureConnection();
                    if (!$assertionsDisabled && session == null) {
                        throw new AssertionError();
                    }
                } else {
                    session = registry.createAdminSession(info.registryUsername, new String(info.registryPassword));
                    if (!$assertionsDisabled && session == null) {
                        throw new AssertionError();
                    }
                }
                keepAlivePeriodHolder.value = registry.getSessionTimeout() * 1000 / 2;
                if (registry != currentRegistry) continue;
                session = AdminSessionPrxHelper.uncheckedCast(session.ice_endpoints(currentRegistry.ice_getEndpoints()));
            }
            catch (PermissionDeniedException e) {
                JOptionPane.showMessageDialog(parent, "Permission denied: " + e.reason, "Login failed", 0);
                return null;
            }
            catch (LocalException e) {
                if (registry.ice_getIdentity().equals(currentRegistry.ice_getIdentity())) {
                    JOptionPane.showMessageDialog(parent, "Could not create session: " + e.toString(), "Login failed", 0);
                    return null;
                }
                if (JOptionPane.showConfirmDialog(parent, "Unable to connect to the Master Registry:\n " + e.toString() + "\n\nDo you want to connect to a Slave Registry?", "Cannot connect to Master Registry", 0, 3) == 0) {
                    registry = currentRegistry;
                    continue;
                }
                return null;
            }
        } while (session == null);
        this._logout.setEnabled(true);
        this._openApplicationFromRegistry.setEnabled(true);
        this._patchApplication.setEnabled(true);
        this._showApplicationDetails.setEnabled(true);
        this._removeApplicationFromRegistry.setEnabled(true);
        this._appMenu.setEnabled(true);
        this._newApplicationWithDefaultTemplates.setEnabled(true);
        this._acquireExclusiveWriteAccess.setEnabled(true);
        this._mainPane.setSelectedComponent(this._liveDeploymentPane);
        return session;
    }

    void destroySession(AdminSessionPrx session) {
        this._liveDeploymentRoot.closeAllShowLogDialogs();
        RouterPrx router = this._communicator.getDefaultRouter();
        try {
            if (router == null) {
                session.destroy();
            } else {
                Glacier2.RouterPrx gr = RouterPrxHelper.uncheckedCast(router);
                gr.destroySession();
            }
        }
        catch (SessionNotExistException e) {
        }
        catch (LocalException localException) {
            // empty catch block
        }
    }

    void showVars() {
        this.substitute(false);
    }

    void substituteVars() {
        this.substitute(true);
    }

    private void substitute(boolean newValue) {
        if (this._substitute != newValue) {
            ApplicationPane app;
            this._substitute = newValue;
            boolean refresh = true;
            if (this.getCurrentTab() instanceof ApplicationPane && !(app = (ApplicationPane)this.getCurrentTab()).applyUpdates(true)) {
                this._substitute = !this._substitute;
                refresh = false;
            }
            if (this._substitute) {
                this._substituteMenuItem.setSelected(true);
                this._substituteTool.setSelected(true);
            } else {
                this._showVarsMenuItem.setSelected(true);
                this._showVarsTool.setSelected(true);
            }
            if (refresh) {
                this.getCurrentTab().refresh();
            }
        }
    }

    public boolean substitute() {
        return this._substitute;
    }

    public AdminPrx getAdmin() {
        return this._sessionKeeper.getAdmin();
    }

    public StatusBar getStatusBar() {
        return this._statusBar;
    }

    public JFrame getMainFrame() {
        return this._mainFrame;
    }

    public MainPane getMainPane() {
        return this._mainPane;
    }

    public ApplicationDescriptor parseFile(File file) {
        if (this._icegridadminProcess == null) {
            try {
                this._icegridadminProcess = Runtime.getRuntime().exec("icegridadmin --server");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "Failed to start icegridadmin subprocess: " + e.toString(), "IO Exception", 0);
                return null;
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this._icegridadminProcess.getInputStream(), "US-ASCII"));
                String str = reader.readLine();
                reader.close();
                if (str == null || str.length() == 0) {
                    JOptionPane.showMessageDialog(this._mainFrame, "The icegridadmin subprocess failed", "Subprocess failure", 0);
                    this.destroyIceGridAdmin();
                    return null;
                }
                this._fileParser = str;
            }
            catch (UnsupportedEncodingException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "IO Exception: " + e.toString(), "IO Exception", 0);
                this.destroyIceGridAdmin();
                return null;
            }
        }
        try {
            FileParserPrx fileParser = FileParserPrxHelper.checkedCast(this.getCommunicator().stringToProxy(this._fileParser).ice_router(null));
            return fileParser.parse(file.getAbsolutePath(), this._sessionKeeper.getRoutedAdmin());
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Failed to parse file '" + file.getAbsolutePath() + "':\n" + e.toString(), "Parse error", 0);
            return null;
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Operation on FileParser failed:\n" + e.toString(), "Communication error", 0);
            this.destroyIceGridAdmin();
            return null;
        }
    }

    private void destroyIceGridAdmin() {
        if (this._icegridadminProcess != null) {
            try {
                this._icegridadminProcess.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._icegridadminProcess = null;
            this._fileParser = null;
        }
    }

    public File saveToFile(boolean ask, Root root, File file) {
        if (ask || file == null) {
            if (file != null) {
                this._saveXMLChooser.setSelectedFile(file);
            } else {
                this._saveXMLChooser.setCurrentDirectory(this._openChooser.getCurrentDirectory());
            }
            int result = this._saveXMLChooser.showSaveDialog(this._mainFrame);
            if (file == null || result == 0) {
                this._openChooser.setCurrentDirectory(this._saveXMLChooser.getCurrentDirectory());
            }
            file = result == 0 ? this._saveXMLChooser.getSelectedFile() : null;
        }
        if (file != null) {
            if (!file.exists() && file.getName().indexOf(46) == -1) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            try {
                XMLWriter writer = new XMLWriter(file);
                root.write(writer);
                writer.close();
                this._statusBar.setText("Saved application '" + root.getId() + "' to " + file.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "Cannot use the selected file for writing.", "File Not Found", 0);
                return null;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "IO Exception: " + e.toString(), "IO Exception", 0);
                return null;
            }
        }
        return file;
    }

    public JFileChooser getSaveLogChooser() {
        return this._saveLogChooser;
    }

    private static Properties createProperties(StringSeqHolder args) {
        Properties properties = Util.createProperties();
        properties.setProperty("Ice.Override.ConnectTimeout", "5000");
        properties.setProperty("Ice.ThreadPerConnection", "1");
        properties.setProperty("Ice.ACM.Client", "0");
        properties.setProperty("Ice.MonitorConnections", "5");
        properties.setProperty("Ice.RetryIntervals", "-1");
        return Util.createProperties(args, properties);
    }

    Coordinator(JFrame mainFrame, StringSeqHolder args, Preferences prefs) {
        this._mainFrame = mainFrame;
        this._prefs = prefs;
        this._initData = new InitializationData();
        this._initData.logger = new Logger(mainFrame);
        this._initData.properties = Coordinator.createProperties(args);
        if (args.value.length > 0) {
            String msg = "Extra command-line arguments: ";
            for (int i = 0; i < args.value.length; ++i) {
                msg = msg + args.value[i] + " ";
            }
            this._initData.logger.warning(msg);
        }
        this._traceObservers = this._initData.properties.getPropertyAsInt("IceGridAdmin.Trace.Observers") > 0;
        this._traceSaveToRegistry = this._initData.properties.getPropertyAsInt("IceGridAdmin.Trace.SaveToRegistry") > 0;
        this._liveDeploymentRoot = new IceGridGUI.LiveDeployment.Root(this);
        this._sessionKeeper = new SessionKeeper(this);
        this._shutdownHook = new Thread("Shutdown hook"){

            public void run() {
                Coordinator.this.destroyIceGridAdmin();
                Coordinator.this.destroyCommunicator();
            }
        };
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
        this._saveXMLChooser = new JFileChooser(this._prefs.get("current directory", null));
        this._saveXMLChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            public String getDescription() {
                return ".xml files";
            }
        });
        this._saveLogChooser = new JFileChooser(this._prefs.get("current directory", null));
        this._saveLogChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".out") || f.getName().endsWith(".err") || f.getName().endsWith(".log") || f.getName().endsWith(".txt");
            }

            public String getDescription() {
                return ".out .err .log .txt files";
            }
        });
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        this._openChooser = new JFileChooser(this._saveXMLChooser.getCurrentDirectory());
        this._openChooser.addChoosableFileFilter(this._saveXMLChooser.getChoosableFileFilters()[1]);
        int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._newApplication = new AbstractAction("Application"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.newApplication();
            }
        };
        this._newApplicationWithDefaultTemplates = new AbstractAction("Application with Default Templates from Registry"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.newApplicationWithDefaultTemplates();
            }
        };
        this._newApplicationWithDefaultTemplates.setEnabled(false);
        this._login = new AbstractAction("Login..."){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this._sessionKeeper.relog(true);
            }
        };
        this._login.putValue("ShortDescription", "Log into an IceGrid Registry");
        this._logout = new AbstractAction("Logout"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this._sessionKeeper.logout(true);
            }
        };
        this._logout.putValue("ShortDescription", "Logout");
        this._logout.setEnabled(false);
        this._acquireExclusiveWriteAccess = new AbstractAction("Acquire Exclusive Write Access"){

            public void actionPerformed(ActionEvent e) {
                try {
                    Coordinator.this.acquireExclusiveWriteAccess(null);
                    Coordinator.this._releaseExclusiveWriteAccess.setEnabled(true);
                    Coordinator.this._acquireExclusiveWriteAccess.setEnabled(false);
                }
                catch (AccessDeniedException ade) {
                    Coordinator.this.accessDenied(ade);
                }
            }
        };
        this._acquireExclusiveWriteAccess.putValue("ShortDescription", "Acquire exclusive write access on the registry");
        this._acquireExclusiveWriteAccess.setEnabled(false);
        this._releaseExclusiveWriteAccess = new AbstractAction("Release Exclusive Write Access"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.releaseExclusiveWriteAccess();
                Coordinator.this._acquireExclusiveWriteAccess.setEnabled(true);
                Coordinator.this._releaseExclusiveWriteAccess.setEnabled(false);
            }
        };
        this._releaseExclusiveWriteAccess.putValue("ShortDescription", "Release exclusive write access on the registry");
        this._releaseExclusiveWriteAccess.setEnabled(false);
        this._openApplicationFromFile = new AbstractAction("Application from File"){

            public void actionPerformed(ActionEvent e) {
                File file;
                ApplicationDescriptor desc;
                int result = Coordinator.this._openChooser.showOpenDialog(Coordinator.this._mainFrame);
                if (result == 0 && (desc = Coordinator.this.parseFile(file = Coordinator.this._openChooser.getSelectedFile())) != null) {
                    Root root;
                    try {
                        root = new Root(Coordinator.this, desc, false, file);
                    }
                    catch (UpdateFailedException ex) {
                        JOptionPane.showMessageDialog(Coordinator.this._mainFrame, ex.toString(), "Bad Application Descriptor: Unable load from file", 0);
                        return;
                    }
                    ApplicationPane app = new ApplicationPane(root);
                    Coordinator.this._mainPane.addApplication(app);
                    Coordinator.this._mainPane.setSelectedComponent(app);
                    root.setSelectedNode(root);
                }
            }
        };
        this._openApplicationFromFile.putValue("ShortDescription", "Open application from file");
        this._openApplicationFromFile.setEnabled(true);
        this._openApplicationFromRegistry = new AbstractAction("Application from Registry"){

            public void actionPerformed(ActionEvent e) {
                Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "The registry does not contain any application", "Empty registry", 1);
                } else {
                    Root root;
                    ApplicationPane app;
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which Application do you want to open?", "Open Application from registry", 3, null, applicationNames, applicationNames[0]);
                    if (appName != null && (app = Coordinator.this.openLiveApplication(appName)) != null && (root = app.getRoot()).getSelectedNode() == null) {
                        root.setSelectedNode(root);
                    }
                }
            }
        };
        this._openApplicationFromRegistry.putValue("ShortDescription", "Open application from registry");
        this._openApplicationFromRegistry.setEnabled(false);
        this._closeApplication = new AbstractAction("Close Application"){

            public void actionPerformed(ActionEvent e) {
                Tab tab = Coordinator.this.getCurrentTab();
                if (tab.close()) {
                    String id = ((ApplicationPane)tab).getRoot().getId();
                    Coordinator.this._liveApplications.remove(id);
                }
            }
        };
        this._closeApplication.putValue("ShortDescription", "Close application");
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            this._closeApplication.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, MENU_MASK));
        } else {
            this._closeApplication.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, MENU_MASK));
        }
        this._closeApplication.setEnabled(false);
        this._save = new AbstractAction("Save"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().save();
            }
        };
        this._save.setEnabled(false);
        this._save.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, MENU_MASK));
        this._save.putValue("ShortDescription", "Save");
        this._saveToRegistry = new AbstractAction("Save to Registry"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().saveToRegistry();
            }
        };
        this._saveToRegistry.setEnabled(false);
        this._saveToRegistry.putValue("ShortDescription", "Save to registry");
        this._saveToFile = new AbstractAction("Save to File"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().saveToFile();
            }
        };
        this._saveToFile.setEnabled(false);
        this._saveToFile.putValue("ShortDescription", "Save to file");
        this._discardUpdates = new AbstractAction("Discard Updates"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().discardUpdates();
            }
        };
        this._discardUpdates.setEnabled(false);
        this._discardUpdates.putValue("ShortDescription", "Discard updates and reload application");
        this._exit = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.exit(0);
            }
        };
        this._exit.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt F4"));
        this._back = new AbstractAction("Go Back to the Previous Node"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().back();
            }
        };
        this._back.setEnabled(false);
        this._back.putValue("ShortDescription", "Go back to the previous node");
        this._forward = new AbstractAction("Go to the Next Node"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().forward();
            }
        };
        this._forward.setEnabled(false);
        this._forward.putValue("ShortDescription", "Go to the next node");
        this._helpContents = new AbstractAction("Contents"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.helpContents();
            }
        };
        this._about = new AbstractAction("About"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.about();
            }
        };
        this._patchApplication = new AbstractAction("Patch Distribution"){

            public void actionPerformed(ActionEvent e) {
                Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getPatchableApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "No application in this IceGrid registry can be patched", "No application", 1);
                } else {
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which Application do you want to patch?", "Patch application", 3, null, applicationNames, applicationNames[0]);
                    if (appName != null) {
                        Coordinator.this._liveDeploymentRoot.patch(appName);
                    }
                }
            }
        };
        this._patchApplication.setEnabled(false);
        this._showApplicationDetails = new AbstractAction("Show details"){

            public void actionPerformed(ActionEvent e) {
                Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "There is no application deployed in this IceGrid registry", "No application", 1);
                } else {
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which Application do you to display", "Show details", 3, null, applicationNames, applicationNames[0]);
                    if (appName != null) {
                        Coordinator.this._liveDeploymentRoot.showApplicationDetails(appName);
                    }
                }
            }
        };
        this._showApplicationDetails.setEnabled(false);
        this._removeApplicationFromRegistry = new AbstractAction("Remove from Registry"){

            public void actionPerformed(ActionEvent e) {
                Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "There is no application deployed in this IceGrid registry", "No application", 1);
                } else {
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which Application do you want to remove?", "Remove application", 3, null, applicationNames, applicationNames[0]);
                    if (appName != null) {
                        Coordinator.this.removeApplicationFromRegistry(appName);
                    }
                }
            }
        };
        this._removeApplicationFromRegistry.setEnabled(false);
        this._cut = new ActionWrapper("Cut");
        this._cut.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, MENU_MASK));
        this._cut.putValue("ShortDescription", "Cut");
        this._copy = new ActionWrapper("Copy");
        this._copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, MENU_MASK));
        this._copy.putValue("ShortDescription", "Copy");
        this._paste = new ActionWrapper("Paste");
        this._paste.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, MENU_MASK));
        this._paste.putValue("ShortDescription", "Paste");
        this._delete = new ActionWrapper("Delete");
        this._delete.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this._delete.putValue("ShortDescription", "Delete");
        this._moveUp = new ActionWrapper("Move Up");
        this._moveDown = new ActionWrapper("Move Down");
        this._showVarsMenuItem = new JCheckBoxMenuItem(this._appActionsForMenu.get(16));
        this._showVarsTool = new JToggleButton(this._appActionsForMenu.get(16));
        this._showVarsTool.setIcon(Utils.getIcon("/icons/24x24/show_vars.png"));
        this._showVarsTool.setText("");
        this._substituteMenuItem = new JCheckBoxMenuItem(this._appActionsForMenu.get(17));
        this._substituteTool = new JToggleButton(this._appActionsForMenu.get(17));
        this._substituteTool.setIcon(Utils.getIcon("/icons/24x24/substitute.png"));
        this._substituteTool.setText("");
        ButtonGroup group = new ButtonGroup();
        group.add(this._showVarsMenuItem);
        group.add(this._substituteMenuItem);
        group = new ButtonGroup();
        group.add(this._showVarsTool);
        group.add(this._substituteTool);
        this._showVarsMenuItem.setSelected(true);
        this._showVarsTool.setSelected(true);
        this._mainFrame.setJMenuBar(new MenuBar());
        this._mainFrame.getContentPane().add((Component)new ToolBar(), "First");
        this._mainFrame.getContentPane().add((Component)this._statusBar, "Last");
        KeyboardFocusManager kbm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kbm.addPropertyChangeListener("permanentFocusOwner", new FocusListener());
        this._liveDeploymentPane = new LiveDeploymentPane(this._liveDeploymentRoot);
        this._mainPane = new MainPane(this);
        this._mainFrame.getContentPane().add((Component)this._mainPane, "Center");
    }

    JComponent getLiveDeploymentPane() {
        return this._liveDeploymentPane;
    }

    public IceGridGUI.LiveDeployment.Root getLiveDeploymentRoot() {
        return this._liveDeploymentRoot;
    }

    private void newApplication() {
        ApplicationDescriptor desc = new ApplicationDescriptor("NewApplication", new TreeMap(), new LinkedList(), new HashMap(), new HashMap(), new HashMap(), new DistributionDescriptor("", new LinkedList()), "", new HashMap());
        Root root = new Root(this, desc);
        ApplicationPane app = new ApplicationPane(root);
        this._mainPane.addApplication(app);
        this._mainPane.setSelectedComponent(app);
        root.setSelectedNode(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newApplicationWithDefaultTemplates() {
        this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ApplicationDescriptor descriptor = this.getAdmin().getDefaultApplicationDescriptor();
            descriptor.name = "NewApplication";
            Root root = new Root(this, descriptor);
            ApplicationPane app = new ApplicationPane(root);
            this._mainPane.addApplication(app);
            this._mainPane.setSelectedComponent(app);
            root.setSelectedNode(root);
        }
        catch (DeploymentException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "The default application descriptor from the IceGrid registry is invalid:\n" + e.reason, "Deployment Exception", 0);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Could not retrieve the default application descriptor from the IceGrid registry: \n" + e.toString(), "Trouble with IceGrid registry", 0);
        }
        finally {
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void helpContents() {
        URL url;
        if (System.getProperty("os.name").startsWith("Windows") && (url = ClassLoader.getSystemResource("IceGridAdmin.chm")) != null) {
            String path = url.getPath().substring(1);
            try {
                Runtime.getRuntime().exec("hh.exe " + path);
                return;
            }
            catch (IOException ex) {
                this._initData.logger.warning(ex.toString());
            }
        }
        if ((url = ClassLoader.getSystemResource("IceGridAdmin/index.html")) != null) {
            BareBonesBrowserLaunch.openURL(url.toString());
        } else {
            BareBonesBrowserLaunch.openURL("http://www.zeroc.com/doc/Ice-3.2.1/IceGridAdmin/index.html");
        }
    }

    private void about() {
        String text = "IceGrid Admin version 3.2.1\nCopyright \u00a9 2005-2007 ZeroC, Inc. All rights reserved.\n";
        JOptionPane.showMessageDialog(this._mainFrame, text, "About - IceGrid Admin", 1);
    }

    public void setClipboard(Object copy) {
        this._clipboard = copy;
    }

    public Object getClipboard() {
        return this._clipboard;
    }

    void showMainFrame() {
        if (!this.loadWindowPrefs()) {
            this._mainFrame.setLocation(100, 100);
            this._mainFrame.pack();
        }
        this._mainFrame.setVisible(true);
    }

    void exit(int status) {
        File dir;
        if (this._openChooser != null && (dir = this._openChooser.getCurrentDirectory()) != null) {
            this._prefs.put("current directory", dir.getAbsolutePath());
        }
        this.storeWindowPrefs();
        this.destroyIceGridAdmin();
        this.destroyCommunicator();
        Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
        this._mainFrame.dispose();
        Runtime.getRuntime().exit(status);
    }

    private void destroyCommunicator() {
        if (this._communicator != null) {
            try {
                this._communicator.destroy();
            }
            catch (LocalException e) {
                System.err.println("_communicator.destroy() raised " + e.toString());
                e.printStackTrace();
            }
            this._communicator = null;
        }
    }

    private boolean loadWindowPrefs() {
        try {
            if (!this._prefs.nodeExists("Window")) {
                return false;
            }
        }
        catch (BackingStoreException e) {
            return false;
        }
        Preferences windowPrefs = this._prefs.node("Window");
        int x = windowPrefs.getInt("x", 0);
        int y = windowPrefs.getInt("y", 0);
        int width = windowPrefs.getInt("width", 0);
        int height = windowPrefs.getInt("height", 0);
        this._mainFrame.setBounds(new Rectangle(x, y, width, height));
        if (windowPrefs.getBoolean("maximized", false)) {
            this._mainFrame.setExtendedState(6);
        }
        return true;
    }

    private void storeWindowPrefs() {
        Preferences windowPrefs = this._prefs.node("Window");
        Rectangle rect = this._mainFrame.getBounds();
        windowPrefs.putInt("x", rect.x);
        windowPrefs.putInt("y", rect.y);
        windowPrefs.putInt("width", rect.width);
        windowPrefs.putInt("height", rect.height);
        windowPrefs.putBoolean("maximized", this._mainFrame.getExtendedState() == 6);
    }

    public AdminSessionPrx getSession() {
        return this._sessionKeeper.getSession();
    }

    public boolean connectedToMaster() {
        return this._sessionKeeper.connectedToMaster();
    }

    public Preferences getPrefs() {
        return this._prefs;
    }

    public LiveActions getLiveActionsForPopup() {
        return this._liveActionsForPopup;
    }

    public LiveActions getLiveActionsForMenu() {
        return this._liveActionsForMenu;
    }

    public ApplicationActions getActionsForMenu() {
        return this._appActionsForMenu;
    }

    public ApplicationActions getActionsForPopup() {
        return this._appActionsForPopup;
    }

    public void showActions(TreeNode node) {
        boolean[] availableActions = this._liveActionsForMenu.setTarget(node);
        this._appActionsForMenu.setTarget(null);
        this._newServerMenu.setEnabled(false);
        this._newServiceMenu.setEnabled(false);
        this._newTemplateMenu.setEnabled(false);
        this._appMenu.setEnabled(true);
        this._nodeMenu.setEnabled(availableActions[15]);
        this._registryMenu.setEnabled(availableActions[18] || availableActions[16]);
        this._signalMenu.setEnabled(availableActions[4]);
        this._serverMenu.setEnabled(availableActions[0] || availableActions[1] || availableActions[2] || availableActions[3] || availableActions[17] || availableActions[11] || availableActions[12] || availableActions[13] || availableActions[14] || availableActions[4]);
        this._serviceMenu.setEnabled(availableActions[14]);
    }

    public void showActions(IceGridGUI.Application.TreeNode node) {
        boolean[] availableActions = this._appActionsForMenu.setTarget(node);
        this._liveActionsForMenu.setTarget(null);
        this._newServerMenu.setEnabled(availableActions[5] || availableActions[6] || availableActions[7]);
        this._newServiceMenu.setEnabled(availableActions[8] || availableActions[9]);
        this._newTemplateMenu.setEnabled(availableActions[10] || availableActions[11] || availableActions[12]);
        this._appMenu.setEnabled(false);
        this._nodeMenu.setEnabled(false);
        this._registryMenu.setEnabled(false);
        this._signalMenu.setEnabled(false);
        this._serverMenu.setEnabled(false);
        this._serviceMenu.setEnabled(false);
    }

    public boolean traceObservers() {
        return this._traceObservers;
    }

    public void traceObserver(String message) {
        this.trace("Observers", message);
    }

    public boolean traceSaveToRegistry() {
        return this._traceSaveToRegistry;
    }

    public void traceSaveToRegistry(String message) {
        this.trace("SaveToRegistry", message);
    }

    private void trace(String category, String message) {
        this._initData.logger.trace(category, message);
    }

    static {
        $assertionsDisabled = !Coordinator.class.desiredAssertionStatus();
    }

    private class ToolBar
    extends JToolBar {
        private ToolBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            JButton button = new JButton(Coordinator.this._login);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/login.png"));
            this.add(button);
            button = new JButton(Coordinator.this._logout);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/logout.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._back);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/back.png"));
            this.add(button);
            button = new JButton(Coordinator.this._forward);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/forward.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._openApplicationFromRegistry);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/open_from_registry.png"));
            this.add(button);
            button = new JButton(Coordinator.this._openApplicationFromFile);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/open_from_file.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._save);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save.png"));
            this.add(button);
            button = new JButton(Coordinator.this._saveToRegistry);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save_to_registry.png"));
            this.add(button);
            button = new JButton(Coordinator.this._saveToFile);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save_to_file.png"));
            this.add(button);
            button = new JButton(Coordinator.this._discardUpdates);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/discard.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._copy);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/copy.png"));
            this.add(button);
            button = new JButton(Coordinator.this._paste);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/paste.png"));
            this.add(button);
            button = new JButton(Coordinator.this._delete);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/delete.png"));
            this.add(button);
            this.addSeparator();
            this.add(Coordinator.this._showVarsTool);
            this.add(Coordinator.this._substituteTool);
        }
    }

    private class MenuBar
    extends JMenuBar {
        private MenuBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic(70);
            this.add(fileMenu);
            Coordinator.this._newMenu = new JMenu("New");
            fileMenu.add(Coordinator.this._newMenu);
            Coordinator.this._newMenu.add(Coordinator.this._newApplication);
            Coordinator.this._newMenu.add(Coordinator.this._newApplicationWithDefaultTemplates);
            Coordinator.this._newMenu.addSeparator();
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(0));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(1));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(2));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(3));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(4));
            JMenu openMenu = new JMenu("Open");
            openMenu.add(Coordinator.this._openApplicationFromFile);
            openMenu.add(Coordinator.this._openApplicationFromRegistry);
            Coordinator.this._newServerMenu = new JMenu("Server");
            Coordinator.this._newServerMenu.setEnabled(false);
            Coordinator.this._newMenu.add(Coordinator.this._newServerMenu);
            Coordinator.this._newServerMenu.add(Coordinator.this._appActionsForMenu.get(5));
            Coordinator.this._newServerMenu.add(Coordinator.this._appActionsForMenu.get(6));
            Coordinator.this._newServerMenu.add(Coordinator.this._appActionsForMenu.get(7));
            Coordinator.this._newServiceMenu = new JMenu("Service");
            Coordinator.this._newServiceMenu.setEnabled(false);
            Coordinator.this._newMenu.add(Coordinator.this._newServiceMenu);
            Coordinator.this._newServiceMenu.add(Coordinator.this._appActionsForMenu.get(8));
            Coordinator.this._newServiceMenu.add(Coordinator.this._appActionsForMenu.get(9));
            Coordinator.this._newTemplateMenu = new JMenu("Template");
            Coordinator.this._newTemplateMenu.setEnabled(false);
            Coordinator.this._newMenu.add(Coordinator.this._newTemplateMenu);
            Coordinator.this._newTemplateMenu.add(Coordinator.this._appActionsForMenu.get(10));
            Coordinator.this._newTemplateMenu.add(Coordinator.this._appActionsForMenu.get(11));
            Coordinator.this._newTemplateMenu.add(Coordinator.this._appActionsForMenu.get(12));
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._login);
            fileMenu.add(Coordinator.this._logout);
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._acquireExclusiveWriteAccess);
            fileMenu.add(Coordinator.this._releaseExclusiveWriteAccess);
            fileMenu.addSeparator();
            fileMenu.add(openMenu);
            fileMenu.add(Coordinator.this._closeApplication);
            fileMenu.add(Coordinator.this._save);
            fileMenu.add(Coordinator.this._saveToFile);
            fileMenu.add(Coordinator.this._saveToRegistry);
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._discardUpdates);
            if (!System.getProperty("os.name").startsWith("Mac OS")) {
                fileMenu.addSeparator();
                fileMenu.add(Coordinator.this._exit);
            }
            JMenu editMenu = new JMenu("Edit");
            editMenu.setMnemonic(69);
            this.add(editMenu);
            editMenu.add(Coordinator.this._cut);
            editMenu.add(Coordinator.this._copy);
            editMenu.add(Coordinator.this._paste);
            editMenu.add(Coordinator.this._delete);
            editMenu.addSeparator();
            editMenu.add(Coordinator.this._moveUp);
            editMenu.add(Coordinator.this._moveDown);
            JMenu viewMenu = new JMenu("View");
            viewMenu.setMnemonic(86);
            this.add(viewMenu);
            viewMenu.add(Coordinator.this._showVarsMenuItem);
            viewMenu.add(Coordinator.this._substituteMenuItem);
            viewMenu.addSeparator();
            viewMenu.add(Coordinator.this._back);
            viewMenu.add(Coordinator.this._forward);
            JMenu toolsMenu = new JMenu("Tools");
            toolsMenu.setMnemonic(84);
            this.add(toolsMenu);
            Coordinator.this._appMenu = new JMenu("Application");
            Coordinator.this._appMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._appMenu);
            Coordinator.this._appMenu.add(Coordinator.this._patchApplication);
            Coordinator.this._appMenu.add(Coordinator.this._showApplicationDetails);
            Coordinator.this._appMenu.addSeparator();
            Coordinator.this._appMenu.add(Coordinator.this._removeApplicationFromRegistry);
            Coordinator.this._appMenu.setEnabled(false);
            Coordinator.this._nodeMenu = new JMenu("Node");
            Coordinator.this._nodeMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._nodeMenu);
            Coordinator.this._nodeMenu.add(Coordinator.this._liveActionsForMenu.get(15));
            Coordinator.this._registryMenu = new JMenu("Registry");
            Coordinator.this._registryMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._registryMenu);
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(18));
            Coordinator.this._registryMenu.addSeparator();
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(12));
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(13));
            Coordinator.this._registryMenu.addSeparator();
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(16));
            Coordinator.this._serverMenu = new JMenu("Server");
            Coordinator.this._serverMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._serverMenu);
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(0));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(1));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(2));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(3));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(17));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(11));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(12));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(13));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(14));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._signalMenu = new JMenu("Send Signal");
            Coordinator.this._serverMenu.add(Coordinator.this._signalMenu);
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(4));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(5));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(6));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(7));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(8));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(9));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(10));
            Coordinator.this._serviceMenu = new JMenu("Service");
            Coordinator.this._serviceMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._serviceMenu);
            Coordinator.this._serviceMenu.add(Coordinator.this._liveActionsForMenu.get(14));
            JMenu helpMenu = new JMenu("Help");
            helpMenu.setMnemonic(72);
            this.add(helpMenu);
            helpMenu.add(Coordinator.this._helpContents);
            helpMenu.addSeparator();
            helpMenu.add(Coordinator.this._about);
        }
    }

    private class FocusListener
    implements PropertyChangeListener {
        private FocusListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Object o = e.getNewValue();
            if (o == null) {
                this.unknownTarget();
            } else if (o instanceof JTextComponent) {
                this.enableTextEditActions((JTextComponent)o);
            } else if (o instanceof JTree) {
                JTree tree = (JTree)o;
                if (tree.getModel().getRoot() instanceof Root) {
                    this.enableTreetEditActions();
                } else {
                    this.disableAllEditMenusAndButtons();
                }
            } else {
                this.unknownTarget();
            }
        }

        private void unknownTarget() {
            if (Coordinator.this._copy.getTarget() == Coordinator.this._copyText) {
                this.disableAllEditMenusAndButtons();
            }
        }

        private void disableAllEditMenusAndButtons() {
            Coordinator.this._cut.setTarget(null);
            Coordinator.this._copy.setTarget(null);
            Coordinator.this._paste.setTarget(null);
            Coordinator.this._delete.setTarget(null);
            Coordinator.this._moveUp.setTarget(null);
            Coordinator.this._moveDown.setTarget(null);
        }

        private void enableTextEditActions(JTextComponent target) {
            boolean editable = target.isEditable() && target.isEnabled();
            Coordinator.this._cutText.setEnabled(editable);
            Coordinator.this._copyText.setEnabled(true);
            Coordinator.this._pasteText.setEnabled(editable);
            Coordinator.this._deleteText.setEnabled(editable);
            Coordinator.this._deleteText.setTarget(target);
            if (Coordinator.this._copy.getTarget() != Coordinator.this._copyText) {
                Coordinator.this._cut.setTarget(Coordinator.this._cutText);
                Coordinator.this._copy.setTarget(Coordinator.this._copyText);
                Coordinator.this._paste.setTarget(Coordinator.this._pasteText);
                Coordinator.this._delete.setTarget(Coordinator.this._deleteText);
                Coordinator.this._moveUp.setTarget(null);
                Coordinator.this._moveDown.setTarget(null);
            }
        }

        private void enableTreetEditActions() {
            if (Coordinator.this._copy.getTarget() != Coordinator.this._appActionsForMenu.get(13)) {
                Coordinator.this._cut.setTarget(null);
                Coordinator.this._copy.setTarget(Coordinator.this._appActionsForMenu.get(13));
                Coordinator.this._paste.setTarget(Coordinator.this._appActionsForMenu.get(14));
                Coordinator.this._delete.setTarget(Coordinator.this._appActionsForMenu.get(15));
                Coordinator.this._moveUp.setTarget(Coordinator.this._appActionsForMenu.get(18));
                Coordinator.this._moveDown.setTarget(Coordinator.this._appActionsForMenu.get(19));
            }
        }
    }

    private class DeleteTextAction
    extends AbstractAction {
        private JTextComponent _target;

        public DeleteTextAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            Action a;
            if (this._target != null && (a = this._target.getActionMap().get("delete-next")) != null) {
                a.actionPerformed(new ActionEvent(this._target, 1001, null));
            }
        }

        void setTarget(JTextComponent t) {
            this._target = t;
        }
    }

    private class ActionWrapper
    extends AbstractAction
    implements PropertyChangeListener {
        private Action _target;

        public ActionWrapper(String name) {
            super(name);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (this._target != null) {
                this._target.actionPerformed(e);
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            PropertyChangeListener[] l = this.getPropertyChangeListeners();
            for (int i = 0; i < l.length; ++i) {
                l[i].propertyChange(e);
            }
        }

        void setTarget(Action t) {
            if (this._target != t) {
                if (this._target != null) {
                    this._target.removePropertyChangeListener(this);
                }
                this._target = t;
                if (this._target != null) {
                    this._target.addPropertyChangeListener(this);
                    this.setEnabled(this._target.isEnabled());
                } else {
                    this.setEnabled(false);
                }
            }
        }

        Action getTarget() {
            return this._target;
        }
    }

    private class StatusBarI
    extends JPanel
    implements StatusBar {
        JLabel _connectedLabel;
        JLabel _text;

        StatusBarI() {
            super(new BorderLayout());
            this.setBorder(new EmptyBorder(0, 13, 10, 13));
            this._text = new JLabel();
            this._text.setHorizontalAlignment(2);
            this.add((Component)this._text, "Before");
            this._connectedLabel = new JLabel("Working Offline");
            this._connectedLabel.setHorizontalAlignment(4);
            this.add((Component)this._connectedLabel, "After");
        }

        public void setText(String text) {
            this._text.setText(text);
        }

        public void setConnected(boolean connected) {
            if (connected) {
                this._connectedLabel.setText("Working Online");
            } else {
                this._connectedLabel.setText("Working Offline");
            }
        }
    }
}

