/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Ice.Current;
import IceGrid.AdapterDynamicInfo;
import IceGrid.NodeDynamicInfo;
import IceGrid.ServerDynamicInfo;
import IceGrid._NodeObserverDisp;
import IceGridGUI.Coordinator;
import javax.swing.SwingUtilities;

class NodeObserverI
extends _NodeObserverDisp {
    private final Coordinator _coordinator;
    private final boolean _trace;

    NodeObserverI(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._trace = this._coordinator.traceObservers();
    }

    public void nodeInit(final NodeDynamicInfo[] nodes, Current current) {
        if (this._trace) {
            if (nodes.length == 0) {
                this._coordinator.traceObserver("nodeInit (no node)");
            } else {
                String names = "";
                for (int i = 0; i < nodes.length; ++i) {
                    names = names + " " + nodes[i].info.name;
                }
                this._coordinator.traceObserver("nodeInit for node" + (nodes.length == 1 ? "" : "s") + names);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < nodes.length; ++i) {
                    NodeObserverI.this._coordinator.nodeUp(nodes[i]);
                }
            }
        });
    }

    public void nodeUp(final NodeDynamicInfo nodeInfo, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("nodeUp for node " + nodeInfo.info.name);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NodeObserverI.this._coordinator.nodeUp(nodeInfo);
            }
        });
    }

    public void nodeDown(final String nodeName, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("nodeUp for node " + nodeName);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NodeObserverI.this._coordinator.nodeDown(nodeName);
            }
        });
    }

    public void updateServer(final String node, final ServerDynamicInfo updatedInfo, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("updateServer for server " + updatedInfo.id + " on node " + node + "; new state is " + updatedInfo.state.toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NodeObserverI.this._coordinator.updateServer(node, updatedInfo);
            }
        });
    }

    public void updateAdapter(final String node, final AdapterDynamicInfo updatedInfo, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("updateAdapter for adapter " + updatedInfo.id + " on node " + node + "; new proxy is " + (updatedInfo.proxy == null ? "null" : updatedInfo.proxy.toString()));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NodeObserverI.this._coordinator.updateAdapter(node, updatedInfo);
            }
        });
    }
}

